/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import lts.CompactState;
import lts.EventState;
import lts.LTSOutput;

public class Determinizer {
    static final int TAU = 0;
    CompactState machine;
    LTSOutput output;
    Vector newStates;
    Vector stateSets;
    Hashtable map;
    int nextState;
    int currentState;

    public Determinizer(CompactState compactState, LTSOutput lTSOutput) {
        this.machine = compactState;
        this.output = lTSOutput;
    }

    public CompactState determine() {
        this.output.outln("make DFA(" + this.machine.name + ")");
        this.newStates = new Vector(this.machine.maxStates * 2);
        this.stateSets = new Vector(this.machine.maxStates * 2);
        this.map = new Hashtable(this.machine.maxStates * 2);
        this.nextState = 0;
        this.currentState = 0;
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        this.addState(bitSet);
        while (this.currentState < this.nextState) {
            this.compute(this.currentState);
            ++this.currentState;
        }
        return this.makeNewMachine();
    }

    protected void compute(int n) {
        BitSet bitSet = (BitSet)this.stateSets.elementAt(n);
        EventState eventState = null;
        EventState eventState2 = null;
        int n2 = 0;
        while (n2 < bitSet.size()) {
            if (bitSet.get(n2)) {
                eventState = EventState.union(eventState, this.machine.states[n2]);
            }
            ++n2;
        }
        EventState eventState3 = eventState;
        while (eventState3 != null) {
            boolean bl = false;
            BitSet bitSet2 = new BitSet();
            if (eventState3.next != -1) {
                bitSet2.set(eventState3.next);
            } else {
                bl = true;
            }
            EventState eventState4 = eventState3.nondet;
            while (eventState4 != null) {
                if (eventState4.next != -1) {
                    bitSet2.set(eventState4.next);
                    bl = false;
                }
                eventState4 = eventState4.nondet;
            }
            int n3 = bl ? -1 : this.addState(bitSet2);
            eventState2 = EventState.add(eventState2, new EventState(eventState3.event, n3));
            eventState3 = eventState3.list;
        }
        this.newStates.addElement(eventState2);
    }

    protected int addState(BitSet bitSet) {
        Integer n = (Integer)this.map.get(bitSet);
        if (n != null) {
            return n;
        }
        this.map.put(bitSet, new Integer(this.nextState));
        this.stateSets.addElement(bitSet);
        ++this.nextState;
        return this.nextState - 1;
    }

    protected CompactState makeNewMachine() {
        CompactState compactState = new CompactState();
        compactState.name = this.machine.name;
        compactState.alphabet = new String[this.machine.alphabet.length];
        int n = 0;
        while (n < this.machine.alphabet.length) {
            compactState.alphabet[n] = this.machine.alphabet[n];
            ++n;
        }
        compactState.maxStates = this.nextState;
        compactState.states = new EventState[compactState.maxStates];
        int n2 = 0;
        while (n2 < compactState.maxStates) {
            compactState.states[n2] = (EventState)this.newStates.elementAt(n2);
            ++n2;
        }
        this.output.outln("DFA(" + this.machine.name + ") has " + compactState.maxStates + " states.");
        return compactState;
    }
}

