/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import net.claribole.zvtm.glyphs.projection.RProjectedCoords;

public class VSegment
extends Glyph
implements RectangularShape {
    long vw;
    long vh;
    RProjectedCoords[] pc;

    public VSegment() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.orient = 0.0f;
        this.size = 10.0f;
        this.computeEdges();
        this.setColor(Color.white);
    }

    public VSegment(long x, long y, int z, long w, long h, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.setColor(c);
    }

    public VSegment(long x1, long y1, int z, Color c, long x2, long y2) {
        this.vx = (x1 + x2) / 2L;
        this.vy = (y1 + y2) / 2L;
        this.vz = z;
        this.vw = (x2 - x1) / 2L;
        this.vh = (y2 - y1) / 2L;
        this.computeSize();
        this.setColor(c);
    }

    public VSegment(long x, long y, int z, float lgth, float angle, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.orient = angle;
        this.size = lgth;
        this.computeEdges();
        this.setColor(c);
    }

    public void initCams(int nbCam) {
        this.pc = new RProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoords();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoords[] ta = this.pc;
                this.pc = new RProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoords();
            } else {
                System.err.println("VSegment:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoords[1];
            this.pc[0] = new RProjectedCoords();
        } else {
            System.err.println("VSegment:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - this.vw, this.vy + this.vh, this.vx + this.vw, this.vy - this.vh};
        return res;
    }

    public void setEndPoints(long x1, long y1, long x2, long y2) {
        this.vx = (x1 + x2) / 2L;
        this.vy = (y1 + y2) / 2L;
        this.vw = (x2 - x1) / 2L;
        this.vh = (y2 - y1) / 2L;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public LongPoint[] getEndPoints() {
        LongPoint[] res = new LongPoint[]{new LongPoint(this.vx + this.vw, this.vy + this.vh), new LongPoint(this.vx - this.vw, this.vy - this.vh)};
        return res;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
        if (this.vw != 0L) {
            this.orient = (float)Math.atan((float)this.vh / (float)this.vw);
        } else {
            float f = this.orient = this.vh > 0L ? 1.5707964f : -1.5707964f;
        }
        if (this.orient < 0.0f) {
            this.orient = this.vh > 0L ? (float)Math.PI - this.orient : -this.orient;
        } else if (this.orient > 0.0f) {
            this.orient = this.vh > 0L ? (float)Math.PI * 2 - this.orient : (float)Math.PI - this.orient;
        } else if (this.orient == 0.0f && this.vw < 0L) {
            this.orient = (float)Math.PI;
        }
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.computeEdges();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidth(long w) {
        this.vw = w;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long h) {
        this.vh = h;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidthHeight(long w, long h) {
        this.vw = w;
        this.vh = h;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    void computeEdges() {
        this.vw = Math.round((double)this.size * Math.cos(this.orient));
        this.vh = Math.round((double)this.size * Math.sin(this.orient));
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public boolean intersects(int x, int y, int camIndex) {
        return this.intersects(x, y, 2, camIndex);
    }

    public boolean intersects(int x, int y, int tolerance, int camIndex) {
        return Line2D.ptSegDist(this.pc[camIndex].cx - this.pc[camIndex].cw, this.pc[camIndex].cy + this.pc[camIndex].ch, this.pc[camIndex].cx + this.pc[camIndex].cw, this.pc[camIndex].cy - this.pc[camIndex].ch, x, y) <= (double)tolerance;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Line2D.ptSegDist(this.vx - this.vw, this.vy - this.vh, this.vx + this.vw, this.vy + this.vh, dvx, dvy) <= (double)dvr;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cw = Math.round((float)this.vw * this.coef);
        this.pc[i].ch = Math.round((float)this.vh * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcw = Math.round((float)this.vw * this.coef);
        this.pc[i].lch = Math.round((float)this.vh * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
            g.setStroke(stdS);
        } else {
            g.drawLine(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy + this.pc[i].ch, dx + this.pc[i].cx + this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
            g.setStroke(stdS);
        } else {
            g.drawLine(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy + this.pc[i].lch, dx + this.pc[i].lcx + this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
        }
    }

    public Object clone() {
        VSegment res = new VSegment(this.vx, this.vy, 0, this.vw, this.vh, this.color);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.mouseInsideColor != null) {
                this.color = this.mouseInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.mouseInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
    }
}

