/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import java.awt.Shape;
import java.awt.geom.Line2D;
import net.claribole.zvtm.glyphs.PathElement;

class SEGElement
extends PathElement {
    Line2D[] pc;
    Line2D[] lpc;

    SEGElement(long x, long y) {
        this.type = 1;
        this.x = x;
        this.y = y;
    }

    void initCams(int nbCam) {
        this.pc = new Line2D[nbCam];
        this.lpc = new Line2D[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new Line2D.Double();
            this.lpc[i] = new Line2D.Double();
        }
    }

    void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                Line2D[] ta = this.pc;
                this.pc = new Line2D[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new Line2D.Double();
                ta = this.lpc;
                this.lpc = new Line2D[ta.length + 1];
                System.arraycopy(ta, 0, this.lpc, 0, ta.length);
                this.lpc[this.lpc.length - 1] = new Line2D.Double();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new Line2D[1];
            this.pc[0] = new Line2D.Double();
            this.lpc = new Line2D[1];
            this.lpc[0] = new Line2D.Double();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
    }

    void removeCamera(int index) {
        this.pc[index] = null;
        this.lpc[index] = null;
    }

    void project(int i, int hw, int hh, Camera c, float coef, double px, double py) {
        this.pc[i].setLine(px, py, (float)hw + (float)(this.x - c.posx) * coef, (float)hh - (float)(this.y - c.posy) * coef);
    }

    void projectForLens(int i, int hw, int hh, long lx, long ly, float coef, double px, double py) {
        this.lpc[i].setLine(px, py, (float)hw + (float)(this.x - lx) * coef, (float)hh - (float)(this.y - ly) * coef);
    }

    double getX(int i) {
        return this.pc[i].getX2();
    }

    double getY(int i) {
        return this.pc[i].getY2();
    }

    double getlX(int i) {
        return this.lpc[i].getX2();
    }

    double getlY(int i) {
        return this.lpc[i].getY2();
    }

    Shape getShape(int i) {
        return this.pc[i];
    }

    Shape getlShape(int i) {
        return this.lpc[i];
    }
}

