require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PTRACE_H_)) {
    eval 'sub _SYS_PTRACE_H_ () {1;}' unless defined(&_SYS_PTRACE_H_);
    require 'sys/siginfo.ph';
    require 'sys/signal.ph';
    eval 'sub PT_TRACE_ME () {0;}' unless defined(&PT_TRACE_ME);
    eval 'sub PT_READ_I () {1;}' unless defined(&PT_READ_I);
    eval 'sub PT_READ_D () {2;}' unless defined(&PT_READ_D);
    eval 'sub PT_WRITE_I () {4;}' unless defined(&PT_WRITE_I);
    eval 'sub PT_WRITE_D () {5;}' unless defined(&PT_WRITE_D);
    eval 'sub PT_CONTINUE () {7;}' unless defined(&PT_CONTINUE);
    eval 'sub PT_KILL () {8;}' unless defined(&PT_KILL);
    eval 'sub PT_ATTACH () {9;}' unless defined(&PT_ATTACH);
    eval 'sub PT_DETACH () {10;}' unless defined(&PT_DETACH);
    eval 'sub PT_IO () {11;}' unless defined(&PT_IO);
    eval 'sub PT_DUMPCORE () {12;}' unless defined(&PT_DUMPCORE);
    if(defined(&__LEGACY_PT_LWPINFO) || defined(&_KERNEL)) {
	eval 'sub PT_LWPINFO () {13;}' unless defined(&PT_LWPINFO);
    }
    eval 'sub PT_SYSCALL () {14;}' unless defined(&PT_SYSCALL);
    eval 'sub PT_SYSCALLEMU () {15;}' unless defined(&PT_SYSCALLEMU);
    eval 'sub PT_SET_EVENT_MASK () {16;}' unless defined(&PT_SET_EVENT_MASK);
    eval 'sub PT_GET_EVENT_MASK () {17;}' unless defined(&PT_GET_EVENT_MASK);
    eval 'sub PT_GET_PROCESS_STATE () {18;}' unless defined(&PT_GET_PROCESS_STATE);
    eval 'sub PT_SET_SIGINFO () {19;}' unless defined(&PT_SET_SIGINFO);
    eval 'sub PT_GET_SIGINFO () {20;}' unless defined(&PT_GET_SIGINFO);
    eval 'sub PT_RESUME () {21;}' unless defined(&PT_RESUME);
    eval 'sub PT_SUSPEND () {22;}' unless defined(&PT_SUSPEND);
    eval 'sub PT_STOP () {23;}' unless defined(&PT_STOP);
    eval 'sub PT_LWPSTATUS () {24;}' unless defined(&PT_LWPSTATUS);
    eval 'sub PT_LWPNEXT () {25;}' unless defined(&PT_LWPNEXT);
    eval 'sub PT_SET_SIGPASS () {26;}' unless defined(&PT_SET_SIGPASS);
    eval 'sub PT_GET_SIGPASS () {27;}' unless defined(&PT_GET_SIGPASS);
    eval 'sub PT_FIRSTMACH () {32;}' unless defined(&PT_FIRSTMACH);
    require 'machine/ptrace.ph';
    eval 'sub PT_STRINGS () {"PT_TRACE_ME", "PT_READ_I", "PT_READ_D", "*PT_INVALID_3*", "PT_WRITE_I", "PT_WRITE_D", "*PT_INVALID_6*", "PT_CONTINUE", "PT_KILL", "PT_ATTACH", "PT_DETACH", "PT_IO", "PT_DUMPCORE", "PT_LWPINFO", "PT_SYSCALL", "PT_SYSCALLEMU", "PT_SET_EVENT_MASK", "PT_GET_EVENT_MASK", "PT_GET_PROCESS_STATE", "PT_SET_SIGINFO", "PT_GET_SIGINFO", "PT_RESUME", "PT_SUSPEND", "PT_STOP", "PT_LWPSTATUS", "PT_LWPNEXT", "PT_SET_SIGPASS", "PT_GET_SIGPASS";}' unless defined(&PT_STRINGS);
    eval 'sub pe_other_pid () { ($_option->{_pe_other_pid});}' unless defined(&pe_other_pid);
    eval 'sub pe_lwp () { ($_option->{_pe_lwp});}' unless defined(&pe_lwp);
    eval 'sub PTRACE_FORK () {0x1;}' unless defined(&PTRACE_FORK);
    eval 'sub PTRACE_VFORK () {0x2;}' unless defined(&PTRACE_VFORK);
    eval 'sub PTRACE_VFORK_DONE () {0x4;}' unless defined(&PTRACE_VFORK_DONE);
    eval 'sub PTRACE_LWP_CREATE () {0x8;}' unless defined(&PTRACE_LWP_CREATE);
    eval 'sub PTRACE_LWP_EXIT () {0x10;}' unless defined(&PTRACE_LWP_EXIT);
    eval 'sub PTRACE_POSIX_SPAWN () {0x20;}' unless defined(&PTRACE_POSIX_SPAWN);
    eval 'sub PIOD_READ_D () {1;}' unless defined(&PIOD_READ_D);
    eval 'sub PIOD_WRITE_D () {2;}' unless defined(&PIOD_WRITE_D);
    eval 'sub PIOD_READ_I () {3;}' unless defined(&PIOD_READ_I);
    eval 'sub PIOD_WRITE_I () {4;}' unless defined(&PIOD_WRITE_I);
    eval 'sub PIOD_READ_AUXV () {5;}' unless defined(&PIOD_READ_AUXV);
    if(defined(&__LEGACY_PT_LWPINFO) || defined(&_KERNEL)) {
	eval 'sub PL_EVENT_NONE () {0;}' unless defined(&PL_EVENT_NONE);
	eval 'sub PL_EVENT_SIGNAL () {1;}' unless defined(&PL_EVENT_SIGNAL);
	eval 'sub PL_EVENT_SUSPENDED () {2;}' unless defined(&PL_EVENT_SUSPENDED);
    }
    eval 'sub PL_LNAMELEN () {20;}' unless defined(&PL_LNAMELEN);
    if(defined(&_KERNEL)) {
	if(defined(&_KERNEL_OPT)) {
	    require './sys/opt_compat_netbsd32.ph';
	}
	if(defined(&COMPAT_NETBSD32)) {
	    require 'compat/netbsd32/netbsd32.ph';
	    eval 'sub process_read_lwpstatus32 () { &netbsd32_read_lwpstatus;}' unless defined(&process_read_lwpstatus32);
	    eval 'sub process_lwpstatus32 () {\'struct netbsd32_ptrace_lwpstatus\';}' unless defined(&process_lwpstatus32);
	}
	unless(defined(&process_lwpstatus32)) {
	    eval 'sub process_lwpstatus32 () {\'struct ptrace_lwpstatus\';}' unless defined(&process_lwpstatus32);
	}
	unless(defined(&process_lwpstatus64)) {
	    eval 'sub process_lwpstatus64 () {\'struct ptrace_lwpstatus\';}' unless defined(&process_lwpstatus64);
	}
	if(defined(&PT_GETREGS) || defined(&PT_SETREGS)) {
	    unless(defined(&process_reg32)) {
		eval 'sub process_reg32 () {\'struct reg\';}' unless defined(&process_reg32);
	    }
	    unless(defined(&process_reg64)) {
		eval 'sub process_reg64 () {\'struct reg\';}' unless defined(&process_reg64);
	    }
	}
	if(defined(&PT_GETFPREGS) || defined(&PT_SETFPREGS)) {
	    unless(defined(&process_fpreg32)) {
		eval 'sub process_fpreg32 () {\'struct fpreg\';}' unless defined(&process_fpreg32);
	    }
	    unless(defined(&process_fpreg64)) {
		eval 'sub process_fpreg64 () {\'struct fpreg\';}' unless defined(&process_fpreg64);
	    }
	}
	if(defined(&PT_GETDBREGS) || defined(&PT_SETDBREGS)) {
	    unless(defined(&process_dbreg32)) {
		eval 'sub process_dbreg32 () {\'struct dbreg\';}' unless defined(&process_dbreg32);
	    }
	    unless(defined(&process_dbreg64)) {
		eval 'sub process_dbreg64 () {\'struct dbreg\';}' unless defined(&process_dbreg64);
	    }
	}
	unless(defined(&process_read_lwpstatus32)) {
	    eval 'sub process_read_lwpstatus32 () { &process_read_lwpstatus;}' unless defined(&process_read_lwpstatus32);
	}
	unless(defined(&process_read_lwpstatus64)) {
	    eval 'sub process_read_lwpstatus64 () { &process_read_lwpstatus;}' unless defined(&process_read_lwpstatus64);
	}
	if(defined(&PT_GETDBREGS)) {
	    unless(defined(&process_read_dbregs32)) {
		eval 'sub process_read_dbregs32 () { &process_read_dbregs;}' unless defined(&process_read_dbregs32);
	    }
	    unless(defined(&process_read_dbregs64)) {
		eval 'sub process_read_dbregs64 () { &process_read_dbregs;}' unless defined(&process_read_dbregs64);
	    }
	}
	if(defined(&PT_GETFPREGS)) {
	    unless(defined(&process_read_fpregs32)) {
		eval 'sub process_read_fpregs32 () { &process_read_fpregs;}' unless defined(&process_read_fpregs32);
	    }
	    unless(defined(&process_read_fpregs64)) {
		eval 'sub process_read_fpregs64 () { &process_read_fpregs;}' unless defined(&process_read_fpregs64);
	    }
	}
	if(defined(&PT_GETREGS)) {
	    unless(defined(&process_read_regs32)) {
		eval 'sub process_read_regs32 () { &process_read_regs;}' unless defined(&process_read_regs32);
	    }
	    unless(defined(&process_read_regs64)) {
		eval 'sub process_read_regs64 () { &process_read_regs;}' unless defined(&process_read_regs64);
	    }
	}
	if(defined(&PT_SETDBREGS)) {
	    unless(defined(&process_write_dbregs32)) {
		eval 'sub process_write_dbregs32 () { &process_write_dbregs;}' unless defined(&process_write_dbregs32);
	    }
	    unless(defined(&process_write_dbregs64)) {
		eval 'sub process_write_dbregs64 () { &process_write_dbregs;}' unless defined(&process_write_dbregs64);
	    }
	}
	if(defined(&PT_SETFPREGS)) {
	    unless(defined(&process_write_fpregs32)) {
		eval 'sub process_write_fpregs32 () { &process_write_fpregs;}' unless defined(&process_write_fpregs32);
	    }
	    unless(defined(&process_write_fpregs64)) {
		eval 'sub process_write_fpregs64 () { &process_write_fpregs;}' unless defined(&process_write_fpregs64);
	    }
	}
	if(defined(&PT_SETREGS)) {
	    unless(defined(&process_write_regs32)) {
		eval 'sub process_write_regs32 () { &process_write_regs;}' unless defined(&process_write_regs32);
	    }
	    unless(defined(&process_write_regs64)) {
		eval 'sub process_write_regs64 () { &process_write_regs;}' unless defined(&process_write_regs64);
	    }
	}
	unless(defined(&FIX_SSTEP)) {
	    eval 'sub FIX_SSTEP {
	        my($p) = @_;
    		eval q();
	    }' unless defined(&FIX_SSTEP);
	}
	if(defined(&PTRACE)) {
	    if(defined(&PT_SETREGS) || defined(&PT_GETREGS) ) {
		eval 'sub PT_REGS () {1;}' unless defined(&PT_REGS);
	    }
	    if(defined(&PT_SETFPREGS) || defined(&PT_GETFPREGS) ) {
		eval 'sub PT_FPREGS () {1;}' unless defined(&PT_FPREGS);
	    }
	    if(defined(&PT_SETDBREGS) || defined(&PT_GETDBREGS) ) {
		eval 'sub PT_DBREGS () {1;}' unless defined(&PT_DBREGS);
	    }
	    if(defined(&PT_REGS) || defined(&PT_FPREGS) || defined(&PT_DBREGS)) {
		eval 'sub PT_REGISTERS () {1;}' unless defined(&PT_REGISTERS);
	    }
	}
    } else {
	require 'sys/cdefs.ph';
    }
}
1;
