/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Processor;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.ConstantFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQNBase;

class MethodFQN
extends ConstantFQN {
    @NotNull
    private final String myMethodName;

    MethodFQN(@NotNull List<String> path, @NotNull byte[] colors, boolean isTopLevel, @NotNull String methodName) {
        if (path == null) {
            MethodFQN.$$$reportNull$$$0(0);
        }
        if (colors == null) {
            MethodFQN.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            MethodFQN.$$$reportNull$$$0(2);
        }
        super(path, colors, isTopLevel);
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getFullPath() {
        String classFQN = super.getFullPath();
        if (classFQN.isEmpty()) {
            String string = this.myMethodName;
            if (string == null) {
                MethodFQN.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = classFQN + "." + this.myMethodName;
        if (string == null) {
            MethodFQN.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.myMethodName;
        if (string == null) {
            MethodFQN.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public Stream<String> asStream() {
        Stream<String> stream = Stream.concat(super.asStream(), Stream.of(this.myMethodName));
        if (stream == null) {
            MethodFQN.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @Override
    @NotNull
    public List<String> asList() {
        List<String> list = this.asStream().collect(Collectors.toList());
        if (list == null) {
            MethodFQN.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean processNestingResolution(@NotNull Processor<FQN> processor) {
        if (processor == null) {
            MethodFQN.$$$reportNull$$$0(8);
        }
        Logger.getInstance(MethodFQN.class).warn("Methods can't be used as parent containers for constant resolution. FQN=<" + this.toString() + ">");
        return true;
    }

    @Override
    @NotNull
    public FQN getCallerFQN() {
        if (this.getRawPath().isEmpty()) {
            FQN fQN = INVALID;
            if (fQN == null) {
                MethodFQN.$$$reportNull$$$0(9);
            }
            return fQN;
        }
        ConstantFQN constantFQN = new ConstantFQN(this);
        if (constantFQN == null) {
            MethodFQN.$$$reportNull$$$0(10);
        }
        return constantFQN;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.myMethodName == ((MethodFQN)o).myMethodName;
    }

    @Override
    @NotNull
    protected FQNBase.SerializationFactory getSerializationFactory() {
        SerializationFactory serializationFactory = SerializationFactory.INSTANCE;
        if (serializationFactory == null) {
            MethodFQN.$$$reportNull$$$0(11);
        }
        return serializationFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallerFQN";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processNestingResolution";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum SerializationFactory implements FQNBase.SerializationFactory
    {
        INSTANCE;


        @Override
        public void serialize(@NotNull FQN fqn, @NotNull StubOutputStream stream) throws IllegalArgumentException, IOException {
            if (fqn == null) {
                SerializationFactory.$$$reportNull$$$0(0);
            }
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(1);
            }
            if (!(fqn instanceof MethodFQN)) {
                throw new IllegalArgumentException("unexpected class " + fqn);
            }
            ConstantFQN.SerializationFactory.INSTANCE.serialize(fqn, stream);
            stream.writeName(((MethodFQN)fqn).myMethodName);
        }

        @Override
        @NotNull
        public MethodFQN deserialize(@NotNull StubInputStream stream) throws IllegalArgumentException, IOException {
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(2);
            }
            ConstantFQN fqn = ConstantFQN.SerializationFactory.INSTANCE.deserialize(stream);
            String ref = stream.readNameString();
            MethodFQN methodFQN = new MethodFQN(fqn.getRawPath(), ConstantFQN.createSameColors(fqn.getRawPath().size()), fqn.isToplevel(), FQNBase.INTERNER.intern(StringUtil.notNullize((String)ref)));
            if (methodFQN == null) {
                SerializationFactory.$$$reportNull$$$0(3);
            }
            return methodFQN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN$SerializationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN$SerializationFactory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deserialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deserialize";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

