/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.TextMateFileType;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;

public class TextMateBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (file.getFileType() == TextMateFileType.INSTANCE) {
            char prevChar;
            Document document;
            String scopeSelector;
            TextMateBracePair pairForChar;
            int offset = editor.getCaretModel().getOffset();
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            if (offset == 0 && iterator.atEnd()) {
                return false;
            }
            IElementType tokenType = iterator.getTokenType();
            if (tokenType != null && (pairForChar = TextMateEditorUtils.getSmartTypingPairForLeftChar(c, scopeSelector = tokenType.toString())) != null && (document = editor.getDocument()).getTextLength() > offset && (prevChar = document.getCharsSequence().charAt(offset)) == pairForChar.rightChar) {
                document.deleteString(offset, offset + 1);
                return true;
            }
        }
        return false;
    }
}

