/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.HighlightedRegion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class MultiLineTodoRenderer
extends JPanel
implements TreeCellRenderer {
    private static final int MAX_DISPLAYED_LINES = 10;
    private final HighlightableCellRenderer myPrefixRenderer;
    private final HighlightableCellRenderer[] myLineRenderers = new HighlightableCellRenderer[10];
    private final JLabel myMoreLabel;

    public MultiLineTodoRenderer() {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.myPrefixRenderer = new HighlightableCellRenderer();
        this.add((Component)this.myPrefixRenderer, c);
        c.gridx = 1;
        c.anchor = 17;
        for (int i = 0; i < 10; ++i) {
            c.gridy = i;
            this.myLineRenderers[i] = new HighlightableCellRenderer();
            this.add((Component)this.myLineRenderers[i], c);
        }
        ++c.gridy;
        this.myMoreLabel = new JLabel(IdeBundle.message((String)"node.todo.more.items", (Object[])new Object[0]));
        this.add((Component)this.myMoreLabel, c);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        TodoItemNode node = (TodoItemNode)((DefaultMutableTreeNode)value).getUserObject();
        String text = value.toString();
        int parenPos = text.indexOf(41);
        int contentStartPos = parenPos >= 0 && parenPos < text.length() - 1 ? parenPos + 2 : 0;
        this.myPrefixRenderer.getTreeCellRendererComponent(tree, (Object)text.substring(0, contentStartPos), selected, expanded, leaf, row2, hasFocus);
        this.myPrefixRenderer.setIcon(node.getIcon());
        List<HighlightedRegionProvider> additionalLines = node.getAdditionalLines();
        for (int i = 0; i < 10; ++i) {
            if (i > additionalLines.size()) {
                this.myLineRenderers[i].setVisible(false);
                continue;
            }
            this.myLineRenderers[i].setVisible(true);
            this.myLineRenderers[i].getTreeCellRendererComponent(tree, i == 0 ? text.substring(contentStartPos) : additionalLines.get(i - 1), selected, expanded, leaf, row2, hasFocus);
            TodoItemNode provider = i == 0 ? node : additionalLines.get(i - 1);
            for (HighlightedRegion region : provider.getHighlightedRegions()) {
                this.myLineRenderers[i].addHighlighter(region.startOffset - (i == 0 ? contentStartPos : 0), region.endOffset - (i == 0 ? contentStartPos : 0), region.textAttributes);
            }
        }
        this.myMoreLabel.setVisible(additionalLines.size() >= 10);
        return this;
    }
}

