/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSContextProvider;
import com.intellij.internal.statistic.service.fus.beans.FSGroup;
import com.intellij.internal.statistic.service.fus.beans.FSMetric;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.beans.legacy.FSLegacyContent;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsAggregator;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsDifferenceSender;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.service.fus.collectors.LegacyApplicationUsageTriggers;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsStateService
implements UsagesCollectorConsumer {
    public static FUStatisticsStateService create() {
        return new FUStatisticsStateService();
    }

    public static void clearLegacyCaches() {
        FUStatisticsPersistence.clearLegacyStates();
        LegacyApplicationUsageTriggers.cleanup();
    }

    @Nullable
    public String getMergedDataToSend(@NotNull String actualDataFromCollectors, @NotNull Set<String> approvedGroups) {
        Set<FSSession> allDataFromCollectorsSessions;
        FSContent previousStateContent;
        if (actualDataFromCollectors == null) {
            FUStatisticsStateService.$$$reportNull$$$0(0);
        }
        if (approvedGroups == null) {
            FUStatisticsStateService.$$$reportNull$$$0(1);
        }
        FSContent allDataFromCollectors = FSContent.fromJson(actualDataFromCollectors);
        Set<String> differenceSenders = this.getFUStatisticsDifferenceSenders(approvedGroups);
        if (!differenceSenders.isEmpty() && (previousStateContent = FUStatisticsStateService.loadContent()) != null && (allDataFromCollectorsSessions = allDataFromCollectors.getSessions()) != null) {
            for (FSSession actualSession : allDataFromCollectorsSessions) {
                for (FSGroup actualGroup : this.getActualGroupsToMerge(differenceSenders, actualSession.getGroups())) {
                    Set<FSMetric> persistedMetrics = FUStatisticsStateService.getPersistedMetrics(FUStatisticsStateService.getPreviousSession(previousStateContent, actualSession), actualGroup);
                    if (persistedMetrics.isEmpty()) continue;
                    FUStatisticsStateService.updateDifferenceSenderMetricsData(actualGroup.getMetrics(), persistedMetrics);
                }
            }
        }
        allDataFromCollectors.removeEmptyData();
        if (allDataFromCollectors.sessions == null || allDataFromCollectors.sessions.isEmpty()) {
            return null;
        }
        return allDataFromCollectors.asJsonString();
    }

    @NotNull
    public Set<FSGroup> getActualGroupsToMerge(@NotNull Set<String> differenceSenders, @Nullable List<FSGroup> groups) {
        if (differenceSenders == null) {
            FUStatisticsStateService.$$$reportNull$$$0(2);
        }
        if (groups != null) {
            Set<FSGroup> set = groups.stream().filter(actualGroup -> {
                if (differenceSenders == null) {
                    FUStatisticsStateService.$$$reportNull$$$0(16);
                }
                return differenceSenders.contains(actualGroup.id);
            }).collect(Collectors.toSet());
            if (set == null) {
                FUStatisticsStateService.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<FSGroup> set = Collections.emptySet();
        if (set == null) {
            FUStatisticsStateService.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static void updateDifferenceSenderMetricsData(@NotNull Set<FSMetric> actualMetrics, @NotNull Set<FSMetric> persistedMetrics) {
        if (actualMetrics == null) {
            FUStatisticsStateService.$$$reportNull$$$0(5);
        }
        if (persistedMetrics == null) {
            FUStatisticsStateService.$$$reportNull$$$0(6);
        }
        HashSet toRemove2 = ContainerUtil.newHashSet();
        for (FSMetric actualMetric : actualMetrics) {
            FSMetric persistedValue = FUStatisticsStateService.findMetric(persistedMetrics, actualMetric.id, actualMetric);
            if (persistedValue == null) continue;
            int actualValue = actualMetric.value;
            if (actualValue > persistedValue.value) {
                actualMetric.value = actualValue - persistedValue.value;
                continue;
            }
            if (actualValue != persistedValue.value) continue;
            toRemove2.add(actualMetric);
        }
        if (!toRemove2.isEmpty()) {
            actualMetrics.removeAll(toRemove2);
        }
    }

    @Nullable
    private static FSMetric findMetric(@NotNull Set<FSMetric> persistedMetrics, @NotNull String id, @NotNull FSContextProvider contextProvider) {
        if (persistedMetrics == null) {
            FUStatisticsStateService.$$$reportNull$$$0(7);
        }
        if (id == null) {
            FUStatisticsStateService.$$$reportNull$$$0(8);
        }
        if (contextProvider == null) {
            FUStatisticsStateService.$$$reportNull$$$0(9);
        }
        for (FSMetric metric : persistedMetrics) {
            if (!id.equals(metric.id) || !Objects.equals(contextProvider.context, metric.context)) continue;
            return metric;
        }
        return null;
    }

    public Set<String> getFUStatisticsDifferenceSenders(@NotNull Set<String> approvedGroups) {
        if (approvedGroups == null) {
            FUStatisticsStateService.$$$reportNull$$$0(10);
        }
        HashSet senders = ContainerUtil.newHashSet();
        for (ProjectUsagesCollector projectUsagesCollector : ProjectUsagesCollector.getExtensions(this)) {
            if (!(projectUsagesCollector instanceof FUStatisticsDifferenceSender)) continue;
            senders.add(projectUsagesCollector.getGroupId());
        }
        for (ApplicationUsagesCollector applicationUsagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
            if (!(applicationUsagesCollector instanceof FUStatisticsDifferenceSender)) continue;
            senders.add(applicationUsagesCollector.getGroupId());
        }
        return senders.stream().map(s -> {
            if (approvedGroups == null) {
                FUStatisticsStateService.$$$reportNull$$$0(15);
            }
            if (!approvedGroups.contains(s) && ApplicationManagerEx.getApplicationEx().isInternal()) {
                return FUStatisticsAggregator.createDebugModeId(s);
            }
            return s;
        }).collect(Collectors.toSet());
    }

    @Nullable
    public static FSContent loadContent() {
        String legacyContent = FUStatisticsPersistence.getLegacyStateContent();
        if (legacyContent != null) {
            return FSLegacyContent.migrate(legacyContent);
        }
        String content = FUStatisticsPersistence.getPreviousStateContent();
        if (content == null) {
            return null;
        }
        return FSContent.fromJson(content);
    }

    @Nullable
    public static FSSession getPreviousSession(@Nullable FSContent persistedContent, @NotNull FSSession actualSession) {
        if (actualSession == null) {
            FUStatisticsStateService.$$$reportNull$$$0(11);
        }
        if (persistedContent == null) {
            return null;
        }
        Set<FSSession> sessions = persistedContent.getSessions();
        if (sessions == null) {
            return null;
        }
        for (FSSession previousSession : sessions) {
            if (!previousSession.equals(actualSession)) continue;
            return previousSession;
        }
        return null;
    }

    @NotNull
    public static Set<FSMetric> getPersistedMetrics(@Nullable FSSession persistedSession, @NotNull FSGroup actualGroup) {
        List<FSGroup> persistedGroups;
        if (actualGroup == null) {
            FUStatisticsStateService.$$$reportNull$$$0(12);
        }
        if (persistedSession != null && (persistedGroups = persistedSession.getGroups()) != null) {
            for (FSGroup group : persistedGroups) {
                if (!actualGroup.id.equals(group.id) || !Objects.equals(actualGroup.context, group.context)) continue;
                Set<FSMetric> set = group.getMetrics();
                if (set == null) {
                    FUStatisticsStateService.$$$reportNull$$$0(13);
                }
                return set;
            }
        }
        Set<FSMetric> set = Collections.emptySet();
        if (set == null) {
            FUStatisticsStateService.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualDataFromCollectors";
                break;
            }
            case 1: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "approvedGroups";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differenceSenders";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsStateService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualMetrics";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistedMetrics";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualSession";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsStateService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualGroupsToMerge";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistedMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMergedDataToSend";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActualGroupsToMerge";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDifferenceSenderMetricsData";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findMetric";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFUStatisticsDifferenceSenders";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousSession";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedMetrics";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFUStatisticsDifferenceSenders$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getActualGroupsToMerge$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

