/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.javafx;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.javafx.JFXPanelWrapper;
import com.intellij.util.ui.JBUI;
import com.sun.javafx.application.PlatformImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxHtmlPanel
implements Disposable {
    @NotNull
    private final JPanel myPanelWrapper;
    @NotNull
    private final List<Runnable> myInitActions = new ArrayList<Runnable>();
    @Nullable
    private JFXPanel myPanel;
    @Nullable
    protected WebView myWebView;

    public JavaFxHtmlPanel() {
        this.myPanelWrapper = new JPanel(new BorderLayout());
        this.myPanelWrapper.setBackground(JBColor.background());
        ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> PlatformImpl.startup(() -> {
            this.myWebView = new WebView();
            this.myWebView.setContextMenuEnabled(false);
            this.myWebView.setZoom((double)JBUI.scale((float)1.0f));
            WebEngine engine = this.myWebView.getEngine();
            this.registerListeners(engine);
            Scene scene = new Scene((Parent)this.myWebView);
            ApplicationManager.getApplication().invokeLater(() -> JavaFxHtmlPanel.runFX(() -> {
                this.myPanel = new JFXPanelWrapper();
                Platform.runLater(() -> this.myPanel.setScene(scene));
                this.setHtml("");
                for (Runnable action : this.myInitActions) {
                    Platform.runLater((Runnable)action);
                }
                this.myInitActions.clear();
                this.myPanelWrapper.add((Component)this.myPanel, "Center");
                this.myPanelWrapper.repaint();
            }));
        })));
    }

    protected void registerListeners(@NotNull WebEngine engine) {
        if (engine == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(0);
        }
    }

    private static void runFX(@NotNull Runnable r) {
        if (r == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(1);
        }
        IdeEventQueue.unsafeNonblockingExecute(r);
    }

    protected void runInPlatformWhenAvailable(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPanel == null) {
            this.myInitActions.add(runnable2);
        } else {
            Platform.runLater((Runnable)runnable2);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanelWrapper;
        if (jPanel == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void setHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(4);
        }
        String htmlToRender = this.prepareHtml(html);
        this.runInPlatformWhenAvailable(() -> this.getWebViewGuaranteed().getEngine().loadContent(htmlToRender));
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        if (html == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(5);
        }
        String string = html;
        if (string == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void render() {
        this.runInPlatformWhenAvailable(() -> {
            this.getWebViewGuaranteed().getEngine().reload();
            ApplicationManager.getApplication().invokeLater(this.myPanelWrapper::repaint);
        });
    }

    public void dispose() {
    }

    @NotNull
    protected WebView getWebViewGuaranteed() {
        if (this.myWebView == null) {
            throw new IllegalStateException("WebView should be initialized by now. Check the caller thread");
        }
        WebView webView = this.myWebView;
        if (webView == null) {
            JavaFxHtmlPanel.$$$reportNull$$$0(7);
        }
        return webView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/javafx/JavaFxHtmlPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/javafx/JavaFxHtmlPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebViewGuaranteed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerListeners";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runFX";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runInPlatformWhenAvailable";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

