/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    private static final Condition<PsiElement> HAS_DECLARATIONS = TypeScriptTypeEvaluator::hasInnerDeclarations;
    private static final String THIS_TYPE_NAME = "ThisType";

    public TypeScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        super(context, processor);
    }

    @Nullable
    private static JSType toFalsy(@Nullable JSType type, JSTypeSource source) {
        if (JSTypeCastUtil.isFalsy(type)) {
            return type;
        }
        if (type instanceof JSStringType && !(type instanceof JSStringLiteralTypeImpl)) {
            return new JSStringLiteralTypeImpl("", false, source);
        }
        if (type instanceof JSNumberType && !(type instanceof JSNumberLiteralTypeImpl)) {
            return new JSNumberLiteralTypeImpl(0.0, false, source, "0");
        }
        if (type instanceof JSBigIntType && !(type instanceof JSBigIntLiteralTypeImpl)) {
            return new JSBigIntLiteralTypeImpl(BigInteger.ZERO, false, source, "0n");
        }
        if (type instanceof JSBooleanType && !(type instanceof JSBooleanLiteralTypeImpl)) {
            return new JSBooleanLiteralTypeImpl(false, false, source);
        }
        return null;
    }

    @Nullable
    private static JSType toFalsyTypeAfterAndOperator(@Nullable JSType type, JSTypeSource source) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSCompositeTypeImpl) {
            ArrayList allFalsy = ContainerUtil.newArrayList();
            for (JSType part : ((JSCompositeTypeImpl)type).getTypes()) {
                JSType falsy = TypeScriptTypeEvaluator.toFalsy(part, source);
                if (falsy == null) continue;
                allFalsy.add(falsy);
            }
            return allFalsy.isEmpty() ? null : new JSCompositeTypeImpl(source, allFalsy);
        }
        return TypeScriptTypeEvaluator.toFalsy(type, source);
    }

    @Override
    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (binaryExpression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(0);
        }
        super.evaluatePlusType(binaryExpression, JSCompositeTypeImpl.optimizeTypeIfComposite(lProcType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED), JSCompositeTypeImpl.optimizeTypeIfComposite(rProcType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED));
    }

    @Override
    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        boolean isTypeScript;
        boolean strictNullChecks;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (sign == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(2);
        }
        boolean bl = strictNullChecks = (isTypeScript = DialectDetector.isTypeScript((PsiElement)rawqualifier)) && TypeScriptConfigUtil.strictNullChecks((PsiElement)rawqualifier);
        if (strictNullChecks) {
            if (sign == JSTokenTypes.OROR) {
                lProcType = JSCompositeTypeImpl.optimizeTypeIfComposite(lProcType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY);
            } else if (sign == JSTokenTypes.ANDAND) {
                lProcType = TypeScriptTypeEvaluator.toFalsyTypeAfterAndOperator(lProcType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
            }
        }
        if (isTypeScript && lProcType != null && rProcType != null && sign == JSTokenTypes.OROR) {
            JSType common = TypeScriptTypeRelations.getBestChoiceType(lProcType, rProcType, (PsiElement)rawqualifier);
            this.addType(common, (PsiElement)rawqualifier);
            return;
        }
        if (lProcType != null && (sign == JSTokenTypes.OROR || !isTypeScript || strictNullChecks)) {
            this.addType(lProcType, (PsiElement)rawqualifier);
        }
        if (rProcType != null) {
            this.addType(rProcType, (PsiElement)rawqualifier);
        }
        if (lProcType == null && rProcType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            JSTypeDeclaration propertyType = propertySignature.getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = propertySignature.getType();
                this.addType(jsType, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptIndexSignature) {
            JSReferenceExpression expression = this.myContext.getProcessedExpression();
            if (expression != null) {
                JSType type = ((TypeScriptIndexSignature)resolveResult).getMemberType();
                this.addType(type, resolveResult);
                return true;
            }
        } else {
            if (resolveResult instanceof TypeScriptCallSignature) {
                JSApplyContextElement peek = this.myContext.peekJSElementToApply();
                TypeScriptCallSignature callSignature = (TypeScriptCallSignature)resolveResult;
                if (callSignature.hasNew() ? peek instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)peek).getNewExpression() != null : peek instanceof JSApplyCallElement) {
                    this.myContext.processWithoutTopJSElementToApply(() -> this.addType(callSignature.getReturnType(), resolveResult));
                }
                return true;
            }
            if (resolveResult instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement element : ((TypeScriptGlobalModuleExportDeclaration)resolveResult).getModules()) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
                return true;
            }
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (resolveResult.isShorthandAmbientModule()) {
            this.addType(JSAnyType.get((PsiElement)resolveResult, true), (PsiElement)resolveResult);
            return;
        }
        this.addTypeFromLocalModule(resolveResult, expression != null && DialectDetector.isJavaScript((PsiElement)expression));
    }

    private boolean shouldAddLocalModule(boolean hasType, boolean isJavaScriptContext) {
        return !(this.myTypeProcessor instanceof PsiScopeProcessor) || isJavaScriptContext || hasType || this.myContext.isJSElementsToApplyEmpty();
    }

    private void addTypeFromLocalModule(@NotNull TypeScriptModule resolveResult, boolean isJavaScriptContext) {
        String name;
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmpty((String)(name = resolveResult.getName()))) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getParent(), true);
            JSType jsType = JSNamedTypeFactory.createType(name, source, isJavaScriptContext ? JSContext.UNKNOWN : JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement resolveResult) {
        this.processItem(resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, importStatement -> {
            TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
            if (internalModuleReference != null) {
                List<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
                this.addTypeFromInternalModules(elements);
            } else if (externalModuleReference != null) {
                Collection elements = externalModuleReference.multiResolve();
                for (PsiElement element : elements) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            }
        });
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        boolean isJavaScriptContext;
        boolean hasType;
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item);
            return;
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        List modules = elements.stream().filter(TypeScriptModule.class::isInstance).map(TypeScriptModule.class::cast).collect(Collectors.toList());
        if (!modules.isEmpty() && this.shouldAddLocalModule(hasType = !ContainerUtil.filter(elements, HAS_DECLARATIONS).isEmpty(), isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            TypeScriptModule module = (TypeScriptModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            this.addTypeFromLocalModule(module, isJavaScriptContext);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element);
        }
    }

    @Override
    protected JSType modifyTypeForEnumType(@NotNull JSResolvableType type, @NotNull JSFieldVariable jsVariable) {
        if (type == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (jsVariable instanceof TypeScriptEnumField) {
            return JSNamedTypeFactory.createEnumLiteralType(type, jsVariable).copyWithAllowWidening(true);
        }
        return type;
    }

    @Override
    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(6);
        }
        super.addTypeFromVariableResolveResult(jsVariable);
        if (this.shouldProcessVariableWithInitializer((PsiElement)jsVariable) && jsVariable instanceof JSVariable) {
            this.processRequireCallInitializer((JSVariable)jsVariable);
        }
    }

    @Override
    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        TypeScriptTypeParameter[] parametersForOwner;
        String name;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(9);
        }
        if ((name = jsClass.getQualifiedName()) != null && (parametersForOwner = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)jsClass)).length > 0 && staticOrInstance == JSContext.INSTANCE) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            JSTypeSource classNameSource = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, true);
            List<JSType> types = TypeScriptGenericTypesEvaluator.buildGenericParameters(parametersForOwner);
            this.addType(new JSGenericTypeImpl(source, this.createTypeForThisExpression(JSContext.INSTANCE, name, classNameSource, DialectDetector.isTypeScript((PsiElement)rawqualifier)), types), (PsiElement)jsClass);
            return;
        }
        super.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
    }

    @Override
    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull String name, @NotNull JSTypeSource typeSource, boolean isTypeScript) {
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (name == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (typeSource == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (!isTypeScript) {
            JSType jSType = super.createTypeForThisExpression(staticOrInstance, name, typeSource, false);
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(typeSource, JSNamedTypeFactory.createType(name, typeSource, staticOrInstance));
        if (typeScriptGenericThisTypeImpl == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(14);
        }
        return typeScriptGenericThisTypeImpl;
    }

    private void processRequireCallInitializer(@NotNull JSVariable jsVariable) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        JSExpression initializer;
        if (jsVariable == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(15);
        }
        if ((initializer = jsVariable.getInitializerOrStub()) instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)initializer).getMethodExpression()) instanceof JSReferenceExpression) {
            this.processRequireMethodCall((JSCallExpression)initializer, (JSReferenceExpression)methodExpression, DialectDetector.isTypeScript((PsiElement)jsVariable));
        }
    }

    private boolean shouldProcessVariableWithInitializer(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(16);
        }
        return this.isFromCurrentFile(context) && this.myTypeProcessor instanceof QualifiedItemProcessor && !((QualifiedItemProcessor)this.myTypeProcessor).resolved.isResolved();
    }

    @Override
    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve != null && DialectDetector.isTypeScript(resolve)) {
            PsiFile file2 = resolve.getContainingFile();
            if (file2 == null) {
                return;
            }
            TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
            if (resolve instanceof JSFile) {
                if (exportAssignment == null) {
                    this.applyContextAndProcessResolvedElement(resolve);
                }
            } else if (resolve instanceof TypeScriptModule && exportAssignment == null) {
                this.addTypeFromResolveResult(resolve);
            }
            if (exportAssignment != null) {
                this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            }
        } else {
            super.addTypeFromExternalModuleReferenceResolveResult(resolve);
        }
    }

    @Override
    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        String reference;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawQualifier) {
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (typeScriptType != null) {
                JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeScriptType);
                this.addType(type, (PsiElement)rawQualifier);
                return true;
            }
        } else if (rawQualifier instanceof TypeScriptNotNullExpression) {
            JSExpression expression = ((TypeScriptNotNullExpression)rawQualifier).getExpression();
            JSType type = this.getExpressionTypeInContext(expression);
            this.addType(JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED), (PsiElement)rawQualifier);
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (!DialectDetector.isTypeScript((PsiElement)resolveResult)) {
            super.addTypeFromClassWithQName(resolveResult);
            return;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        JSType type = TypeScriptTypeEvaluator.getClassAsType(resolveResult);
        PsiElement source = this.getSourceForTypeContext((PsiElement)resolveResult, processedExpression);
        this.addType(type, source);
    }

    @NotNull
    private static JSType getClassAsType(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(19);
        }
        String qName = resolveResult.getName();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true);
        if (qName == null) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(resolveResult, true);
            if (jSRecordType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(20);
            }
            return jSRecordType;
        }
        JSType jSType = JSNamedTypeFactory.createType(qName, typeSource, JSContext.STATIC);
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    private static boolean hasInnerDeclarations(PsiElement element) {
        return !(element instanceof JSVariable) && !(element instanceof JSFunction);
    }

    @Override
    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof TypeScriptModule) {
            this.addTypeFromLocalModule((TypeScriptModule)referencedElement, false);
        } else if (referencedElement instanceof ES6ExportDefaultAssignment) {
            JSElement element = ((ES6ExportDefaultAssignment)referencedElement).getStubSafeElement();
            if (element instanceof TypeScriptInterfaceClass) {
                this.addTypeFromResolveResult((PsiElement)element);
            } else {
                super.addTypeFromResolvedImport(referencedElement);
            }
        } else {
            super.addTypeFromResolvedImport(referencedElement);
        }
    }

    @Override
    @NotNull
    public List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        JSRecordType.PropertySignature member;
        String value;
        if (type instanceof JSArrayType || type == null || type instanceof JSUnionType && !JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionType)type)) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            List<JSType> candidates = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
            if (!candidates.isEmpty()) {
                List<JSType> list = candidates;
                if (list == null) {
                    TypeScriptTypeEvaluator.$$$reportNull$$$0(23);
                }
                return list;
            }
            JSRecordType recordType = type.asRecordType();
            JSRecordType.IndexSignature indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            List<JSType> list = indexer == null ? ContainerUtil.emptyList() : Collections.singletonList(indexer.getMemberType());
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(24);
            }
            return list;
        }
        JSRecordType recordType = type.asRecordType();
        if (!recordType.hasMembers()) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(25);
            }
            return list;
        }
        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
        String propertyName = null;
        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
            propertyName = value;
        }
        if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
            propertyName = "[" + indexExpression.getText() + "]";
        }
        if (propertyName != null && (member = recordType.findPropertySignature(propertyName)) != null && DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            List<JSType> list = Collections.singletonList(member.getType());
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(26);
            }
            return list;
        }
        ArrayList indexSignatures = ContainerUtil.newArrayList();
        ContainerUtil.addIfNotNull((Collection)indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING));
        ContainerUtil.addIfNotNull((Collection)indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC));
        if (!indexSignatures.isEmpty()) {
            JSType expressionTypeType;
            JSType jSType = expressionTypeType = indexExpression != null ? this.getExpressionTypeInContext(indexExpression) : null;
            if (expressionTypeType != null) {
                ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)indexExpression);
                for (JSRecordType.IndexSignature signature : indexSignatures) {
                    if (!JSResolveUtil.isAssignableJSType(signature.getMemberParameterType(), expressionTypeType, processingContext)) continue;
                    List<JSType> list = Collections.singletonList(signature.getMemberType());
                    if (list == null) {
                        TypeScriptTypeEvaluator.$$$reportNull$$$0(27);
                    }
                    return list;
                }
            }
        }
        List<JSType> list = Collections.singletonList(JSAnyType.get((PsiElement)rawqualifier, false));
        if (list == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(29);
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier instanceof JSXmlLiteralExpression) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, true), (PsiElement)rawqualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawqualifier);
    }

    @Override
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        JSType type;
        List<JSType> results;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(30);
        }
        if (!DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        JSExpression qualifier = rawqualifier.getQualifier();
        JSType qualifierTypeType = this.getExpressionTypeInContext(qualifier);
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        JSType indexExpressionType = this.getExpressionTypeInContext(indexExpression);
        if (qualifierTypeType == null || indexExpressionType == null || JSPsiImplUtils.isSymbolRef(indexExpression)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        if (indexExpressionType instanceof JSNumberType && (results = this.getComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier())).size() == 1 && (type = results.get(0)).isSourceStrict()) {
            return type;
        }
        return new TypeScriptIndexedAccessJSTypeImpl(qualifierTypeType, indexExpressionType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false));
    }

    @Override
    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(31);
        }
        ResolveResult[] resolveResult = super.getResolveResultsFromQualifier(qualifier);
        boolean hasModules = false;
        for (ResolveResult result2 : resolveResult) {
            if (!(result2.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules || resolveResult.length <= 1) {
            if (resolveResult == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(32);
            }
            return resolveResult;
        }
        ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)resolveResult.length);
        HashSet visitedQualifiers = ContainerUtil.newHashSet();
        for (ResolveResult result3 : resolveResult) {
            PsiElement element = result3.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result3);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (module.isAugmentation() || !visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result3);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : newResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(33);
        }
        return resolveResultArray;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTupleLikeType(@Nullable JSType type, boolean isTypeScript) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSTupleType) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type);
        }
        if (!isTypeScript || type instanceof JSUtilType) {
            return false;
        }
        if (type instanceof TypeScriptOverloadContextualType) {
            return true;
        }
        Ref isTuple = Ref.create((Object)false);
        JSType finalType = type;
        RecursionManager.doPreventingRecursion((Object)type.getResolvedTypeId(), (boolean)false, () -> {
            isTuple.set((Object)finalType.asRecordType().hasProperty("0"));
            return true;
        });
        return (Boolean)isTuple.get();
    }

    @Override
    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        DialectOptionHolder holder;
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(34);
        }
        if (expressions == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(35);
        }
        AtomicInteger typesToEvaluateLimit = (holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier)) != null && holder.isJavaScript() ? new AtomicInteger(5) : null;
        List types = expressions.map(expression -> {
            if (rawQualifier == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(47);
            }
            return this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)expression, holder, typesToEvaluateLimit);
        }).collect(Collectors.toList());
        JSTupleTypeImpl type = new JSTupleTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true), types, false, -1);
        if (JSDestructuringUtil.arrayLiteralCorrespondsToDestructuringArray((JSExpression)rawQualifier)) {
            JSTupleTypeImpl jSTupleTypeImpl = type;
            if (jSTupleTypeImpl == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(36);
            }
            return jSTupleTypeImpl;
        }
        if (this.getContextualExpectedTypeKind() != JSExpectedTypeKind.CONTEXTUAL) {
            JSTupleTypeImpl jSTupleTypeImpl = type;
            if (jSTupleTypeImpl == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(37);
            }
            return jSTupleTypeImpl;
        }
        JSTupleTypeImpl jSTupleTypeImpl = TypeScriptTypeEvaluator.isTupleLikeType(JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)rawQualifier, this.getContextualExpectedTypeKind()), DialectDetector.isTypeScript((PsiElement)rawQualifier)) ? type : type.toArrayType(true);
        if (jSTupleTypeImpl == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(38);
        }
        return jSTupleTypeImpl;
    }

    @Override
    @NotNull
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression rawqualifier, @Nullable JSExpression expression, @Nullable DialectOptionHolder holder, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType expressionType = super.getExpressionTypeForArrayLiteral(rawqualifier, expression, holder, typesToEvaluateLimit);
        if (expressionType == null) {
            expressionType = this.createNullType(rawqualifier);
        }
        JSType jSType = expressionType;
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @Override
    @Nullable
    protected JSType widenExpressionTypeByContextualType(JSExpression expression, boolean isTypeScript, JSType exprType) {
        return this.widenLiteralTypesIfNeeded(exprType, expression, isTypeScript);
    }

    @Nullable
    private JSType widenLiteralTypesIfNeeded(@Nullable JSType exprType, @Nullable JSExpression expression, boolean isTypeScript) {
        if (exprType == null) {
            return null;
        }
        if (expression == null || !isTypeScript || this.getContextualExpectedTypeKind() != JSExpectedTypeKind.CONTEXTUAL) {
            return exprType;
        }
        if (!JSTypeUtils.isLiteralOrCompositeWithLiteralType(exprType)) {
            return exprType;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(expression, JSExpectedTypeKind.WIDENING);
        exprType = expectedType instanceof TypeScriptOverloadContextualType ? exprType : JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(exprType, TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(expectedType));
        return exprType;
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(40);
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && !DialectDetector.isTypeScript(module)) {
            return;
        }
        super.addModuleFromRequire(module, callExpression);
    }

    @Override
    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (thisScope instanceof TypeScriptFunction) {
            JSType type;
            PsiElement context = thisScope;
            if (thisScope instanceof JSFunctionExpression) {
                context = JSContextResolver.findContextElement(thisQualifier);
            }
            if (context instanceof TypeScriptFunction && (type = this.computeThisType((TypeScriptFunction)context)) != null) {
                this.addType(type, (PsiElement)thisQualifier);
                return;
            }
        }
        super.processThisQualifierInExecutionScope(thisQualifier, thisScope);
    }

    @Nullable
    private JSType computeThisType(@NotNull TypeScriptFunction function) {
        JSType thisType;
        JSType contextualType;
        JSType explicitThisType;
        if (function == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(42);
        }
        if ((explicitThisType = function.getExplicitThisType()) != null) {
            return explicitThisType;
        }
        if (function instanceof JSExpression && (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)function, JSExpectedTypeKind.CONTEXTUAL)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)contextualType).getThisType()) != null) {
            return thisType;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(function.getContainingFile());
        if (config2 == null || !config2.noImplicitThis()) {
            return null;
        }
        PsiElement context = function.getContext();
        JSAssignmentExpression parentAssignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)context, JSAssignmentExpression.class);
        if (parentAssignment != null) {
            return this.computeThisTypeFromAssignment(parentAssignment);
        }
        JSObjectLiteralExpression parentLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)context, JSObjectLiteralExpression.class);
        if (parentLiteral != null) {
            return this.computeThisTypeFromLiteral(parentLiteral);
        }
        return null;
    }

    @Nullable
    private JSType computeThisTypeFromAssignment(@NotNull JSAssignmentExpression assignment) {
        JSExpression qualifier;
        JSDefinitionExpression definitionExpression;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(43);
        }
        if ((definitionExpression = assignment.getDefinitionExpression()) == null) {
            return null;
        }
        JSExpression expression = definitionExpression.getExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)expression, JSIndexedPropertyAccessExpression.class);
        Object object = referenceExpression != null ? referenceExpression.getQualifier() : (qualifier = indexer != null ? indexer.getQualifier() : null);
        if (qualifier == null) {
            return null;
        }
        return this.getExpressionTypeInContext(qualifier);
    }

    @Nullable
    private JSType computeThisTypeFromLiteral(@NotNull JSObjectLiteralExpression parentLiteral) {
        JSType contextualType;
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(44);
        }
        return (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parentLiteral, this.getContextualExpectedTypeKind())) == null ? TypeScriptTypeEvaluator.createTypeOfLiteralType(parentLiteral) : TypeScriptTypeEvaluator.extractThisType(contextualType);
    }

    @Nullable
    private static JSType extractThisType(@Nullable JSType contextualType) {
        Ref thisTypeRef = Ref.create();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSType thisType = TypeScriptTypeEvaluator.doExtractThisType(t);
            if (thisType != null) {
                thisTypeRef.set((Object)thisType);
                return false;
            }
            return true;
        }), contextualType, false, true, true);
        return thisTypeRef.isNull() ? contextualType : (JSType)thisTypeRef.get();
    }

    @Nullable
    private static JSType doExtractThisType(@Nullable JSType type) {
        JSGenericTypeImpl genericType = (JSGenericTypeImpl)ObjectUtils.tryCast((Object)type, JSGenericTypeImpl.class);
        if (genericType == null) {
            return null;
        }
        JSNamedType namedType = (JSNamedType)ObjectUtils.tryCast((Object)genericType.getType(), JSNamedType.class);
        if (namedType == null || !THIS_TYPE_NAME.equals(namedType.getQualifiedName().getQualifiedName())) {
            return null;
        }
        List<JSType> arguments = genericType.getArguments();
        if (arguments.size() != 1) {
            return null;
        }
        return arguments.get(0);
    }

    @NotNull
    private static JSTypeofTypeImpl createTypeOfLiteralType(@NotNull JSObjectLiteralExpression parentLiteral) {
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(45);
        }
        JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl((JSExpression)parentLiteral, JSTypeSourceFactory.createTypeSource((PsiElement)parentLiteral, DialectDetector.isTypeScript((PsiElement)parentLiteral)));
        if (jSTypeofTypeImpl == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(46);
        }
        return jSTypeofTypeImpl;
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        if (jsClass != null && !jsClass.isInterface() && !this.isPrototypeOrNewExpression()) {
            JSReferenceListMember member;
            JSReferenceList extendsList = jsClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
            Object[] members = extendsList.getMembers();
            if (members.length == 1 && (member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members)) != null) {
                Collection jsClasses = member.getClasses();
                if (jsClasses.isEmpty()) {
                    super.processSuperQualifierExpression(rawqualifier, jsClass);
                    return;
                }
                JSTypeDeclaration[] arguments = member.getTypeArguments();
                if (arguments.length > 0) {
                    List<JSType> types = JSClassUtils.buildTypeArguments(member);
                    for (JSClass aClass : jsClasses) {
                        JSType type = TypeScriptTypeEvaluator.getClassAsType(aClass);
                        PsiElement source = this.getSourceForTypeContext((PsiElement)aClass, processedExpression);
                        this.addType(new JSGenericTypeImpl(type.getSource(), type, types), source);
                    }
                    return;
                }
            }
        }
        super.processSuperQualifierExpression(rawqualifier, jsClass);
    }

    @Override
    protected JSType substituteThisType(JSType type, JSFieldVariable jsVariable) {
        JSType parentType;
        if (!JSTypeUtils.hasThisGenericType(type)) {
            return type;
        }
        final JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        JSTypeSource source = type.getSource();
        if (context == null) {
            return type;
        }
        String name = context.getQualifiedName();
        JSType jSType = parentType = name == null ? null : JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSRecursiveExpandTransformer(){

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType jsType) {
                JSTypeSource currentSource;
                if (jsType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (jsType instanceof TypeScriptGenericThisTypeImpl && (currentSource = jsType.getSource()).getSourceElement() != context) {
                    JSTypeSource newSource = JSTypeSourceFactory.copyTypeSource(currentSource, (PsiElement)context);
                    TypeScriptGenericThisTypeImpl typeScriptGenericThisTypeImpl = new TypeScriptGenericThisTypeImpl(newSource, parentType);
                    if (typeScriptGenericThisTypeImpl == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return typeScriptGenericThisTypeImpl;
                }
                JSType jSType = jsType;
                if (jSType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsType";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 1: 
            case 7: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 3: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 34: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAsType";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypeForArrayLiteral";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeOfLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLocalModule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeForEnumType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processRequireCallInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessVariableWithInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExportAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassWithQName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getClassAsType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "computeThisType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromAssignment";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromLiteral";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOfLiteralType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getArrayTypeFromExpressions$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

