/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestShowHistoryAction
extends AnAction {
    public HttpRequestShowHistoryAction() {
        super(RestClientBundle.message("http.request.show.log.file.action", new Object[0]));
        this.getTemplatePresentation().setDescription(RestClientBundle.message("http.request.show.log.file.action.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(0);
        }
        if ((project = event.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(null, event, RestClientBundle.message("http.request.show.log.file.action.failed.default.project", new Object[0]), null);
            return;
        }
        try {
            HttpRequestPsiFile logFile = HttpRequestHistoryManager.getInstance(project).getLogFile();
            FileEditorManager.getInstance((Project)project).openFile(logFile.getVirtualFile(), true);
        }
        catch (HttpRequestInvalidLogFileException e) {
            this.showErrorBalloon(project, event, e.getMessage(), e.getOpenConfiguration());
        }
    }

    protected void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event, @NotNull String message, final @Nullable Runnable openConfig) {
        InputEvent inputEvent;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(1);
        }
        if (message == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(2);
        }
        RelativePoint point = (inputEvent = event.getInputEvent()) instanceof MouseEvent ? new RelativePoint((MouseEvent)inputEvent) : JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        String fullMessage = openConfig != null ? message + "<br/><a href=\"config\">Open Configuration</a>" : message;
        HyperlinkAdapter listener = openConfig != null ? new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    openConfig.run();
                }
            }
        } : null;
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(fullMessage, MessageType.ERROR, (HyperlinkListener)listener).setFadeoutTime(fullMessage.length() > 100 ? 5000L : 2000L);
        if (project != null) {
            builder.setDisposable((Disposable)project);
        }
        builder.createBalloon().show(point, Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/actions/HttpRequestShowHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorBalloon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

