/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView g;
    private final EditMode h;
    private final ViewMode f = new NavigationMode();
    private final MagnifierViewMode c = new MagnifierViewMode();
    private volatile boolean b = false;
    private volatile boolean a = false;
    private final List<GraphBuilderListener> d = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder i;
    private boolean e = false;

    GraphEventManager(EditMode mode, GraphBuilder builder) {
        this.i = builder;
        this.g = builder.getView();
        this.h = mode;
        this.c.setMagnifierRadius(150);
        Disposer.register((Disposable)builder, (Disposable)this);
        JComponent jComponent = this.g.getCanvasComponent();
        jComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        jComponent.addKeyListener((KeyListener)((Object)this));
        jComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        jComponent.addFocusListener((FocusListener)((Object)this));
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e10) {
                if (GraphEventManager.this.e) {
                    GraphEventManager.this.e = false;
                    GraphEventManager.this.a(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent e10) {
        if (e10.isControlDown() && !e10.isAltDown()) {
            this.c();
        } else if (e10.isAltDown() && !e10.isControlDown()) {
            this.a();
        } else {
            if (!this.e) {
                this.e = true;
                this.a(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.b();
        }
    }

    public void mouseMoved(MouseEvent e10) {
        if (!e10.isAltDown() && this.a || !e10.isControlDown() && this.b) {
            this.b();
        }
    }

    public void keyTyped(KeyEvent e10) {
    }

    public void keyPressed(KeyEvent e10) {
        int n2 = e10.getKeyCode();
        boolean bl2 = e10.isAltDown();
        boolean bl3 = e10.isControlDown();
        if (bl3 && GraphEventManager.a(n2)) {
            this.b(n2);
        } else if (n2 == 17 && !bl2) {
            this.c();
        } else if (n2 == 18 && !bl3) {
            this.a();
        } else {
            this.b();
        }
    }

    private void b(int n2) {
        Graph2D graph2D = this.g.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean a(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void c() {
        if (!this.b) {
            this.g.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.h.setEditing(false);
            this.h.reactivateParent();
            this.b = true;
            this.g.removeViewMode((ViewMode)(this.a ? this.c : this.h));
            this.a = false;
            this.g.addViewMode(this.f);
        }
    }

    private synchronized void a() {
        if (!this.a) {
            this.a = true;
            double d10 = this.g.getZoom();
            d10 = d10 < 1.0 ? 1.5 / d10 : 2.0 * d10;
            this.c.setMagnifierZoomFactor(d10);
            this.g.removeViewMode((ViewMode)(this.b ? this.f : this.h));
            this.b = false;
            this.g.addViewMode((ViewMode)this.c);
        }
    }

    private synchronized void b() {
        if (this.b) {
            this.a(GraphBuilderEvent.GRAPH_MOVED, false);
            this.b = false;
            this.g.removeViewMode(this.f);
            this.g.addViewMode((ViewMode)this.h);
        } else if (this.a) {
            this.a = false;
            this.g.removeViewMode((ViewMode)this.c);
            this.g.updateView();
            this.g.addViewMode((ViewMode)this.h);
        }
    }

    public void keyReleased(KeyEvent e10) {
        if (e10.getKeyCode() == 17 || e10.getKeyCode() == 18) {
            this.b();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e10) {
        int n2 = e10.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (e10.isControlDown()) {
            double d10 = this.g.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.g.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d10 / this.g.getZoom(), e10.getPoint());
            }
        }
    }

    public double zoomView(double zoom) {
        this.a(GraphBuilderEvent.ZOOM_CHANGED, true);
        double d10 = Math.min(10.0, Math.max(zoom, 0.1));
        this.g.setZoom(d10);
        this.g.updateView();
        this.a(GraphBuilderEvent.ZOOM_CHANGED, false);
        return d10;
    }

    public void focusGained(FocusEvent e10) {
    }

    public void focusLost(FocusEvent e10) {
        this.b();
    }

    public void subscribe(GraphBuilderListener listener) {
        if (!this.d.contains(listener)) {
            this.d.add(listener);
        }
    }

    public void dispose() {
        this.d.clear();
    }

    private void a(GraphBuilderEvent graphBuilderEvent, boolean bl2) {
        for (GraphBuilderListener graphBuilderListener : this.d) {
            if (bl2) {
                graphBuilderListener.beforeActionPerformed(this.i, graphBuilderEvent);
                continue;
            }
            graphBuilderListener.actionPerformed(this.i, graphBuilderEvent);
        }
    }
}

