/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import b.h.la;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceWithPsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;

public class I18nTranslateReference
extends RubyPolyVariantReferenceWithPsiElement {
    @NotNull
    public static final String KEY_SEPARATOR = ".";
    @NotNull
    static final String OPTION_SCOPE = "scope";
    @NotNull
    public static final List<String> OPTIONS;
    private static final InsertHandler<RubyLookupElement> f;
    @NotNull
    private final Module c;
    @NotNull
    private final AtomicNullableLazyValue<String> d;
    @NotNull
    private final AtomicNotNullLazyValue<TextRange> e;
    private static final long h;

    I18nTranslateReference(@NotNull RPossibleCall rCall, @NotNull Module module) {
        if (rCall == null) {
            I18nTranslateReference.d(0);
        }
        if (module == null) {
            I18nTranslateReference.d(1);
        }
        super((PsiElement)rCall);
        this.d = AtomicNullableLazyValue.createValue(() -> this.b());
        this.e = AtomicNotNullLazyValue.createValue(() -> this.a());
        this.c = module;
    }

    @NotNull
    public RPossibleCall getElement() {
        RPossibleCall rPossibleCall = (RPossibleCall)this.myElement;
        if (rPossibleCall == null) {
            I18nTranslateReference.d(2);
        }
        return rPossibleCall;
    }

    @NotNull
    private TextRange a() {
        PsiElement psiElement = this.getArgument() instanceof RSymbol ? ((RSymbol)this.getArgument()).getContent() : this.getArgument();
        int n2 = psiElement.getTextOffset() - this.myElement.getTextOffset();
        int n3 = n2 + psiElement.getTextLength();
        if (psiElement instanceof RStringLiteral) {
            PsiElement psiElement2;
            RStringLiteral rStringLiteral = (RStringLiteral)psiElement;
            PsiElement psiElement3 = rStringLiteral.getStringBeginning();
            if (psiElement3 != null) {
                n2 += psiElement3.getTextLength();
            }
            if ((psiElement2 = rStringLiteral.getStringEnding()) != null) {
                n3 -= psiElement2.getTextLength();
            }
        }
        TextRange textRange = new TextRange(n2, n3);
        if (textRange == null) {
            I18nTranslateReference.d(3);
        }
        return textRange;
    }

    @NotNull
    public PsiElement getArgument() {
        PsiElement psiElement = (PsiElement)this.getElement().getArguments().get(0);
        if (psiElement == null) {
            I18nTranslateReference.d(4);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = (TextRange)this.e.getValue();
        if (textRange == null) {
            I18nTranslateReference.d(5);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = RubyPsiUtil.getElementText(this.getArgument());
        if (string == null) {
            I18nTranslateReference.d(6);
        }
        return string;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String string;
        if (newElementName == null) {
            I18nTranslateReference.d(7);
        }
        String string2 = (string = this.getCanonicalText()).contains(KEY_SEPARATOR) ? string.substring(0, string.lastIndexOf(KEY_SEPARATOR) + 1) : "";
        String string3 = I18nTranslateReference.a(string2 + newElementName, this.getArgument());
        RPsiElement rPsiElement = RubyElementFactory.createElementFromText((PsiElement)this.getElement(), string3);
        RubyPsiUtil.replaceInParent(this.getArgument(), (PsiElement)rPsiElement);
        RPsiElement rPsiElement2 = rPsiElement;
        if (rPsiElement2 == null) {
            I18nTranslateReference.d(8);
        }
        return rPsiElement2;
    }

    @Contract(pure=true)
    @NotNull
    private static String a(@NotNull String string, @NotNull PsiElement psiElement) {
        if (string == null) {
            I18nTranslateReference.d(9);
        }
        if (psiElement == null) {
            I18nTranslateReference.d(10);
        }
        if (psiElement instanceof RFName) {
            String string2 = string;
            if (string2 == null) {
                I18nTranslateReference.d(11);
            }
            return string2;
        }
        if (psiElement instanceof RSymbol) {
            String string3 = ":" + I18nTranslateReference.a(string, ((RSymbol)psiElement).getContent());
            if (string3 == null) {
                I18nTranslateReference.d(12);
            }
            return string3;
        }
        if (psiElement instanceof RDStringLiteralImpl) {
            String string4 = "\"" + string + "\"";
            if (string4 == null) {
                I18nTranslateReference.d(13);
            }
            return string4;
        }
        String string5 = "'" + string + "'";
        if (string5 == null) {
            I18nTranslateReference.d(14);
        }
        return string5;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            I18nTranslateReference.d(15);
        }
        return I18nProvider.forElement(element).canBeTranslationReferenceTarget(element) && super.isReferenceTo(element);
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            I18nTranslateReference.d(16);
        }
        if (result == null) {
            I18nTranslateReference.d(17);
        }
        I18nDictionary i18nDictionary = this.getDictionary();
        String string = this.isScoped() ? this.getScope() + KEY_SEPARATOR : null;
        String string2 = RubyI18nFoldingLocaleSettings.getInstance(this.getProject()).getLocale();
        for (String string3 : i18nDictionary.getAllKeys()) {
            String string4 = I18nTranslateReference.getLookupTypeFromLocales(string2, i18nDictionary.getLocalesByKey(string3));
            if (string == null) {
                result.addElement(I18nTranslateReference.createLookupElement(string3, string4));
                continue;
            }
            if (!string3.startsWith(string)) continue;
            result.addElement(I18nTranslateReference.createLookupElement(string3.substring(string.length()), string4));
        }
    }

    @Override
    public boolean isSoft() {
        return true;
    }

    @Override
    @NotNull
    protected ResolveResult[] multiResolveInner(boolean incompleteCode) {
        I18nDictionary i18nDictionary = this.getDictionary();
        List<String> list2 = this.getFullKeys();
        ArrayList<I18nResolveResult> arrayList = new ArrayList<I18nResolveResult>();
        for (String string : list2) {
            for (LocaleEntry localeEntry : i18nDictionary.getLocaleEntriesByKey(string)) {
                PsiElement psiElement = localeEntry.getRecord(string);
                if (psiElement == null) continue;
                arrayList.add(new I18nResolveResult(psiElement, localeEntry));
            }
        }
        ResolveResult[] resolveResultArray = arrayList.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            I18nTranslateReference.d(18);
        }
        return resolveResultArray;
    }

    @NotNull
    public List<String> getFullKeys() {
        String string = StringUtil.trimStart((String)this.getCanonicalText(), (String)KEY_SEPARATOR);
        List<String> list2 = Collections.singletonList(this.isScoped() ? this.getScope() + KEY_SEPARATOR + string : string);
        if (list2 == null) {
            I18nTranslateReference.d(19);
        }
        return list2;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return ResolveUtil.resolvePsiMultiReference(this);
    }

    @NotNull
    public I18nDictionary getDictionary() {
        I18nDictionary i18nDictionary = I18nProvider.getDictionary(this.c);
        if (i18nDictionary == null) {
            I18nTranslateReference.d(20);
        }
        return i18nDictionary;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        I18nTranslateReference i18nTranslateReference = (I18nTranslateReference)o2;
        if (!this.getElement().getArguments().equals(i18nTranslateReference.getElement().getArguments())) {
            return false;
        }
        return this.c.equals(i18nTranslateReference.c);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.getElement().getArguments().hashCode();
        n2 = 31 * n2 + this.c.hashCode();
        return n2;
    }

    @NotNull
    protected static LookupElement createLookupElement(@NotNull String key, @NotNull String type) {
        if (key == null) {
            I18nTranslateReference.d(21);
        }
        if (type == null) {
            I18nTranslateReference.d(22);
        }
        RubyLookupElement rubyLookupElement = new RubyLookupElement(key, null, type, false, PlatformIcons.PROPERTY_ICON, RailsIcons.RAILS_I18N_LOCALE_ICON, f);
        if (rubyLookupElement == null) {
            I18nTranslateReference.d(23);
        }
        return rubyLookupElement;
    }

    @NotNull
    protected static String getLookupTypeFromLocales(@NotNull String defaultLocale, @NotNull Collection<String> locales) {
        long l2 = h ^ 0x4998A18C1799L;
        if (defaultLocale == null) {
            I18nTranslateReference.d(24);
        }
        if (locales == null) {
            I18nTranslateReference.d(25);
        }
        List list2 = ContainerUtil.sorted(locales, Comparator.comparing(defaultLocale::equals).reversed().thenComparing(Comparator.naturalOrder()));
        if (list2.size() <= 2) {
            String string = String.join((CharSequence)" and ", list2);
            if (string == null) {
                I18nTranslateReference.d(26);
            }
            return string;
        }
        String string = (String)list2.get(0) + " and " + (list2.size() - 1) + " others";
        if (string == null) {
            I18nTranslateReference.d(27);
        }
        return string;
    }

    @Nullable
    protected String getScope() {
        return (String)this.d.getValue();
    }

    protected boolean isScoped() {
        String string = this.getScope();
        return string != null && !string.isEmpty();
    }

    @Nullable
    private String b() {
        long l2 = h ^ 0x2BBC9F585C72L;
        return (String)ObjectUtils.doIfNotNull(RCallArguments.getOptionValues(this.getElement(), OPTION_SCOPE), list2 -> String.join((CharSequence)KEY_SEPARATOR, list2));
    }

    static {
        h = la.a(-218619781161620823L, 6170415643120840020L, MethodHandles.lookup().lookupClass()).a(199797274392368L);
        long l2 = h ^ 0x21CE605CD716L;
        OPTIONS = ContainerUtil.immutableList((Object[])new String[]{"cascade", "count", "deep_interpolation", "default", "exception_handler", "fallback", "fallback_in_progress", "format", "locale", "object", "raise", "resolve", OPTION_SCOPE, "separator", "throw"});
        f = new InsertHandler<RubyLookupElement>(){
            private static final long a = la.a(5988535192472772752L, -7253223565119565099L, MethodHandles.lookup().lookupClass()).a(220346886698886L);

            public void handleInsert(@NotNull InsertionContext context, @NotNull RubyLookupElement item) {
                if (context == null) {
                    1.a(0);
                }
                if (item == null) {
                    1.a(1);
                }
                Document document = context.getDocument();
                int n2 = context.getStartOffset();
                if (n2 <= 0 || document.getCharsSequence().charAt(n2 - 1) != ':') {
                    return;
                }
                RSymbol rSymbol = RubyElementFactory.createSymbol((PsiElement)context.getFile(), item.getLookupString());
                String string = rSymbol.getContent().getText();
                if (string.startsWith("'")) {
                    document.replaceString(n2, context.getTailOffset(), (CharSequence)string);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x71D26D40A739L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x2F0C6E3EF8A2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2create";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocale";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRenamedString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeys";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionary";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupTypeFromLocales";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateRenamedString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLookupTypeFromLocales";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

