/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import b.h.la;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathMappingSettings;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.LocalPositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RemotePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleFilterProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandler;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunEnvironmentProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugHelperFactory;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.rubyforge.debugcommons.RubyDebuggerFactory;

public abstract class RubyAbstractCommandLineState
extends CommandLineState {
    protected static final Logger LOG;
    @NonNls
    private static final String c = "--";
    @NonNls
    private static final String e = "--port";
    @NonNls
    private static final String d = "--host";
    @NonNls
    private static final String b = "0.0.0.0";
    @NonNls
    private static final String a = "ruby.command.line.state.";
    private final AbstractRubyRunConfiguration g;
    private final boolean f;
    private static final long o;

    protected RubyAbstractCommandLineState(AbstractRubyRunConfiguration config, @Nullable ExecutionEnvironment environment, boolean allocatePty) {
        long l2 = o ^ 0x3D8174684CE7L;
        super(environment);
        this.g = config;
        this.f = allocatePty || Registry.is((String)"ruby.run.configurations.with.pty");
        this.getConsoleBuilder().filters(this.createConsoleMessageFilters());
    }

    protected RubyAbstractCommandLineState(AbstractRubyRunConfiguration config) {
        this(config, null, false);
    }

    public AbstractRubyRunConfiguration getConfig() {
        return this.g;
    }

    protected String getRunnerId() {
        return this.getEnvironment().getRunner().getRunnerId();
    }

    public List<Filter> createConsoleMessageFilters() {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        arrayList.add((Filter)new UrlFilter());
        Module module = this.getConfig().getModule();
        if (module != null) {
            arrayList.add(new RStackTraceFilter(module));
        }
        return arrayList;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        super.setConsoleBuilder(consoleBuilder);
        this.getConsoleBuilder().filters(this.createConsoleMessageFilters());
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = (ProcessHandler)this.createCommandLineAndProcessHandler().getSecond();
        if (processHandler == null) {
            RubyAbstractCommandLineState.a(0);
        }
        return processHandler;
    }

    @NotNull
    public DefaultExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            RubyAbstractCommandLineState.a(1);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.a(2);
        }
        if (processHandler == null) {
            RubyAbstractCommandLineState.a(3);
        }
        ConsoleView consoleView = this.createAndAttachConsole(this.getConfig().getProject(), processHandler, executor);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler, this.createActions(consoleView, processHandler, executor));
        if (defaultExecutionResult == null) {
            RubyAbstractCommandLineState.a(4);
        }
        return defaultExecutionResult;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            RubyAbstractCommandLineState.a(5);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.a(6);
        }
        DefaultExecutionResult defaultExecutionResult = this.execute(executor, runner, this.startProcess());
        if (defaultExecutionResult == null) {
            RubyAbstractCommandLineState.a(7);
        }
        return defaultExecutionResult;
    }

    public Pair<RubyCommandLineData, ProcessHandler> createCommandLineAndProcessHandler() throws ExecutionException {
        Object object;
        long l2 = o ^ 0x2893AC19DC0DL;
        if (!this.getConfig().isPassParentEnvs()) {
            this.a();
        }
        RubyCommandLineData rubyCommandLineData = this.createRunCommandLine();
        RubyCommandLine rubyCommandLine = rubyCommandLineData.getCommandLine();
        RubyRunner rubyRunner = (RubyRunner)rubyCommandLineData.getUserData(RubyCommandLineData.RUNNER_KEY);
        assert (rubyRunner != null);
        FeatureUsageTracker.getInstance().triggerFeatureUsed(a + ((Object)((Object)this)).getClass().getSimpleName());
        RunnerSettings runnerSettings = this.getRunnerSettings();
        RubyRunConfigurationExtensionsManager.getInstance().patchCommandLine((RunConfigurationBase)this.getConfig(), runnerSettings, rubyCommandLine, this.getRunnerId());
        ProcessHandler processHandler = this.createOSProcessHandler(rubyRunner, rubyCommandLine.withPty(this.f));
        if (rubyRunner instanceof RubyLocalRunner && (object = ((RubyLocalRunner)rubyRunner).getModule()) != null && processHandler instanceof RubyProcessHandler && !((RubyProcessHandler)processHandler).hasProcessListener(BundlerMissingGemsProcessAdapter.class)) {
            processHandler.addProcessListener((ProcessListener)new BundlerMissingGemsProcessAdapter((Module)object, null));
        }
        if ((object = (Collection)rubyCommandLineData.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) != null && processHandler instanceof RubyProcessHandlerEx) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                PortForwarding portForwarding = (PortForwarding)iterator.next();
                try {
                    ((RubyProcessHandlerEx)processHandler).addTunnel(portForwarding);
                }
                catch (ExecutionException executionException) {
                    LOG.warn("Unable to add tunnel", (Throwable)executionException);
                }
            }
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        RubyRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.g, processHandler, this.getRunnerSettings());
        return Pair.create((Object)((Object)rubyCommandLineData), (Object)this.patchProcessHandler(processHandler, (RubyAbstractRunner)rubyRunner));
    }

    protected ProcessHandler patchProcessHandler(@NotNull ProcessHandler processHandler, @NotNull RubyAbstractRunner runner) {
        if (processHandler == null) {
            RubyAbstractCommandLineState.a(8);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.a(9);
        }
        return runner.applyLastPatchTo(processHandler);
    }

    protected abstract RubyCommandLineData createRunCommandLine() throws ExecutionException;

    @NotNull
    public ConsoleView createAndAttachConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        if (project == null) {
            RubyAbstractCommandLineState.a(10);
        }
        if (processHandler == null) {
            RubyAbstractCommandLineState.a(11);
        }
        if (executor == null) {
            RubyAbstractCommandLineState.a(12);
        }
        ConsoleView consoleView = this.getConsoleBuilder().getConsole();
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            RubyAbstractCommandLineState.a(13);
        }
        return consoleView2;
    }

    @Deprecated
    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine, boolean allocatePty) throws ExecutionException {
        if (runner == null) {
            RubyAbstractCommandLineState.a(14);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.a(15);
        }
        return this.createOSProcessHandler(runner, commandLine.withPty(allocatePty));
    }

    protected ProcessHandler createOSProcessHandler(@NotNull RubyRunner runner, @NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (runner == null) {
            RubyAbstractCommandLineState.a(16);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.a(17);
        }
        return runner.createProcessHandler(commandLine, this.getRunnerId());
    }

    public final ParamsGroup addExecutionScriptGroup(@NotNull String scriptTypeId, @NotNull RubyCommandLineData data, @NotNull GeneralCommandLine commandLine, @NotNull String executionScriptPath) {
        if (scriptTypeId == null) {
            RubyAbstractCommandLineState.a(18);
        }
        if (data == null) {
            RubyAbstractCommandLineState.a(19);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.a(20);
        }
        if (executionScriptPath == null) {
            RubyAbstractCommandLineState.a(21);
        }
        AbstractRubyRunConfiguration abstractRubyRunConfiguration = this.getConfig();
        Sdk sdk = abstractRubyRunConfiguration.getSdk();
        assert (sdk != null);
        RubyRunner rubyRunner = (RubyRunner)data.getUserData(RubyCommandLineData.RUNNER_KEY);
        LOG.assertTrue(rubyRunner != null);
        PathMappingSettings pathMappingSettings = rubyRunner.addDefaultMappings(abstractRubyRunConfiguration.getMappingSettings());
        RubySdkSystemAccessor rubySdkSystemAccessor = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
        return RubyAbstractCommandLineState.addExecutionScriptGroup(scriptTypeId, data, commandLine, pathMappingSettings, rubySdkSystemAccessor, executionScriptPath);
    }

    public boolean preLoaderAllowed() {
        return RubyAbstractCommandLineState.preLoaderAllowed(this.getRunnerId());
    }

    protected boolean isInRubyDebugMode() {
        return RubyAbstractCommandLineState.isInRubyDebugMode(this.getRunnerId());
    }

    private void a() {
        long l2 = o ^ 0x1BB6DA7F673DL;
        final Notification notification = new Notification(RBundle.message((String)"run.without.parent.environment.id"), RBundle.message((String)"run.without.parent.environment.title"), RBundle.message((String)"run.without.parent.environment.text"), NotificationType.WARNING);
        notification.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"run.without.parent.environment.action.enable")){
            private static final long a = la.a(2982824091479841104L, -2044324478515847117L, MethodHandles.lookup().lookupClass()).a(213991954366098L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                RubyAbstractCommandLineState.this.getConfig().setPassParentEnvs(true);
                notification.expire();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3412B3720C02L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$1", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification);
    }

    public static RubyCommandLineData createDefaultCommandLine(@NotNull AbstractRubyRunConfiguration config, @Nullable String runnerId) throws ExecutionException {
        long l2 = o ^ 0x2444C1765A41L;
        if (config == null) {
            RubyAbstractCommandLineState.a(22);
        }
        try {
            config.checkConfiguration();
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            throw new ExecutionException(runtimeConfigurationException.getMessage(), (Throwable)runtimeConfigurationException);
        }
        Sdk sdk = config.getSdk();
        assert (sdk != null) : "Sdk cannot be null here";
        HashMap<String, String> hashMap = new HashMap<String, String>(config.getEnvs());
        RunEnvironmentProvider.processRunConfig(sdk, config.getModule(), hashMap);
        RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, config.getModule());
        RubyCommandLineData rubyCommandLineData = RubyAbstractCommandLineState.isInRubyDebugMode(runnerId) ? RubyAbstractCommandLineState.a(config, hashMap, rubyRunner, sdk) : RubyAbstractCommandLineState.createDefaultRunCommandLine(config, hashMap, rubyRunner, sdk);
        rubyCommandLineData.putUserData(RubyCommandLineData.RUNNER_KEY, rubyRunner);
        return rubyCommandLineData;
    }

    protected static RubyCommandLineData createDefaultRunCommandLine(@NotNull AbstractRubyRunConfiguration config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk) {
        if (config == null) {
            RubyAbstractCommandLineState.a(23);
        }
        if (environment == null) {
            RubyAbstractCommandLineState.a(24);
        }
        if (runner == null) {
            RubyAbstractCommandLineState.a(25);
        }
        if (sdk == null) {
            RubyAbstractCommandLineState.a(26);
        }
        String string = RubyAbstractCommandLineState.a(config);
        SpringUtil.customizeSpring(config.getModule(), environment);
        PathMappingSettings pathMappingSettings = runner.addDefaultMappings(config.getMappingSettings());
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(MergingCommandLineArgumentsProvider.stringToArguments(config.getRubyArgs())));
        String string2 = RubySdkAdditionalData.getInterpreterPathFor(sdk);
        arrayList.add(0, RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(string2));
        RubyCommandLine rubyCommandLine = runner.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(arrayList).withWorkingDirPath(string == null ? null : pathMappingSettings.convertToRemote(string))).withAdditionalEnvs(environment)).withParentEnv(config.isPassParentEnvs())).withSdk(sdk)).withPathMappings(pathMappingSettings));
        RubyCommandLineData rubyCommandLineData = new RubyCommandLineData();
        rubyCommandLineData.setCommandLine(rubyCommandLine);
        return rubyCommandLineData;
    }

    @NotNull
    private static RubyCommandLineData a(@NotNull AbstractRubyRunConfiguration abstractRubyRunConfiguration, @NotNull Map<String, String> map, @NotNull RubyRunner rubyRunner, @NotNull Sdk sdk) throws ExecutionException {
        if (abstractRubyRunConfiguration == null) {
            RubyAbstractCommandLineState.a(27);
        }
        if (map == null) {
            RubyAbstractCommandLineState.a(28);
        }
        if (rubyRunner == null) {
            RubyAbstractCommandLineState.a(29);
        }
        if (sdk == null) {
            RubyAbstractCommandLineState.a(30);
        }
        RubyCommandLineData rubyCommandLineData = ((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)((RubyDebugCommandLineDataBuilderBase)new RubyDebugCommandLineDataBuilderBase(abstractRubyRunConfiguration, map, rubyRunner, sdk, RubyDebugMode.NORMAL_MODE).setDebugConsoleAllowed(true)).setTemplateRubyArgs()).setRubyDebugIdeExecutable()).setRdebugOptions()).setCommandDelimiter()).build();
        if (rubyCommandLineData == null) {
            RubyAbstractCommandLineState.a(31);
        }
        return rubyCommandLineData;
    }

    @Nullable
    private static String a(@NotNull AbstractRubyRunConfiguration abstractRubyRunConfiguration) {
        String string;
        if (abstractRubyRunConfiguration == null) {
            RubyAbstractCommandLineState.a(32);
        }
        if (!(string = abstractRubyRunConfiguration.getWorkingDirectory()).trim().isEmpty()) {
            return string.trim();
        }
        Module module = abstractRubyRunConfiguration.getModule();
        if (module != null) {
            return PathMacroUtil.getModuleDir((String)module.getModuleFilePath());
        }
        return abstractRubyRunConfiguration.getProject().getBasePath();
    }

    @NotNull
    public static DebugGemHelper selectDebugGemHelper(@NotNull Sdk sdk, @Nullable Module module, @NotNull RubyDebugMode mode) throws ExecutionException {
        RubyDebugHelperFactory[] rubyDebugHelperFactoryArray;
        long l2 = o ^ 0x2C127AC2F4DAL;
        if (sdk == null) {
            RubyAbstractCommandLineState.a(33);
        }
        if (mode == null) {
            RubyAbstractCommandLineState.a(34);
        }
        for (RubyDebugHelperFactory rubyDebugHelperFactory : rubyDebugHelperFactoryArray = (RubyDebugHelperFactory[])RubyDebugHelperFactory.EP_NAME.getExtensions()) {
            DebugGemHelper debugGemHelper = rubyDebugHelperFactory.getDebugGemHelper(module, sdk, mode);
            if (debugGemHelper == null) continue;
            DebugGemHelper debugGemHelper2 = debugGemHelper;
            if (debugGemHelper2 == null) {
                RubyAbstractCommandLineState.a(35);
            }
            return debugGemHelper2;
        }
        throw new ExecutionException("Debug configuration not supported");
    }

    private static void a(@NotNull RubyRunner rubyRunner, @NotNull List<? super String> list2, @NotNull RubyCommandLineData rubyCommandLineData, boolean bl2) throws ExecutionException {
        long l2 = o ^ 0x3FC8D4933598L;
        if (rubyRunner == null) {
            RubyAbstractCommandLineState.a(36);
        }
        if (list2 == null) {
            RubyAbstractCommandLineState.a(37);
        }
        if (rubyCommandLineData == null) {
            RubyAbstractCommandLineState.a(38);
        }
        Pair<PortForwarding, PortForwarding> pair = rubyRunner.getDebuggerForwardings();
        PortForwarding portForwarding = (PortForwarding)pair.getFirst();
        PortForwarding portForwarding2 = (PortForwarding)pair.getSecond();
        rubyCommandLineData.putUserData(RubyCommandLineData.DEBUG_PORT_KEY, portForwarding.getLocalPort());
        RunConfigurationUtil.addPortForwarding(rubyCommandLineData, portForwarding);
        list2.add(e);
        list2.add(String.valueOf(portForwarding.getRemotePort()));
        list2.add(d);
        list2.add(b);
        if (bl2) {
            rubyCommandLineData.putCopyableUserData(RubyCommandLineData.DISPATCHER_KEY, portForwarding2.getLocalPort());
            list2.add("--dispatcher-port");
            list2.add(String.valueOf(portForwarding2.getRemotePort()));
            RunConfigurationUtil.addPortForwarding(rubyCommandLineData, portForwarding2);
        }
    }

    public static void addParams(ParamsGroup paramsGroup, String argsString) {
        paramsGroup.addParameters(MergingCommandLineArgumentsProvider.stringToArguments(argsString));
    }

    public static void addParams(List<? super String> args, String argsString) {
        Collections.addAll(args, MergingCommandLineArgumentsProvider.stringToArguments(argsString));
    }

    public static ParamsGroup addExecutionScriptGroup(@NotNull String scriptTypeId, @NotNull RubyCommandLineData data, @NotNull GeneralCommandLine commandLine, @NotNull PathMappingSettings mappingSettings, @NotNull RubySdkSystemAccessor accessor, @NotNull String executionScriptPath) {
        if (scriptTypeId == null) {
            RubyAbstractCommandLineState.a(39);
        }
        if (data == null) {
            RubyAbstractCommandLineState.a(40);
        }
        if (commandLine == null) {
            RubyAbstractCommandLineState.a(41);
        }
        if (mappingSettings == null) {
            RubyAbstractCommandLineState.a(42);
        }
        if (accessor == null) {
            RubyAbstractCommandLineState.a(43);
        }
        if (executionScriptPath == null) {
            RubyAbstractCommandLineState.a(44);
        }
        ParamsGroup paramsGroup = commandLine.getParametersList().addParamsGroup(scriptTypeId);
        String string = mappingSettings.convertToRemote(executionScriptPath);
        paramsGroup.addParameter(string);
        data.putUserData(RubyCommandLineData.DEBUGED_SCRIPT_KEY, accessor.toSystemDependentName(string));
        return paramsGroup;
    }

    public static boolean isInRubyDebugMode(@Nullable String runnerId) {
        long l2 = o ^ 0x35ADF764206BL;
        return runnerId != null && runnerId.contains("Ruby") && runnerId.contains("Debug");
    }

    public static boolean preLoaderAllowed(@Nullable String runnerId) {
        long l2 = o ^ 0x4D0F5E2CF115L;
        return !RubyAbstractCommandLineState.isInRubyDebugMode(runnerId) && !"RubyCover".equals(runnerId);
    }

    protected static void addConsoleFilters(@NotNull List<? super Filter> filters, @NotNull Project project, @Nullable Sdk sdk, @Nullable String workingDir) {
        if (filters == null) {
            RubyAbstractCommandLineState.a(45);
        }
        if (project == null) {
            RubyAbstractCommandLineState.a(46);
        }
        for (RubyConsoleFilterProvider rubyConsoleFilterProvider : (RubyConsoleFilterProvider[])RubyConsoleFilterProvider.EP_NAME.getExtensions()) {
            Filter filter = rubyConsoleFilterProvider.createFilter(project, workingDir, sdk);
            if (filter == null) continue;
            filters.add((Filter)filter);
        }
    }

    static {
        o = la.a(4675084980747481887L, -7259288619836399642L, MethodHandles.lookup().lookupClass()).a(53505631059253L);
        LOG = Logger.getInstance(RubyAbstractCommandLineState.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x1140AA16EB7FL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: 
            case 16: 
            case 25: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 10: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptTypeId";
                break;
            }
            case 19: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 21: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScriptPath";
                break;
            }
            case 22: 
            case 23: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultDebugCommandLine";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "selectDebugGemHelper";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createOSProcessHandler";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addExecutionScriptGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultCommandLine";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultRunCommandLine";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDebugCommandLine";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "selectDebugGemHelper";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addDebuggerPorts";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addConsoleFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class RubyDebugCommandLineDataBuilderBase<T extends RubyDebugCommandLineDataBuilderBase> {
        @NotNull
        protected final List<String> myArgs;
        @NotNull
        protected final RubyCommandLineData myData;
        @NotNull
        protected final Sdk mySdk;
        @NotNull
        protected final DebugGemHelper myDebugGemHelper;
        @NotNull
        protected final AbstractRubyRunConfiguration myConfig;
        @NotNull
        private final Map<String, String> a;
        @NotNull
        private final RubyRunner e;
        @NotNull
        private final RubyDebugMode h;
        @NotNull
        private final RubyDebuggerSettings.RubyDebuggerSettingsState f;
        @NotNull
        private final PathMappingSettings g;
        @NotNull
        private final RubySdkSystemAccessor c;
        @NotNull
        private final String d;
        protected boolean myAskForSudo;
        private boolean b;
        private static final long p = la.a(390381772121378699L, 7687728213886121542L, MethodHandles.lookup().lookupClass()).a(209497010171953L);

        public RubyDebugCommandLineDataBuilderBase(@NotNull AbstractRubyRunConfiguration config, @NotNull Map<String, String> environment, @NotNull RubyRunner runner, @NotNull Sdk sdk, @NotNull RubyDebugMode mode) throws ExecutionException {
            long l2 = p ^ 0x4FFCCF9ED266L;
            if (config == null) {
                RubyDebugCommandLineDataBuilderBase.a(0);
            }
            if (environment == null) {
                RubyDebugCommandLineDataBuilderBase.a(1);
            }
            if (runner == null) {
                RubyDebugCommandLineDataBuilderBase.a(2);
            }
            if (sdk == null) {
                RubyDebugCommandLineDataBuilderBase.a(3);
            }
            if (mode == null) {
                RubyDebugCommandLineDataBuilderBase.a(4);
            }
            this.myAskForSudo = false;
            this.b = false;
            this.myConfig = config;
            this.a = environment;
            this.e = runner;
            this.mySdk = sdk;
            this.h = mode;
            this.myData = new RubyCommandLineData();
            this.myArgs = new ArrayList<String>();
            this.myDebugGemHelper = RubyAbstractCommandLineState.selectDebugGemHelper(this.mySdk, this.myConfig.getModule(), this.h);
            this.f = RubyDebuggerSettings.getInstance().getState();
            if (!this.myDebugGemHelper.isUsable()) {
                throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.start.debug", (Object[])new Object[]{this.myDebugGemHelper.getErrorMsg()}));
            }
            this.myData.putUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY, this.myDebugGemHelper);
            if (JRubySdkUtil.isJRubySDK(sdk)) {
                this.myArgs.add("-X+O");
                RubyDebuggerFactory.adjustForJRuby(this.myArgs);
            }
            this.g = runner.addDefaultMappings(config.getMappingSettings());
            this.c = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
            this.d = environment.get("RUBYLIB");
            this.a.put("RUBYLIB", this.myDebugGemHelper.updateRubyLib(this.d, this.c, this.g));
        }

        @NotNull
        public T setDebugConsoleAllowed(boolean isAllowed) {
            this.myData.putUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY, isAllowed);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(5);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setAskForSudo(boolean askForSudo) {
            this.myAskForSudo = askForSudo;
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(6);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setTemplateRubyArgs() {
            long l2 = p ^ 0x305B9E6077DCL;
            String string = this.myConfig.getRubyArgs();
            if (!this.c.isWindows() && string.startsWith("-e ")) {
                string = "-e at_exit{sleep(1)};" + string.substring(3);
            }
            RubyAbstractCommandLineState.addParams(this.myArgs, string);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(7);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setRubyDebugIdeExecutable() {
            this.myArgs.add(this.g.convertToRemote(this.myDebugGemHelper.getRdebugScriptPath()));
            this.b = true;
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(8);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setRdebugOptions() throws ExecutionException {
            this.myDebugGemHelper.enableVerboseMode(this.myArgs, this.f.isVerboseOutput());
            this.myDebugGemHelper.enableKeyValuePresentation(this.myArgs, this.f.isKeyValueHashPresentation());
            this.myDebugGemHelper.disableIntHandler(this.myArgs, RubyVMOptions.isDisableDebuggerIntHandler());
            this.myDebugGemHelper.setEvaluationTimeout(this.myArgs, this.f.getTimeout());
            this.myDebugGemHelper.enableEvaluationControl(this.myArgs, this.f.isEvaluationControl());
            if (this.f.isEvaluationControl()) {
                this.myDebugGemHelper.setEvaluationTimeLimit(this.myArgs, this.f.getTimeLimit());
                this.myDebugGemHelper.setEvaluationMemoryLimit(this.myArgs, this.f.getMemoryLimit());
            }
            this.myDebugGemHelper.addGemSpecificArgs(this.myArgs);
            RubyAbstractCommandLineState.a(this.e, this.myArgs, this.myData, this.f.isMultiprocess() && this.myDebugGemHelper.isMultiProcessDebugSupported());
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(9);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T setCommandDelimiter() {
            long l2 = p ^ 0xD185B91C7E2L;
            this.myArgs.add(RubyAbstractCommandLineState.c);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(10);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        public T putRunner() {
            this.myData.putUserData(RubyCommandLineData.RUNNER_KEY, this.e);
            RubyDebugCommandLineDataBuilderBase rubyDebugCommandLineDataBuilderBase = this;
            if (rubyDebugCommandLineDataBuilderBase == null) {
                RubyDebugCommandLineDataBuilderBase.a(11);
            }
            return (T)rubyDebugCommandLineDataBuilderBase;
        }

        @NotNull
        protected SourcePositionConverter getDefaultSourcePositionConverter() {
            SourcePositionConverter sourcePositionConverter = RubyRemoteInterpreterManager.getInstance().isRemoteSdk(this.mySdk) ? new RemotePositionConverter(this.g) : new LocalPositionConverter(this.myConfig.getProject(), !RubySdkUtil.isRuby18(this.mySdk));
            if (sourcePositionConverter == null) {
                RubyDebugCommandLineDataBuilderBase.a(12);
            }
            return sourcePositionConverter;
        }

        @NotNull
        public RubyCommandLineData build() {
            long l2 = p ^ 0xCEACABD859DL;
            if (!this.b) {
                throw new IllegalStateException("You should set ruby-debug-ide executable");
            }
            SpringUtil.disableSpring(this.a, this.myConfig.getModule());
            String string = RubyAbstractCommandLineState.a(this.myConfig);
            RubyCommandLine rubyCommandLine = this.e.createCommandLine((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(RubyVersionManagerHandler.notNullFrom(this.mySdk).getAdjustedGemScriptPathForExecution(RubySdkAdditionalData.getInterpreterPathFor(this.mySdk)), this.myArgs).withWorkingDirPath(string)).withAdditionalEnvs(this.a)).withParentEnv(this.myConfig.isPassParentEnvs())).withSdk(this.mySdk)).withPathMappings(this.myConfig.getMappingSettings())).withAskForSudo(this.myAskForSudo));
            this.myData.setCommandLine(rubyCommandLine);
            this.myData.putUserData(RubyCommandLineData.SOURCE_POSITION_CONVERTER_KEY, this.getDefaultSourcePositionConverter());
            RubyCommandLineData rubyCommandLineData = this.myData;
            if (rubyCommandLineData == null) {
                RubyDebugCommandLineDataBuilderBase.a(13);
            }
            return rubyCommandLineData;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = p ^ 0x7A4A8D8D4F91L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$RubyDebugCommandLineDataBuilderBase";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyAbstractCommandLineState$RubyDebugCommandLineDataBuilderBase";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDebugConsoleAllowed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAskForSudo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTemplateRubyArgs";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugIdeExecutable";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRdebugOptions";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandDelimiter";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putRunner";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultSourcePositionConverter";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

