/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.CvsBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CvsMethod {
    public static final CvsMethod EXT_METHOD = new CvsMethod("ext", true, true, true, false);
    public static final CvsMethod PSERVER_METHOD = new CvsMethod("pserver", true, true, true, true);
    public static final CvsMethod SSH_METHOD = new CvsMethod("ssh", CvsBundle.message("cvs.root.description.ssh.internal.implementation", new Object[0]), true, true, true, true);
    public static final CvsMethod LOCAL_METHOD = new CvsMethod("local", CvsBundle.message("cvs.root.description.local", new Object[0]), false, false, false, false);
    private final String myName;
    private final String myDescription;
    public static final CvsMethod[] AVAILABLE_METHODS = new CvsMethod[]{PSERVER_METHOD, EXT_METHOD, SSH_METHOD, LOCAL_METHOD};
    private final boolean myHasUserValue;
    private final boolean myHasHostValue;
    private final boolean myHasPortValue;
    private final boolean mySupportsProxyConnection;

    public CvsMethod(@NonNls String name, String description, boolean hasUserValue, boolean hasHostValue, boolean hasPortValue, boolean supportsProxy) {
        this.myName = name;
        this.myDescription = description;
        this.myHasUserValue = hasUserValue;
        this.myHasHostValue = hasHostValue;
        this.myHasPortValue = hasPortValue;
        this.mySupportsProxyConnection = supportsProxy;
    }

    public CvsMethod(@NonNls String name, boolean hasUserValue, boolean hasHostValue, boolean hasPortValue, boolean supportsProxy) {
        this(name, name, hasUserValue, hasHostValue, hasPortValue, supportsProxy);
    }

    public String toString() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    public String getDisplayName() {
        return this.myDescription;
    }

    @Nullable
    public static CvsMethod getValue(String method) {
        for (CvsMethod availableMethod : AVAILABLE_METHODS) {
            if (!availableMethod.getName().equals(method)) continue;
            return availableMethod;
        }
        return null;
    }

    public boolean hasUserValue() {
        return this.myHasUserValue;
    }

    public boolean hasHostValue() {
        return this.myHasHostValue;
    }

    public boolean hasPortValue() {
        return this.myHasPortValue;
    }

    public boolean supportsProxyConnection() {
        return this.mySupportsProxyConnection;
    }
}

