/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitCommand {
    public static final GitCommand ADD = GitCommand.write("add");
    public static final GitCommand BLAME = GitCommand.read("blame");
    public static final GitCommand BRANCH = GitCommand.read("branch");
    public static final GitCommand CAT_FILE = GitCommand.read("cat-file");
    public static final GitCommand CHECKOUT = GitCommand.write("checkout");
    public static final GitCommand CHECK_ATTR = GitCommand.read("check-attr");
    public static final GitCommand CHECK_IGNORE = GitCommand.read("check-ignore");
    public static final GitCommand COMMIT = GitCommand.write("commit");
    public static final GitCommand CONFIG = GitCommand.read("config");
    public static final GitCommand CHERRY = GitCommand.read("cherry");
    public static final GitCommand CHERRY_PICK = GitCommand.write("cherry-pick");
    public static final GitCommand CLONE = GitCommand.read("clone");
    public static final GitCommand DIFF = GitCommand.read("diff");
    public static final GitCommand FETCH = GitCommand.read("fetch");
    public static final GitCommand INIT = GitCommand.write("init");
    public static final GitCommand LOG = GitCommand.read("log");
    public static final GitCommand LS_FILES = GitCommand.read("ls-files");
    public static final GitCommand LS_TREE = GitCommand.read("ls-tree");
    public static final GitCommand LS_REMOTE = GitCommand.read("ls-remote");
    public static final GitCommand MERGE = GitCommand.write("merge");
    public static final GitCommand MERGE_BASE = GitCommand.read("merge-base");
    public static final GitCommand MV = GitCommand.write("mv");
    public static final GitCommand PULL = GitCommand.write("pull");
    public static final GitCommand PUSH = GitCommand.write("push");
    public static final GitCommand REBASE = GitCommand.write("rebase");
    public static final GitCommand REMOTE = GitCommand.read("remote");
    public static final GitCommand RESET = GitCommand.write("reset");
    public static final GitCommand REVERT = GitCommand.write("revert");
    public static final GitCommand REV_LIST = GitCommand.read("rev-list");
    public static final GitCommand REV_PARSE = GitCommand.read("rev-parse");
    public static final GitCommand RM = GitCommand.write("rm");
    public static final GitCommand SHOW = GitCommand.read("show");
    public static final GitCommand STASH = GitCommand.write("stash");
    public static final GitCommand STATUS = GitCommand.write("status");
    public static final GitCommand SUBMODULE = GitCommand.write("submodule");
    public static final GitCommand TAG = GitCommand.read("tag");
    public static final GitCommand UPDATE_INDEX = GitCommand.write("update-index");
    public static final GitCommand UPDATE_REF = GitCommand.write("update-ref");
    public static final GitCommand HASH_OBJECT = GitCommand.write("hash-object");
    public static final GitCommand VERSION = GitCommand.read("version");
    public static final String GIT_EDITOR_ENV = "GIT_EDITOR";
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final LockingPolicy myLocking;

    private GitCommand(@NotNull String name, @NotNull LockingPolicy lockingPolicy) {
        if (name == null) {
            GitCommand.$$$reportNull$$$0(0);
        }
        if (lockingPolicy == null) {
            GitCommand.$$$reportNull$$$0(1);
        }
        this.myLocking = lockingPolicy;
        this.myName = name;
    }

    private GitCommand(@NotNull GitCommand command, @NotNull LockingPolicy lockingPolicy) {
        if (command == null) {
            GitCommand.$$$reportNull$$$0(2);
        }
        if (lockingPolicy == null) {
            GitCommand.$$$reportNull$$$0(3);
        }
        this.myName = command.name();
        this.myLocking = lockingPolicy;
    }

    @NotNull
    public GitCommand readLockingCommand() {
        GitCommand gitCommand = new GitCommand(this, LockingPolicy.READ);
        if (gitCommand == null) {
            GitCommand.$$$reportNull$$$0(4);
        }
        return gitCommand;
    }

    @NotNull
    public GitCommand writeLockingCommand() {
        GitCommand gitCommand = new GitCommand(this, LockingPolicy.WRITE);
        if (gitCommand == null) {
            GitCommand.$$$reportNull$$$0(5);
        }
        return gitCommand;
    }

    @NotNull
    private static GitCommand read(@NotNull String name) {
        if (name == null) {
            GitCommand.$$$reportNull$$$0(6);
        }
        GitCommand gitCommand = new GitCommand(name, LockingPolicy.READ);
        if (gitCommand == null) {
            GitCommand.$$$reportNull$$$0(7);
        }
        return gitCommand;
    }

    @NotNull
    private static GitCommand write(@NotNull String name) {
        if (name == null) {
            GitCommand.$$$reportNull$$$0(8);
        }
        GitCommand gitCommand = new GitCommand(name, LockingPolicy.WRITE);
        if (gitCommand == null) {
            GitCommand.$$$reportNull$$$0(9);
        }
        return gitCommand;
    }

    @NotNull
    public String name() {
        String string = this.myName;
        if (string == null) {
            GitCommand.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public LockingPolicy lockingPolicy() {
        LockingPolicy lockingPolicy = this.myLocking;
        if (lockingPolicy == null) {
            GitCommand.$$$reportNull$$$0(11);
        }
        return lockingPolicy;
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lockingPolicy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readLockingCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLockingCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "lockingPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum LockingPolicy {
        READ,
        WRITE;

    }
}

