/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ+\u0010\u0005\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/model/ModelFactory;", "", "myTextStorage", "Lcom/intellij/database/model/ModelTextStorage;", "(Lcom/intellij/database/model/ModelTextStorage;)V", "createModel", "Lcom/intellij/database/model/basic/BasicModModel;", "dbms", "Lcom/intellij/database/Dbms;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "modelClass", "Ljava/lang/Class;", "(Lcom/intellij/database/Dbms;Ljava/lang/Class;)Lcom/intellij/database/model/basic/BasicModel;", "intellij.database.impl"})
public final class ModelFactory {
    private final ModelTextStorage myTextStorage;

    @NotNull
    public final BasicModModel createModel(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        ModelFacade modelFacade = ModelFacade.forDbms(dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)modelFacade, (String)"ModelFacade.forDbms(dbms)");
        ModelFacade factory = modelFacade;
        BasicModModel basicModModel = factory.createModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicModModel, (String)"factory.createModel()");
        BasicModModel model = basicModModel;
        model.setTextStorage(this.myTextStorage);
        return model;
    }

    @NotNull
    public final <M extends BasicModel> M createModel(@NotNull Dbms dbms, @NotNull Class<M> modelClass) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
        BasicModModel model = this.createModel(dbms);
        if (modelClass.isAssignableFrom(model.getClass())) {
            BasicModModel basicModModel = model;
            if (basicModModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type M");
            }
            return (M)basicModModel;
        }
        throw (Throwable)new IllegalArgumentException("Cannot cast " + dbms + " model to " + modelClass.getSimpleName());
    }

    public ModelFactory(@NotNull ModelTextStorage myTextStorage) {
        Intrinsics.checkParameterIsNotNull((Object)myTextStorage, (String)"myTextStorage");
        this.myTextStorage = myTextStorage;
    }
}

