/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaObject {
    private static final BasicMetaObject[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Class<? extends BasicModElement> modApiClass;
    public final BasicMetaProperty[] properties;
    public final BasicMetaObject[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Class<? extends BasicModElement> modApiClass, BasicMetaProperty[] properties, BasicMetaObject[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.modApiClass = modApiClass;
        this.properties = properties == null ? EMPTY_PROPS_ARRAY : properties;
        for (BasicMetaObject child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            assert (child.myParent == null);
            child.myParent = this;
        }
    }

    @Nullable
    public BasicMetaObject getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public BasicMetaModel getModel() {
        Object parent2 = this.myParent;
        while (parent2 instanceof BasicMetaObject) {
            parent2 = ((BasicMetaObject)parent2).myParent;
        }
        return (BasicMetaModel)ObjectUtils.tryCast((Object)parent2, BasicMetaModel.class);
    }

    void setModel(@NotNull BasicMetaModel model) {
        if (model == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        assert (this.myParent == null);
        this.myParent = model;
    }

    public boolean kindOf(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.modApiClass);
    }

    @NotNull
    public String toString() {
        if (this.myParent instanceof BasicMetaObject) {
            String string = this.myParent.toString() + "." + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.myParent instanceof BasicMetaModel) {
            String string = ((BasicMetaModel)this.myParent).dbms.getDisplayName() + ": " + this.kind.code();
            if (string == null) {
                BasicMetaObject.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.kind.code();
        if (string == null) {
            BasicMetaObject.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaObject";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

