/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.UnversionedScopeScanner;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceUnversionedTracker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceUnversionedTracker");
    private final Set<VirtualFile> myUnversionedFiles = ContainerUtil.newConcurrentSet();
    private final Set<VirtualFile> myIgnoredFiles = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private static final int ourFilesThreshold = 200;
    private boolean myTotalRescanThresholdPassed = true;
    private final Set<FilePath> myDirtyFiles = ContainerUtil.newHashSet();
    private final Object myScannerLock = new Object();
    private final VcsDirtyScopeManager myDirtyScopeManager;
    volatile boolean isActive;

    public PerforceUnversionedTracker(Project project) {
        this.myProject = project;
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager.markEverythingDirty();
    }

    public boolean isUnversioned(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(0);
        }
        return this.myUnversionedFiles.contains(file) && !PerforceChangeProvider.isBrokenSymlink(file);
    }

    public boolean isIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(1);
        }
        return this.myIgnoredFiles.contains(file);
    }

    public void markUnversioned(List<VirtualFile> files) throws VcsException {
        LOG.debug("markUnversioned: " + files);
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, this.myProject);
        HashSet ignored = ContainerUtil.newHashSet();
        for (P4Connection connection : map.keySet()) {
            ignored.addAll(PerforceUnversionedTracker.getFilesOutsideClientSpec(this.myProject, connection, map.get((Object)connection)));
        }
        for (VirtualFile file : files) {
            if (ignored.contains(file)) {
                this.myIgnoredFiles.add(file);
                continue;
            }
            this.myUnversionedFiles.add(file);
        }
    }

    public void markUnknown(@Nullable VirtualFile file) {
        if (file != null) {
            this.myUnversionedFiles.remove(file);
            this.myIgnoredFiles.remove(file);
        }
    }

    private static Set<VirtualFile> getExcludedFiles(Project project, P4Connection connection, Collection<VirtualFile> files) throws VcsException {
        PerforceClient client = PerforceManager.getInstance(project).getClient(connection);
        String clientName = client.getName();
        if (clientName == null) {
            return Collections.emptySet();
        }
        List roots = ContainerUtil.map(client.getRoots(), FileUtil::toSystemIndependentName);
        List<View> views = client.getViews();
        return new LinkedHashSet<VirtualFile>(ContainerUtil.filter(files, f -> {
            String clientSpecPath = PerforceUnversionedTracker.getClientSpecPath(f, clientName, roots);
            return clientSpecPath != null && View.isExcluded((String)clientSpecPath, (List)views);
        }));
    }

    @Nullable
    private static String getClientSpecPath(VirtualFile file, String clientName, List<String> roots) {
        String path = file.getPath();
        for (String root : roots) {
            if (!FileUtil.startsWith((String)path, (String)root)) continue;
            return "//" + clientName + "/" + StringUtil.trimStart((String)path.substring(root.length()), (String)"/");
        }
        return null;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFiles(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) throws VcsException {
        if (toCheckIgnored.isEmpty()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PerforceUnversionedTracker.$$$reportNull$$$0(2);
            }
            return set;
        }
        ServerVersion serverVersion = PerforceManager.getInstance(project).getServerVersion(connection);
        if (serverVersion != null && serverVersion.supportsIgnoresCommand()) {
            Set<VirtualFile> set = PerforceUnversionedTracker.getIgnoredFilesByIgnores(project, connection, toCheckIgnored);
            if (set == null) {
                PerforceUnversionedTracker.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<VirtualFile> set = PerforceUnversionedTracker.getIgnoredFilesByPreviewAdd(project, connection, toCheckIgnored);
        if (set == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFilesByPreviewAdd(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) throws VcsException {
        String path;
        if (!SystemProperties.getBooleanProperty((String)"perforce.ignored.check.via.preview.add.enabled", (boolean)true)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PerforceUnversionedTracker.$$$reportNull$$$0(5);
            }
            return set;
        }
        ExecResult execResult = PerforceRunner.getInstance(project).previewAdd(connection, toCheckIgnored);
        LinkedHashSet ignored = ContainerUtil.newLinkedHashSet();
        for (String line : execResult.getStderr().split("\n")) {
            if (line.isEmpty() || line.contains("no permission for operation on file(s)")) continue;
            path = StringUtil.trimEnd((String)line, (String)" - file(s) not in client view.");
            if (path.equals(line)) {
                PerforceRunner.checkError(execResult, PerforceSettings.getSettings(project), null);
                continue;
            }
            ContainerUtil.addIfNotNull((Collection)ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        for (String line : execResult.getStdout().split("\n")) {
            if (line.isEmpty() || (path = StringUtil.trimEnd((String)line, (String)" - ignored file can't be added.")).equals(line)) continue;
            ContainerUtil.addIfNotNull((Collection)ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        LinkedHashSet linkedHashSet = ignored;
        if (linkedHashSet == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFilesByIgnores(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) {
        if (!SystemProperties.getBooleanProperty((String)"perforce.ignored.check.via.ignores.enabled", (boolean)true)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PerforceUnversionedTracker.$$$reportNull$$$0(7);
            }
            return set;
        }
        LinkedHashSet ignored = ContainerUtil.newLinkedHashSet();
        for (List group : JBIterable.from(toCheckIgnored).split(100).map(JBIterable::toList)) {
            ExecResult execResult = PerforceRunner.getInstance(project).ignores(connection, group);
            for (String line : execResult.getStdout().split("\n")) {
                String path = StringUtil.trimEnd((String)line, (String)" ignored");
                ContainerUtil.addIfNotNull((Collection)ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
            }
        }
        LinkedHashSet linkedHashSet = ignored;
        if (linkedHashSet == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    public static Set<VirtualFile> getFilesOutsideClientSpec(Project project, P4Connection connection, Collection<VirtualFile> files) throws VcsException {
        files = ContainerUtil.filter(files, file -> !file.getPath().contains("..."));
        Set<VirtualFile> excluded = PerforceUnversionedTracker.getExcludedFiles(project, connection, files);
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>(excluded);
        result.addAll(PerforceUnversionedTracker.getIgnoredFiles(project, connection, ContainerUtil.filter((Collection)files, f -> !excluded.contains(f))));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> createScanner() {
        UnversionedScopeScanner scanner = new UnversionedScopeScanner(this.myProject){

            @Override
            protected void checkCanceled() {
                if (!PerforceUnversionedTracker.this.isActive) {
                    throw new ProcessCanceledException();
                }
            }
        };
        Object object = this.myScannerLock;
        synchronized (object) {
            if (this.myTotalRescanThresholdPassed) {
                this.myTotalRescanThresholdPassed = false;
                return () -> scanner.doRescan(UnversionedScopeScanner.createEverythingDirtyScope(this.myProject));
            }
            HashSet dirtyFiles = ContainerUtil.newHashSet(this.myDirtyFiles);
            this.myDirtyFiles.clear();
            return () -> scanner.doRescan(dirtyFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void totalRescan() {
        LOG.debug("totalRescan scheduled");
        Object object = this.myScannerLock;
        synchronized (object) {
            this.myTotalRescanThresholdPassed = true;
            this.myDirtyFiles.clear();
            this.myDirtyScopeManager.markEverythingDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDirtyFile(FilePath holder) {
        Object object = this.myScannerLock;
        synchronized (object) {
            if (this.myTotalRescanThresholdPassed) {
                return false;
            }
            LOG.debug("addDirtyFile: " + holder);
            this.myDirtyFiles.add(holder);
            if (this.myDirtyFiles.size() > 200) {
                this.totalRescan();
                return false;
            }
            return true;
        }
    }

    void reportRecheck(VirtualFile file) {
        this.markUnknown(file);
        if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file))) {
            this.myDirtyScopeManager.fileDirty(file);
        }
    }

    void reportDelete(VirtualFile file) {
        if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)file))) {
            this.myDirtyScopeManager.fileDirty(file);
        }
    }

    void reportRecheck(Set<VirtualFile> targets) {
        for (VirtualFile target : targets) {
            if (this.addDirtyFile(VcsUtil.getFilePath((VirtualFile)target))) continue;
            return;
        }
        this.myDirtyScopeManager.filesDirty(targets, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesByPreviewAdd";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesByIgnores";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

