/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.rename;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSVariableDeclarationImpl;

public class LESSRenameInputValidator
implements RenameInputValidator {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("@?(([A-z_])|(\\\\[ -~])|[^000-177]|(\\\\[0-9a-fA-F]{1,6})|([0-9_-]))+");
    private static final Pattern MIXIN_NAME_PATTERN = Pattern.compile("[.#]?([_A-Za-z][_A-Za-z0-9]*)(\\-[_A-Za-z][_A-Za-z0-9]*)*");

    public ElementPattern<? extends PsiElement> getPattern() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(LESSVariableDeclarationImpl.class), PlatformPatterns.psiElement(LESSMixin.class), PlatformPatterns.psiElement(LESSMixinInvocation.class), PlatformPatterns.psiElement(LESSNamespace.class)});
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        if (element instanceof LESSVariableDeclaration) {
            return VARIABLE_NAME_PATTERN.matcher(newName).matches();
        }
        return MIXIN_NAME_PATTERN.matcher(newName).matches();
    }
}

