/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import edu.berkeley.nlp.lm.collections.AbstractTMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class TIntMap<T extends Comparable>
extends AbstractTMap<T>
implements Iterable<Entry>,
Serializable {
    protected static final long serialVersionUID = 42L;
    private int[] values;

    public TIntMap() {
        this(AbstractTMap.defaultFunctionality(), 2);
    }

    public TIntMap(AbstractTMap.Functionality<T> keyFunc) {
        this(keyFunc, 2);
    }

    public TIntMap(int expectedSize) {
        this(AbstractTMap.defaultFunctionality(), expectedSize);
    }

    public TIntMap(AbstractTMap<T> map) {
        this(map.keyFunc);
        this.mapType = map.mapType;
        this.locked = map.locked;
        this.num = map.num;
        this.keys = map.locked ? map.keys : (Comparable[])map.keys.clone();
        this.values = map instanceof TIntMap ? (int[])((TIntMap)map).values.clone() : new int[this.keys.length];
    }

    public TIntMap(AbstractTMap.Functionality<T> keyFunc, int expectedSize) {
        this.keyFunc = keyFunc;
        this.mapType = AbstractTMap.MapType.HASH_TABLE;
        this.locked = false;
        this.num = 0;
        this.allocate(this.getCapacity(expectedSize, false));
        this.numCollisions = 0;
    }

    public boolean containsKey(T key) {
        return this.find(key, false) != -1;
    }

    public int get(T key, int defaultValue) {
        int i = this.findHelper(key, false);
        return i == -1 ? defaultValue : this.values[i];
    }

    public int getSure(T key) {
        int i = this.find(key, false);
        if (i == -1) {
            throw new RuntimeException("Missing key: " + key);
        }
        return this.values[i];
    }

    public void put(T key, int value) {
        assert (!Double.isNaN(value));
        int i = this.find(key, true);
        this.keys[i] = key;
        this.values[i] = value;
    }

    public void put(T key, int value, boolean keepHigher) {
        assert (!Double.isNaN(value));
        int i = this.find(key, true);
        this.keys[i] = key;
        if (keepHigher && this.values[i] > value) {
            return;
        }
        this.values[i] = value;
    }

    public void incr(T key, int dValue) {
        int i = this.find(key, true);
        this.keys[i] = key;
        if (Double.isNaN(this.values[i])) {
            this.values[i] = dValue;
        } else {
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void incrIfKeyExists(T key, int dValue) {
        int i = this.find(key, false);
        if (i == -1) {
            return;
        }
        this.keys[i] = key;
        if (Double.isNaN(this.values[i])) {
            this.values[i] = dValue;
        } else {
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void scale(T key, int dValue) {
        int i = this.find(key, true);
        if (i == -1) {
            return;
        }
        int n = i;
        this.values[n] = this.values[n] * dValue;
    }

    public int size() {
        return this.num;
    }

    public int capacity() {
        return this.keys.length;
    }

    public void gut() {
        this.values = null;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            sum += (double)this.values[i];
        }
        return sum;
    }

    public void putAll(int value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            this.values[i] = value;
        }
    }

    public void incrAll(int dValue) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int n = i;
            this.values[n] = this.values[n] + dValue;
        }
    }

    public void multAll(int dValue) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int n = i;
            this.values[n] = this.values[n] * dValue;
        }
    }

    public T argmax() {
        int besti = -1;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || besti != -1 && this.values[i] <= this.values[besti]) continue;
            besti = i;
        }
        return (T)(besti == -1 ? null : this.keys[besti]);
    }

    public double max() {
        int besti = -1;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || besti != -1 && this.values[i] <= this.values[besti]) continue;
            besti = i;
        }
        return besti == -1 ? Double.NEGATIVE_INFINITY : (double)this.values[besti];
    }

    public void incrMap(TIntMap<T> map, int factor) {
        for (int i = 0; i < map.keys.length; ++i) {
            if (map.keys[i] == null) continue;
            this.incr(map.keys[i], factor * map.values[i]);
        }
    }

    public TIntMap<T> copy() {
        TIntMap<T> newMap = new TIntMap<T>(this.keyFunc);
        newMap.mapType = this.mapType;
        newMap.locked = this.locked;
        newMap.num = this.num;
        newMap.keys = this.locked ? this.keys : (Comparable[])this.keys.clone();
        newMap.values = (int[])this.values.clone();
        return newMap;
    }

    public TIntMap<T> restrict(Set<T> set) {
        TIntMap<Comparable> newMap = new TIntMap<Comparable>(this.keyFunc);
        newMap.mapType = this.mapType;
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            this.allocate(this.getCapacity(this.num, false));
            for (int i = 0; i < this.keys.length; ++i) {
                if (!set.contains(this.keys[i])) continue;
                newMap.keys[newMap.num] = this.keys[i];
                newMap.values[newMap.num] = this.values[i];
                ++newMap.num;
            }
        } else if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || !set.contains(this.keys[i])) continue;
                newMap.put(this.keys[i], this.values[i]);
            }
        }
        newMap.locked = this.locked;
        return newMap;
    }

    public EntryValueComparator entryValueComparator() {
        return new EntryValueComparator();
    }

    public void lock() {
        this.locked = true;
    }

    public void switchToSortedList() {
        this.switchMapType(AbstractTMap.MapType.SORTED_LIST);
    }

    public void switchToHashTable() {
        this.switchMapType(AbstractTMap.MapType.HASH_TABLE);
    }

    public EntryIterator iterator() {
        return new EntryIterator();
    }

    public EntrySet entrySet() {
        return new EntrySet();
    }

    public KeySet keySet() {
        return new KeySet();
    }

    public ValueCollection values() {
        return new ValueCollection();
    }

    private int getCapacity(int n, boolean compact) {
        int capacity;
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            capacity = compact ? n : n * 2;
        } else if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
            capacity = n * 2 + 2;
        } else {
            throw new RuntimeException("Internal bug");
        }
        return Math.max(capacity, 1);
    }

    private synchronized void switchMapType(AbstractTMap.MapType newMapType) {
        block5: {
            int[] oldValues;
            Comparable[] oldKeys;
            block4: {
                int i;
                assert (!this.locked);
                oldKeys = this.keys;
                oldValues = this.values;
                this.mapType = newMapType;
                this.allocate(this.getCapacity(this.num, true));
                this.numCollisions = 0;
                if (newMapType != AbstractTMap.MapType.SORTED_LIST) break block4;
                ArrayList<FullEntry> entries = new ArrayList<FullEntry>(this.num);
                for (i = 0; i < oldKeys.length; ++i) {
                    if (oldKeys[i] == null) continue;
                    entries.add(new FullEntry(this, oldKeys[i], oldValues[i]));
                }
                Collections.sort(entries);
                for (i = 0; i < this.num; ++i) {
                    this.keys[i] = ((FullEntry)entries.get(i)).key;
                    this.values[i] = ((FullEntry)entries.get(i)).value;
                }
                break block5;
            }
            if (this.mapType != AbstractTMap.MapType.HASH_TABLE) break block5;
            this.num = 0;
            for (int i = 0; i < oldKeys.length; ++i) {
                if (oldKeys[i] == null) continue;
                this.put(oldKeys[i], oldValues[i]);
            }
        }
    }

    private int binarySearch(T targetKey) {
        int l = 0;
        int u = this.num - 1;
        while (l < u) {
            int m = l + u >>> 1;
            if (targetKey.compareTo((Comparable)this.keys[m]) <= 0) {
                u = m;
                continue;
            }
            l = m + 1;
        }
        return l;
    }

    private int hash(T x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        if ((h ^= h >>> 10) < 0) {
            h = -h;
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int find(T key, boolean modify) {
        if (modify) {
            TIntMap tIntMap = this;
            synchronized (tIntMap) {
                return this.findHelper(key, modify);
            }
        }
        return this.findHelper(key, modify);
    }

    private int findHelper(T key, boolean modify) {
        if (this.mapType == AbstractTMap.MapType.SORTED_LIST) {
            int i = this.binarySearch(key);
            if (i < this.num && this.keys[i] != null && key.equals(this.keys[i])) {
                return i;
            }
            if (modify) {
                if (this.locked) {
                    throw new RuntimeException("Cannot make new entry for " + key + ", because map is locked");
                }
                if (this.num == this.capacity()) {
                    this.changeSortedListCapacity(this.getCapacity(this.num + 1, false));
                }
                for (int j = this.num; j > i; --j) {
                    this.keys[j] = this.keys[j - 1];
                    this.values[j] = this.values[j - 1];
                }
                ++this.num;
                this.values[i] = -1;
                return i;
            }
            return -1;
        }
        if (this.mapType == AbstractTMap.MapType.HASH_TABLE) {
            int capacity = this.capacity();
            int keyHash = this.hash(key);
            int i = keyHash % capacity;
            if (i < 0) {
                i = -i;
            }
            if (!this.locked && modify && ((double)this.num > 0.75 * (double)capacity || capacity <= this.num + 1)) {
                this.switchMapType(AbstractTMap.MapType.HASH_TABLE);
                return this.find(key, modify);
            }
            Comparable currKey = null;
            int numCollisionsHere = 0;
            while ((currKey = this.keys[i]) != null && !currKey.equals(key)) {
                ++numCollisionsHere;
                if (++i != capacity) continue;
                i = 0;
            }
            this.numCollisions += numCollisionsHere;
            if (this.keys[i] != null) {
                return i;
            }
            if (modify) {
                ++this.num;
                if (this.num == capacity) {
                    throw new RuntimeException("Hash table is full: " + capacity);
                }
                this.values[i] = -1;
                return i;
            }
            return -1;
        }
        throw new RuntimeException("Internal bug: " + (Object)((Object)this.mapType));
    }

    private void allocate(int n) {
        this.keys = this.keyFunc.createArray(n);
        this.values = new int[n];
    }

    private void changeSortedListCapacity(int newCapacity) {
        assert (this.mapType == AbstractTMap.MapType.SORTED_LIST);
        assert (newCapacity >= this.num);
        Comparable[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.allocate(newCapacity);
        System.arraycopy(oldKeys, 0, this.keys, 0, this.num);
        System.arraycopy(oldValues, 0, this.values, 0, this.num);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Entry entry : this.entrySet()) {
            sb.append(entry.getKey() + ":" + entry.getValue() + ", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private abstract class MapIterator<E>
    implements Iterator<E> {
        private int next;
        private int end;

        public MapIterator() {
            this.end = TIntMap.this.mapType == AbstractTMap.MapType.SORTED_LIST ? TIntMap.this.size() : TIntMap.this.capacity();
            this.next = -1;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.next < this.end;
        }

        int nextIndex() {
            int curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && TIntMap.this.keys[this.next] == null);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueIterator
    extends MapIterator<Integer> {
        private ValueIterator() {
        }

        @Override
        public Integer next() {
            return TIntMap.this.values[this.nextIndex()];
        }
    }

    private class KeyIterator
    extends MapIterator<T> {
        private KeyIterator() {
        }

        @Override
        public T next() {
            return TIntMap.this.keys[this.nextIndex()];
        }
    }

    private class EntryIterator
    extends MapIterator<Entry> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            return new Entry(this.nextIndex());
        }
    }

    public class ValueCollection
    extends AbstractCollection<Integer> {
        @Override
        public Iterator<Integer> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TIntMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class KeySet
    extends AbstractSet<T> {
        @Override
        public Iterator<T> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TIntMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            return TIntMap.this.containsKey((Comparable)o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class EntrySet
    extends AbstractSet<Entry> {
        @Override
        public Iterator<Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TIntMap.this.num;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public class Entry {
        private final int i;

        private Entry(int i) {
            this.i = i;
        }

        public T getKey() {
            return TIntMap.this.keys[this.i];
        }

        public int getValue() {
            return TIntMap.this.values[this.i];
        }

        public void setValue(int newValue) {
            ((TIntMap)TIntMap.this).values[this.i] = newValue;
        }
    }

    public class EntryValueComparator
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            return Double.compare(TIntMap.this.values[e1.i], TIntMap.this.values[e2.i]);
        }
    }

    private class FullEntry
    implements Comparable<FullEntry> {
        private final T key;
        private final int value;
        final /* synthetic */ TIntMap this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private FullEntry(T key, int value) {
            this.this$0 = (TIntMap)n;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(FullEntry e) {
            return this.key.compareTo(e.key);
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

