/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;

public class SSTableIntervalTree
extends IntervalTree<RowPosition, SSTableReader, Interval<RowPosition, SSTableReader>> {
    private static final SSTableIntervalTree EMPTY = new SSTableIntervalTree(null);

    SSTableIntervalTree(Collection<Interval<RowPosition, SSTableReader>> intervals) {
        super(intervals);
    }

    public static SSTableIntervalTree empty() {
        return EMPTY;
    }

    public static SSTableIntervalTree build(Iterable<SSTableReader> sstables) {
        return new SSTableIntervalTree((Collection<Interval<RowPosition, SSTableReader>>)SSTableIntervalTree.buildIntervals(sstables));
    }

    public static List<Interval<RowPosition, SSTableReader>> buildIntervals(Iterable<SSTableReader> sstables) {
        ArrayList<Interval<RowPosition, SSTableReader>> intervals = new ArrayList<Interval<RowPosition, SSTableReader>>(Iterables.size(sstables));
        for (SSTableReader sstable : sstables) {
            intervals.add(Interval.create(sstable.first, sstable.last, sstable));
        }
        return intervals;
    }
}

