/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.io.util.SafeMemory;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SelfRefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseable;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ref<T>
implements RefCounted<T> {
    static final Logger logger = LoggerFactory.getLogger(Ref.class);
    public static final boolean DEBUG_ENABLED = System.getProperty("cassandra.debugrefcount", "false").equalsIgnoreCase("true");
    final State state;
    final T referent;
    private static final Class<?>[] concurrentIterableClasses = new Class[]{ConcurrentLinkedQueue.class, ConcurrentLinkedDeque.class, ConcurrentSkipListSet.class, CopyOnWriteArrayList.class, CopyOnWriteArraySet.class, DelayQueue.class, NonBlockingHashMap.class};
    static final Set<Class<?>> concurrentIterables = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<GlobalState> globallyExtant = Collections.newSetFromMap(new ConcurrentHashMap());
    static final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private static final ExecutorService EXEC = Executors.newFixedThreadPool(1, new NamedThreadFactory("Reference-Reaper"));
    static final ScheduledExecutorService STRONG_LEAK_DETECTOR = !DEBUG_ENABLED ? null : Executors.newScheduledThreadPool(1, new NamedThreadFactory("Strong-Reference-Leak-Detector"));
    static final Deque<InProgressVisit> inProgressVisitPool;
    static final Map<Class<?>, List<Field>> fieldMap;

    public Ref(T referent, RefCounted.Tidy tidy) {
        this.state = new State(new GlobalState(tidy), this, referenceQueue);
        this.referent = referent;
    }

    Ref(T referent, GlobalState state) {
        this.state = new State(state, this, referenceQueue);
        this.referent = referent;
    }

    public void release() {
        this.state.release(false);
    }

    public Throwable ensureReleased(Throwable accumulate) {
        return this.state.ensureReleased(accumulate);
    }

    public void ensureReleased() {
        Throwables.maybeFail(this.state.ensureReleased(null));
    }

    public void close() {
        this.ensureReleased();
    }

    public T get() {
        this.state.assertNotReleased();
        return this.referent;
    }

    @Override
    public Ref<T> tryRef() {
        return this.state.globalState.ref() ? new Ref<T>(this.referent, this.state.globalState) : null;
    }

    @Override
    public Ref<T> ref() {
        Ref<T> ref = this.tryRef();
        if (ref == null) {
            this.state.assertNotReleased();
        }
        return ref;
    }

    public String printDebugInfo() {
        if (DEBUG_ENABLED) {
            this.state.debug.log(this.state.toString());
            return "Memory was freed by " + this.state.debug.deallocateThread;
        }
        return "Memory was freed";
    }

    public int globalCount() {
        return this.state.globalState.count();
    }

    static InProgressVisit newInProgressVisit(Object o, List<Field> fields, Field field, String name) {
        Preconditions.checkNotNull((Object)o);
        InProgressVisit ipv = inProgressVisitPool.pollLast();
        if (ipv == null) {
            ipv = new InProgressVisit();
        }
        ipv.o = o;
        if (o instanceof Object[]) {
            ipv.collectionIterator = Arrays.asList((Object[])o).iterator();
        } else if (o instanceof ConcurrentMap) {
            ipv.isMapIterator = true;
            ipv.collectionIterator = ((Map)o).entrySet().iterator();
        } else if (concurrentIterables.contains(o.getClass()) | o instanceof BlockingQueue) {
            ipv.collectionIterator = ((Iterable)o).iterator();
        }
        ipv.fields = fields;
        ipv.field = field;
        ipv.name = name;
        return ipv;
    }

    static void returnInProgressVisit(InProgressVisit ipv) {
        if (inProgressVisitPool.size() > 1024) {
            return;
        }
        ipv.name = null;
        ipv.fields = null;
        ipv.o = null;
        ipv.fieldIndex = 0;
        ipv.field = null;
        ipv.collectionIterator = null;
        ipv.mapEntryValue = null;
        ipv.isMapIterator = false;
        inProgressVisitPool.offer(ipv);
    }

    static List<Field> getFields(Class<?> clazz) {
        if (clazz == null || clazz == PhantomReference.class || clazz == Class.class || Member.class.isAssignableFrom(clazz)) {
            return Collections.emptyList();
        }
        List<Field> fields = fieldMap.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        fieldMap.put(clazz, fields);
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        fields.addAll(Ref.getFields(clazz.getSuperclass()));
        return fields;
    }

    static {
        EXEC.execute(new ReferenceReaper());
        if (DEBUG_ENABLED) {
            STRONG_LEAK_DETECTOR.scheduleAtFixedRate(new Visitor(), 1L, 15L, TimeUnit.MINUTES);
            STRONG_LEAK_DETECTOR.scheduleAtFixedRate(new StrongLeakDetector(), 2L, 15L, TimeUnit.MINUTES);
        }
        concurrentIterables.addAll(Arrays.asList(concurrentIterableClasses));
        inProgressVisitPool = new ArrayDeque<InProgressVisit>();
        fieldMap = new HashMap();
    }

    private static class StrongLeakDetector
    implements Runnable {
        Set<RefCounted.Tidy> candidates = new HashSet<RefCounted.Tidy>();

        private StrongLeakDetector() {
        }

        @Override
        public void run() {
            Set<RefCounted.Tidy> candidates = Collections.newSetFromMap(new IdentityHashMap());
            for (GlobalState state : globallyExtant) {
                candidates.add(state.tidy);
            }
            this.removeExpected(candidates);
            this.candidates.retainAll(candidates);
            if (!this.candidates.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>();
                for (RefCounted.Tidy tidy : this.candidates) {
                    names.add(tidy.name());
                }
                logger.warn("Strong reference leak candidates detected: {}", names);
            }
            this.candidates = candidates;
        }

        private void removeExpected(Set<RefCounted.Tidy> candidates) {
            IdentityCollection expected = new IdentityCollection(candidates);
            for (Keyspace ks : Keyspace.all()) {
                for (ColumnFamilyStore cfs : ks.getColumnFamilyStores()) {
                    View view = cfs.getTracker().getView();
                    for (SSTableReader reader : view.allKnownSSTables()) {
                        reader.addTo(expected);
                    }
                }
            }
        }
    }

    public static class IdentityCollection {
        final Set<RefCounted.Tidy> candidates;

        public IdentityCollection(Set<RefCounted.Tidy> candidates) {
            this.candidates = candidates;
        }

        public void add(Ref<?> ref) {
            this.candidates.remove(ref.state.globalState.tidy);
        }

        public void add(SelfRefCounted<?> ref) {
            this.add(ref.selfRef());
        }

        public void add(SharedCloseable ref) {
            if (ref instanceof SharedCloseableImpl) {
                this.add((SharedCloseableImpl)ref);
            }
        }

        public void add(SharedCloseableImpl ref) {
            this.add(ref.ref);
        }

        public void add(Memory memory) {
            if (memory instanceof SafeMemory) {
                ((SafeMemory)memory).addTo(this);
            }
        }
    }

    static class Visitor
    implements Runnable {
        final Deque<InProgressVisit> path = new ArrayDeque<InProgressVisit>();
        final Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        @VisibleForTesting
        int lastVisitedCount;
        @VisibleForTesting
        long iterations = 0L;
        GlobalState visiting;
        Set<GlobalState> haveLoops;

        Visitor() {
        }

        @Override
        public void run() {
            try {
                for (GlobalState globalState : globallyExtant) {
                    if (globalState.tidy == null) continue;
                    this.path.clear();
                    this.visited.clear();
                    this.lastVisitedCount = 0;
                    this.iterations = 0L;
                    this.visited.add(globalState);
                    this.visiting = globalState;
                    this.traverse(globalState.tidy);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.lastVisitedCount = this.visited.size();
                this.path.clear();
                this.visited.clear();
            }
        }

        void traverse(RefCounted.Tidy rootObject) {
            this.path.offer(Ref.newInProgressVisit(rootObject, Ref.getFields(rootObject.getClass()), null, rootObject.name()));
            InProgressVisit inProgress = null;
            while (inProgress != null || !this.path.isEmpty()) {
                if (inProgress == null) {
                    inProgress = this.path.pollLast();
                }
                try {
                    Pair<Object, Field> p = inProgress.nextChild();
                    Object child = null;
                    Field field = null;
                    if (p != null) {
                        ++this.iterations;
                        child = p.left;
                        field = (Field)p.right;
                    }
                    if (child != null && this.visited.add(child)) {
                        this.path.offer(inProgress);
                        inProgress = Ref.newInProgressVisit(child, Ref.getFields(child.getClass()), field, null);
                        continue;
                    }
                    if (this.visiting == child) {
                        if (this.haveLoops != null) {
                            this.haveLoops.add(this.visiting);
                        }
                        NoSpamLogger.log(logger, NoSpamLogger.Level.ERROR, rootObject.getClass().getName(), 1L, TimeUnit.SECONDS, "Strong self-ref loop detected {}", this.path);
                        continue;
                    }
                    if (child != null) continue;
                    Ref.returnInProgressVisit(inProgress);
                    inProgress = null;
                }
                catch (IllegalAccessException e) {
                    NoSpamLogger.log(logger, NoSpamLogger.Level.ERROR, 5L, TimeUnit.MINUTES, "Could not fully check for self-referential leaks", e);
                }
            }
        }
    }

    static class InProgressVisit {
        String name;
        List<Field> fields;
        Object o;
        int fieldIndex = 0;
        Field field;
        boolean isMapIterator;
        Iterator<Object> collectionIterator;
        Object mapEntryValue;

        InProgressVisit() {
        }

        private Field nextField() {
            if (this.fields.isEmpty()) {
                return null;
            }
            if (this.fieldIndex >= this.fields.size()) {
                return null;
            }
            Field retval = this.fields.get(this.fieldIndex);
            ++this.fieldIndex;
            return retval;
        }

        Pair<Object, Field> nextChild() throws IllegalAccessException {
            Object nextObject;
            Field nextField;
            if (this.mapEntryValue != null) {
                Pair<Object, Field> retval = Pair.create(this.mapEntryValue, this.field);
                this.mapEntryValue = null;
                return retval;
            }
            if (this.collectionIterator != null) {
                if (!this.collectionIterator.hasNext()) {
                    return null;
                }
                Object nextItem = null;
                while (this.collectionIterator.hasNext() && (nextItem = this.collectionIterator.next()) == null) {
                }
                if (nextItem != null) {
                    if (this.isMapIterator & nextItem instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)nextItem;
                        this.mapEntryValue = entry.getValue();
                        return Pair.create(entry.getKey(), this.field);
                    }
                    return Pair.create(nextItem, this.field);
                }
                return null;
            }
            do {
                if ((nextField = this.nextField()) != null) continue;
                return null;
            } while (this.o instanceof WeakReference & nextField.getDeclaringClass() == Reference.class || (nextObject = nextField.get(this.o)) == null);
            return Pair.create(nextField.get(this.o), nextField);
        }

        public String toString() {
            return this.field == null ? this.name : this.field.toString() + "-" + this.o.getClass().getName();
        }
    }

    static final class ReferenceReaper
    implements Runnable {
        ReferenceReaper() {
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Reference<Object> obj;
                        if (!((obj = referenceQueue.remove()) instanceof State)) {
                            continue;
                        }
                        ((State)obj).release(true);
                    }
                }
                catch (InterruptedException interruptedException) {
                    EXEC.execute(this);
                }
            }
            catch (Throwable throwable) {
                EXEC.execute(this);
                throw throwable;
            }
        }
    }

    static final class GlobalState {
        private final Collection<State> locallyExtant = new ConcurrentLinkedDeque<State>();
        private final AtomicInteger counts = new AtomicInteger();
        private final RefCounted.Tidy tidy;

        GlobalState(RefCounted.Tidy tidy) {
            this.tidy = tidy;
            globallyExtant.add(this);
        }

        void register(State ref) {
            this.locallyExtant.add(ref);
        }

        boolean ref() {
            int cur;
            do {
                if ((cur = this.counts.get()) >= 0) continue;
                return false;
            } while (!this.counts.compareAndSet(cur, cur + 1));
            return true;
        }

        Throwable release(State ref, Throwable accumulate) {
            this.locallyExtant.remove(ref);
            if (-1 == this.counts.decrementAndGet()) {
                globallyExtant.remove(this);
                try {
                    if (this.tidy != null) {
                        this.tidy.tidy();
                    }
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
            }
            return accumulate;
        }

        int count() {
            return 1 + this.counts.get();
        }

        public String toString() {
            if (this.tidy != null) {
                return this.tidy.getClass() + "@" + System.identityHashCode(this.tidy) + ":" + this.tidy.name();
            }
            return "@" + System.identityHashCode(this);
        }
    }

    static final class Debug {
        String allocateThread;
        String deallocateThread;
        StackTraceElement[] allocateTrace;
        StackTraceElement[] deallocateTrace;

        Debug() {
            Thread thread = Thread.currentThread();
            this.allocateThread = thread.toString();
            this.allocateTrace = thread.getStackTrace();
        }

        synchronized void deallocate() {
            Thread thread = Thread.currentThread();
            this.deallocateThread = thread.toString();
            this.deallocateTrace = thread.getStackTrace();
        }

        synchronized void log(String id) {
            logger.error("Allocate trace {}:\n{}", (Object)id, (Object)this.print(this.allocateThread, this.allocateTrace));
            if (this.deallocateThread != null) {
                logger.error("Deallocate trace {}:\n{}", (Object)id, (Object)this.print(this.deallocateThread, this.deallocateTrace));
            }
        }

        String print(String thread, StackTraceElement[] trace) {
            StringBuilder sb = new StringBuilder();
            sb.append(thread);
            sb.append("\n");
            for (StackTraceElement element : trace) {
                sb.append("\tat ");
                sb.append(element);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    static final class State
    extends PhantomReference<Ref> {
        final Debug debug = DEBUG_ENABLED ? new Debug() : null;
        final GlobalState globalState;
        private volatile int released;
        private static final AtomicIntegerFieldUpdater<State> releasedUpdater = AtomicIntegerFieldUpdater.newUpdater(State.class, "released");

        public State(GlobalState globalState, Ref reference, ReferenceQueue<? super Ref> q) {
            super(reference, q);
            this.globalState = globalState;
            globalState.register(this);
        }

        void assertNotReleased() {
            if (DEBUG_ENABLED && this.released == 1) {
                this.debug.log(this.toString());
            }
            assert (this.released == 0);
        }

        Throwable ensureReleased(Throwable accumulate) {
            if (releasedUpdater.getAndSet(this, 1) == 0) {
                accumulate = this.globalState.release(this, accumulate);
                if (DEBUG_ENABLED) {
                    this.debug.deallocate();
                }
            }
            return accumulate;
        }

        void release(boolean leak) {
            if (!releasedUpdater.compareAndSet(this, 0, 1)) {
                if (!leak) {
                    String id = this.toString();
                    logger.error("BAD RELEASE: attempted to release a reference ({}) that has already been released", (Object)id);
                    if (DEBUG_ENABLED) {
                        this.debug.log(id);
                    }
                    throw new IllegalStateException("Attempted to release a reference that has already been released");
                }
                return;
            }
            Throwable fail = this.globalState.release(this, null);
            if (leak) {
                String id = this.toString();
                logger.error("LEAK DETECTED: a reference ({}) to {} was not released before the reference was garbage collected", (Object)id, (Object)this.globalState);
                if (DEBUG_ENABLED) {
                    this.debug.log(id);
                }
            } else if (DEBUG_ENABLED) {
                this.debug.deallocate();
            }
            if (fail != null) {
                logger.error("Error when closing {}", (Object)this.globalState, (Object)fail);
            }
        }
    }
}

