#!/usr/bin/python

# Find out when boot-com.iso stopped booting.

from bracket import *

use_current_repository()

def cd_boot(ts):
    return status2bool(run('''
qemu -nographic -cdrom %s/release/i386/installation/cdrom/boot-com.iso >/tmp/qemu.out &
pid=$!
sleep 30
grep NetBSD /tmp/qemu.out
status=$?
kill $pid
echo $status
exit $status
''' % build_dir(ts)))
    
find_failure(rcs2ts('2009.03.12.22.59.03'),
             rcs2ts('2011.01.04.12.44.48'),
             TestOp(cd_boot,
                    [build_op],
                    name = 'cd_boot'),
             confirm = False)
