/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public final class SkinSliderUI
extends BasicSliderUI {
    private Skin skin = SkinLookAndFeel.getSkin();

    public SkinSliderUI(JSlider b) {
        super(b);
    }

    public Dimension getPreferredHorizontalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getPreferredHorizontalSize());
    }

    public Dimension getPreferredVerticalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getPreferredVerticalSize());
    }

    public Dimension getMinimumHorizontalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getMinimumHorizontalSize());
    }

    public Dimension getMinimumVerticalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getMinimumVerticalSize());
    }

    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - 2;
            g.translate(trackBounds.x, trackBounds.y + cy);
            this.skin.getSlider().paintTrack(g, this.slider, trackBounds);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int cx = trackBounds.width / 2 - 2;
            g.translate(trackBounds.x + cx, trackBounds.y);
            this.skin.getSlider().paintTrack(g, this.slider, trackBounds);
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        this.skin.getSlider().paintThumb(g, this.slider, knobBounds);
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    protected void installDefaults(JSlider b) {
        super.installDefaults(b);
        this.skin.getSlider().installSkin(b);
    }

    protected Dimension getThumbSize() {
        Dimension dim = this.skin.getSlider().getThumbSize(this.slider);
        return dim == null ? super.getThumbSize() : dim;
    }

    public static ComponentUI createUI(JComponent x) {
        return new SkinSliderUI((JSlider)x);
    }
}

