/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jd.gui.spi.PreferencesPanel;

public class ViewerPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener,
GroovyObject {
    private static final int MIN_VALUE = 2;
    private static final int MAX_VALUE = 40;
    private static final String FONT_SIZE_KEY = "ViewerPreferences.fontSize";
    private PreferencesPanel.PreferencesPanelChangeListener listener;
    private JTextField fontSizeTextField;
    private Color errorBackgroundColor;
    private Color defaultBackgroundColor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ViewerPreferencesProvider() {
        super(new BorderLayout());
        Color color;
        JTextField jTextField;
        MetaClass metaClass;
        Color color2;
        Object var1_1 = null;
        this.listener = (PreferencesPanel.PreferencesPanelChangeListener)ScriptBytecodeAdapter.castToType(var1_1, PreferencesPanel.PreferencesPanelChangeListener.class);
        this.errorBackgroundColor = color2 = Color.RED;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.add((Component)new JLabel(StringGroovyMethods.plus(StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus(StringGroovyMethods.plus((CharSequence)"Font size (", (Object)MIN_VALUE), (CharSequence)".."), (Object)MAX_VALUE), (CharSequence)"): ")), BorderLayout.WEST);
        this.fontSizeTextField = jTextField = new JTextField();
        this.fontSizeTextField.getDocument().addDocumentListener(this);
        this.add((Component)this.fontSizeTextField, BorderLayout.CENTER);
        this.defaultBackgroundColor = color = this.fontSizeTextField.getBackground();
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Viewer";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Appearance";
    }

    @Override
    public void init(Color errorBackgroundColor) {
        Color color;
        this.errorBackgroundColor = color = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        Object fontSize = preferences.get(FONT_SIZE_KEY);
        if (!DefaultTypeTransformation.booleanUnbox(fontSize)) {
            RSyntaxTextArea textArea = new RSyntaxTextArea();
            Theme theme = Theme.load(this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml"));
            theme.apply(textArea);
            int n = textArea.getFont().getSize();
            fontSize = n;
        }
        String string = fontSize;
        this.fontSizeTextField.setText(ShortTypeHandling.castToString(string));
        this.fontSizeTextField.setCaretPosition(StringGroovyMethods.size(this.fontSizeTextField.getText()));
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(FONT_SIZE_KEY, this.fontSizeTextField.getText());
    }

    @Override
    public boolean arePreferencesValid() {
        int i = Integer.valueOf(this.fontSizeTextField.getText());
        boolean bl = i >= MIN_VALUE && i <= MAX_VALUE;
        try {
            return bl;
        }
        catch (NumberFormatException ignore) {
            boolean bl2 = false;
            return bl2;
        }
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener;
        this.listener = preferencesPanelChangeListener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    public void onTextChange() {
        Object v0;
        Color color = this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor;
        this.fontSizeTextField.setBackground(color);
        PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener = this.listener;
        if (preferencesPanelChangeListener != null) {
            preferencesPanelChangeListener.preferencesPanelChanged(this);
            v0 = null;
        } else {
            v0 = null;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ViewerPreferencesProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public static final int getMIN_VALUE() {
        return MIN_VALUE;
    }

    public static final int getMAX_VALUE() {
        return MAX_VALUE;
    }

    public static final String getFONT_SIZE_KEY() {
        return FONT_SIZE_KEY;
    }

    public PreferencesPanel.PreferencesPanelChangeListener getListener() {
        return this.listener;
    }

    public void setListener(PreferencesPanel.PreferencesPanelChangeListener preferencesPanelChangeListener) {
        this.listener = preferencesPanelChangeListener;
    }

    public JTextField getFontSizeTextField() {
        return this.fontSizeTextField;
    }

    public void setFontSizeTextField(JTextField jTextField) {
        this.fontSizeTextField = jTextField;
    }

    public Color getErrorBackgroundColor() {
        return this.errorBackgroundColor;
    }

    public void setErrorBackgroundColor(Color color) {
        this.errorBackgroundColor = color;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color color) {
        this.defaultBackgroundColor = color;
    }
}

