/*
 * Decompiled with CFR 0.152.
 */
package com.cheusov;

import com.cheusov.Directories;
import com.cheusov.JrepHelpFormatter;
import com.cheusov.JrepOptionsGroups;
import com.cheusov.JrepPattern;
import com.cheusov.PathFileFilter;
import com.cheusov.SymLinkFileFilter;
import com.cheusov.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.SystemUtils;

class Opts {
    public static String encoding = System.getProperty("file.encoding");
    public static boolean inverseMatch = false;
    public static boolean outputFilename = false;
    public static boolean opt_o = false;
    public static boolean wholeContent = false;
    public static boolean opt_L = false;
    public static boolean opt_i = false;
    public static boolean opt_h = false;
    public static boolean opt_H = false;
    public static boolean opt_F = false;
    public static boolean opt_c = false;
    public static boolean opt_n = false;
    public static boolean opt_x = false;
    public static boolean opt_q = false;
    public static boolean opt_s = false;
    public static boolean opt_w = false;
    public static boolean opt_line_buffered = false;
    public static int opt_m = 2000000000;
    public static boolean prefixWithFilename = false;
    public static int opt_B = 0;
    public static int opt_A = 0;
    public static String opt_O = null;
    public static JrepPattern.RE_ENGINE_TYPE opt_re_engine = JrepPattern.RE_ENGINE_TYPE.JAVA;
    public static Directories opt_directories = Directories.READ;
    public static String label = "(standard input)";
    public static OrFileFilter orExcludeFileFilter = new OrFileFilter();
    public static OrFileFilter orIncludeFileFilter = new OrFileFilter();
    public static AndFileFilter fileFilter = new AndFileFilter();
    private static OrFileFilter orExcludeDirFilter = new OrFileFilter();
    public static NotFileFilter orIncludeDirFilter = new NotFileFilter(orExcludeDirFilter);
    public static List<String> regexps = new ArrayList<String>();
    public static ArrayList<JrepPattern> patterns = new ArrayList();
    public static String colorEscStart;
    public static String colorEscEnd;
    public static boolean isStdoutTTY;
    private static boolean withJNI;

    Opts() {
    }

    public static String[] init(JrepOptionsGroups options, String[] args) throws ParseException, IOException {
        args = Opts.handleOptions(options, args);
        args = Opts.handleFreeArgs(args);
        Opts.sanityCheck();
        Opts.initPatterns(args);
        return args;
    }

    private static String[] handleOptions(JrepOptionsGroups options, String[] args) throws ParseException, IOException {
        String optStr;
        if (args.length == 0) {
            throw new RuntimeException("Usage: jrep [OPTIONS]... PATTERN [FILES...]\nTry 'jrep --help' for more information.");
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options.getOptions(), args);
        inverseMatch = cmd.hasOption("v");
        outputFilename = cmd.hasOption("l");
        opt_O = cmd.getOptionValue("O");
        opt_o = cmd.hasOption("o") || opt_O != null;
        wholeContent = cmd.hasOption("8");
        opt_L = cmd.hasOption("L");
        opt_i = cmd.hasOption("i");
        opt_h = cmd.hasOption("h");
        opt_H = cmd.hasOption("H");
        opt_F = cmd.hasOption("F");
        opt_c = cmd.hasOption("c");
        opt_n = cmd.hasOption("n");
        opt_x = cmd.hasOption("x");
        boolean optBool = cmd.hasOption("R");
        Directories directories = opt_directories = optBool || cmd.hasOption("r") ? Directories.RECURSE : Directories.READ;
        if (!optBool) {
            orExcludeFileFilter.addFileFilter(new SymLinkFileFilter());
        }
        opt_s = cmd.hasOption("s");
        opt_q = cmd.hasOption("q") || cmd.hasOption("silent");
        opt_w = cmd.hasOption("w");
        opt_line_buffered = cmd.hasOption("line-buffered");
        String[] optArray = cmd.getOptionValues("e");
        if (optArray != null && optArray.length != 0) {
            for (String regexp : optArray) {
                regexps.add(regexp);
            }
        }
        if ((optArray = cmd.getOptionValues("include")) != null && optArray.length != 0) {
            for (String globPattern : optArray) {
                orIncludeFileFilter.addFileFilter(new WildcardFileFilter(globPattern));
            }
        } else {
            orIncludeFileFilter.addFileFilter(TrueFileFilter.TRUE);
        }
        optArray = cmd.getOptionValues("exclude");
        if (optArray != null && optArray.length != 0) {
            for (String globPattern : optArray) {
                if (globPattern.startsWith(".") || globPattern.startsWith("/")) {
                    orExcludeFileFilter.addFileFilter(new PathFileFilter(globPattern));
                    continue;
                }
                orExcludeFileFilter.addFileFilter(new WildcardFileFilter(globPattern));
            }
        }
        if ((optArray = cmd.getOptionValues("exclude-dir")) != null && optArray.length != 0) {
            for (String globPattern : optArray) {
                orExcludeDirFilter.addFileFilter(new WildcardFileFilter(globPattern));
            }
        }
        if (orExcludeDirFilter.getFileFilters().isEmpty()) {
            orExcludeDirFilter.addFileFilter(FalseFileFilter.FALSE);
        }
        if ((optStr = cmd.getOptionValue("exclude-from")) != null) {
            LineIterator it = IOUtils.lineIterator((InputStream)new FileInputStream(optStr), encoding);
            while (it.hasNext()) {
                String globPattern = (String)it.next();
                if (globPattern.startsWith(".") || globPattern.startsWith("/")) {
                    orExcludeFileFilter.addFileFilter(new PathFileFilter(globPattern));
                    continue;
                }
                orExcludeFileFilter.addFileFilter(new WildcardFileFilter(globPattern));
            }
        }
        if ((optStr = cmd.getOptionValue("f")) != null) {
            LineIterator it = IOUtils.lineIterator((InputStream)new FileInputStream(optStr), encoding);
            while (it.hasNext()) {
                regexps.add((String)it.next());
            }
        }
        if ((optStr = cmd.getOptionValue("m")) != null) {
            opt_m = Integer.valueOf(optStr);
        }
        if ((optStr = cmd.getOptionValue("label")) != null) {
            label = optStr;
        }
        if ((optStr = cmd.getOptionValue("marker-start")) != null) {
            colorEscStart = optStr;
        }
        if ((optStr = cmd.getOptionValue("marker-end")) != null) {
            colorEscEnd = optStr;
        }
        if ((optStr = cmd.getOptionValue("A")) != null) {
            opt_A = Integer.valueOf(optStr);
        }
        if ((optStr = cmd.getOptionValue("B")) != null) {
            opt_B = Integer.valueOf(optStr);
        }
        if ((optStr = cmd.getOptionValue("C")) != null) {
            opt_A = opt_B = Integer.valueOf(optStr).intValue();
        }
        if ((optStr = cmd.getOptionValue("color")) == null) {
            optStr = cmd.getOptionValue("colour");
        }
        if (optStr == null || optStr.equals("auto")) {
            if (!isStdoutTTY) {
                colorEscStart = null;
            }
        } else if (!optStr.equals("always")) {
            if (optStr.equals("never")) {
                colorEscStart = null;
            } else {
                throw new IllegalArgumentException("Illegal argument `" + optStr + "` for option --color");
            }
        }
        if ((optStr = cmd.getOptionValue("re-engine")) != null) {
            if (optStr.equals("java")) {
                opt_re_engine = JrepPattern.RE_ENGINE_TYPE.JAVA;
            } else if (optStr.equals("re2j")) {
                opt_re_engine = JrepPattern.RE_ENGINE_TYPE.RE2J;
            } else {
                throw new IllegalArgumentException("Illegal argument `" + optStr + "` for option --re-engine");
            }
        }
        if ((optStr = cmd.getOptionValue("directories")) != null) {
            if (optStr.equals("skip")) {
                opt_directories = Directories.SKIP;
            } else if (optStr.equals("read")) {
                opt_directories = Directories.READ;
            } else if (optStr.equals("recurse")) {
                opt_directories = Directories.RECURSE;
            } else {
                throw new IllegalArgumentException("Illegal argument `" + optStr + "` for option --directories");
            }
        }
        if (cmd.hasOption("2")) {
            opt_re_engine = JrepPattern.RE_ENGINE_TYPE.RE2J;
        }
        if (cmd.hasOption("help")) {
            Opts.printHelp(options);
            System.exit(0);
        }
        if (cmd.hasOption("V")) {
            System.out.println("jrep-" + System.getenv("JREP_VERSION"));
            System.exit(0);
        }
        return cmd.getArgs();
    }

    private static boolean isStdoutTTY_Any() {
        if (withJNI) {
            return Utils.isStdoutTTY();
        }
        return true;
    }

    private static void printHelp(JrepOptionsGroups groups) {
        JrepHelpFormatter formatter = new JrepHelpFormatter();
        formatter.setLeftPadding(2);
        PrintWriter pw = new PrintWriter(System.out);
        int width = formatter.getWidth();
        int lpad = formatter.getLeftPadding();
        int dpad = formatter.getDescPadding();
        formatter.printWrapped(pw, width, "Usage: jrep [OPTIONS]... PATTERN [FILES...]");
        formatter.printWrapped(pw, width, "Search for PATTERN in each FILE or standard input. PATTERN is, by default, a Java regular expression (java.lang.regex).\nExample: jrep -i 'hello world' menu.h main.c");
        formatter.printWrapped(pw, width, "");
        formatter.printWrapped(pw, width, "Regexp selection and interpretation:");
        formatter.printHelp(pw, width, " ", null, groups.optionGroups[0], lpad, dpad, null);
        formatter.printWrapped(pw, width, "Miscellaneous:");
        formatter.printHelp(pw, width, " ", null, groups.optionGroups[1], lpad, dpad, null);
        formatter.printWrapped(pw, width, "Output control:");
        formatter.printHelp(pw, width, " ", null, groups.optionGroups[2], lpad, dpad, null);
        formatter.printWrapped(pw, width, "Context control:");
        formatter.printHelp(pw, width, " ", null, groups.optionGroups[3], lpad, dpad, null);
        formatter.printWrapped(pw, formatter.getWidth(), "When FILE is -, read standard input.  With no FILE, read . if a command-line -r is given, - otherwise.  If fewer than two FILEs are given, assume -h. Exit status is 0 if any line is selected, 1 otherwise; if any error occurs and -q is not given, the exit status is 2.\nJrep home page: <https://github.com/cheusov/jrep>");
        pw.flush();
    }

    private static String[] handleFreeArgs(String[] args) {
        if (!regexps.isEmpty()) {
            return args;
        }
        if (args.length <= 0) {
            throw new RuntimeException("Usage: jrep [OPTIONS]... PATTERN [FILES...]\nTry 'jrep --help' for more information.");
        }
        regexps.add(args[0]);
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private static void sanityCheck() {
        if (regexps.isEmpty()) {
            System.err.println("pattern should be specified");
            System.exit(2);
        }
    }

    private static void initPatterns(String[] args) {
        int i;
        if (opt_F) {
            for (i = 0; i < regexps.size(); ++i) {
                regexps.set(i, "\\Q" + regexps.get(i) + "\\E");
            }
        }
        if (opt_x) {
            for (i = 0; i < regexps.size(); ++i) {
                regexps.set(i, "(?m:^(?:" + regexps.get(i) + ")$)");
            }
        }
        if (opt_w) {
            for (i = 0; i < regexps.size(); ++i) {
                regexps.set(i, "\\b(?:" + regexps.get(i) + ")\\b");
            }
        }
        if (opt_i) {
            for (i = 0; i < regexps.size(); ++i) {
                regexps.set(i, "(?i:" + regexps.get(i) + ")");
            }
        }
        for (i = 0; i < regexps.size(); ++i) {
            patterns.add(JrepPattern.compile(opt_re_engine, regexps.get(i)));
        }
        prefixWithFilename = (opt_H || opt_directories == Directories.RECURSE || args.length > 1) && !opt_h;
    }

    static {
        isStdoutTTY = false;
        boolean bl = withJNI = System.getenv("JREP_NO_JNI") == null && !SystemUtils.IS_OS_WINDOWS;
        if (withJNI) {
            System.loadLibrary("jrep_jni");
        }
        isStdoutTTY = Opts.isStdoutTTY_Any();
        String colorEscSequence = System.getenv("JREP_COLOR");
        if (colorEscSequence == null) {
            colorEscSequence = System.getenv("GREP_COLOR");
        }
        if (colorEscSequence != null) {
            colorEscStart = "\u001b[" + colorEscSequence + "m";
            colorEscEnd = "\u001b[1;0m";
        }
        fileFilter.addFileFilter(orIncludeFileFilter);
        fileFilter.addFileFilter(new NotFileFilter(orExcludeFileFilter));
        orExcludeFileFilter.addFileFilter(FalseFileFilter.FALSE);
    }
}

