/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.widgets;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTextField;
import javax.swing.text.Document;
import net.claribole.zvtm.widgets.TranslucentWidget;

public class TranslucentTextField
extends JTextField
implements TranslucentWidget {
    AlphaComposite bgAC = AB_08;
    AlphaComposite fgAC = AB_10;

    public TranslucentTextField() {
        this.setOpaque(false);
        this.initColors();
    }

    public TranslucentTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setOpaque(false);
        this.initColors();
    }

    public TranslucentTextField(int columns) {
        super(columns);
        this.setOpaque(false);
        this.initColors();
    }

    public TranslucentTextField(String text) {
        super(text);
        this.setOpaque(false);
        this.initColors();
    }

    public TranslucentTextField(String text, int columns) {
        super(text, columns);
        this.setOpaque(false);
        this.initColors();
    }

    void initColors() {
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        this.setSelectionColor(Color.WHITE);
        this.setSelectedTextColor(Color.BLACK);
        this.setCaretColor(Color.WHITE);
    }

    public void setBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setForegroundTranslucence(float alpha) {
        this.fgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(this.bgAC);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(this.fgAC);
        g2d.setColor(this.getForeground());
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g2d);
    }
}

