/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunctionCall
implements Callable {
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression a2;
        Expression a1;
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.argument[1] instanceof NumberFn && th.isSubType((a1 = ((NumberFn)this.argument[1]).getArguments()[0]).getItemType(th), BuiltInAtomicType.INTEGER)) {
            this.argument[1] = a1;
        }
        if (this.argument.length > 2 && this.argument[2] instanceof NumberFn && th.isSubType((a2 = ((NumberFn)this.argument[2]).getArguments()[0]).getItemType(th), BuiltInAtomicType.INTEGER)) {
            this.argument[2] = a2;
        }
        return this;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av == null) {
            return StringValue.EMPTY_STRING;
        }
        StringValue sv = (StringValue)av;
        if (sv.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        AtomicValue a1 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue a = (NumericValue)a1;
        if (this.argument.length == 2) {
            StringValue result = StringValue.makeStringValue(Substring.substring(sv, a));
            if (sv.isKnownToContainNoSurrogates()) {
                result.setContainsNoSurrogates();
            }
            return result;
        }
        AtomicValue b2 = (AtomicValue)this.argument[2].evaluateItem(context);
        NumericValue b = (NumericValue)b2;
        StringValue result = StringValue.makeStringValue(Substring.substring(sv, a, b, context));
        if (sv.isKnownToContainNoSurrogates()) {
            result.setContainsNoSurrogates();
        }
        return result;
    }

    public static CharSequence substring(StringValue sv, NumericValue start) {
        long lstart;
        CharSequence s = sv.getStringValueCS();
        int slength = s.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return "";
            }
            if (lstart <= 0L) {
                lstart = 1L;
            }
        } else {
            if (start.isNaN()) {
                return "";
            }
            if (start.signum() <= 0) {
                return s;
            }
            if (start.compareTo(slength) > 0) {
                return "";
            }
            lstart = Math.round(start.getDoubleValue());
        }
        UnicodeString us = UnicodeString.makeUnicodeString(s);
        return us.substring((int)lstart - 1, us.length()).toString();
    }

    public static CharSequence substring(StringValue sv, NumericValue start, NumericValue len, XPathContext context) {
        long lend;
        NumericValue end;
        long lstart;
        CharSequence s = sv.getStringValueCS();
        int slength = s.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return "";
            }
        } else {
            if ((start = start.round(0)).isNaN()) {
                return "";
            }
            if (start.signum() <= 0) {
                lstart = 0L;
            } else {
                if (start.compareTo(slength) > 0) {
                    return "";
                }
                try {
                    lstart = start.longValue();
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        try {
            end = (NumericValue)ArithmeticExpression.compute(start, 0, len.round(0), context);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Unexpected arithmetic failure in substring");
        }
        if (end instanceof Int64Value) {
            lend = ((Int64Value)end).longValue();
        } else {
            if (end.isNaN()) {
                return "";
            }
            if (end.signum() <= 0) {
                return "";
            }
            if (end.compareTo(slength) > 0) {
                lend = slength + 1;
            } else {
                try {
                    lend = end.ceiling().longValue();
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        if (lend < lstart) {
            return "";
        }
        UnicodeString us = UnicodeString.makeUnicodeString(sv.getStringValueCS());
        int a1 = (int)lstart - 1;
        int a2 = Math.min(slength, (int)lend - 1);
        if (a1 < 0) {
            if (a2 < 0) {
                return "";
            }
            a1 = 0;
        }
        return us.substring(a1, a2).toString();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg0 = (StringValue)arguments[0].head();
        NumericValue arg1 = (NumericValue)arguments[1].head();
        if (arguments.length == 2) {
            return new StringValue(Substring.substring(arg0, arg1));
        }
        NumericValue arg2 = (NumericValue)arguments[2].head();
        return new StringValue(Substring.substring(arg0, arg1, arg2, context));
    }
}

