/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextLinesIterator
implements SequenceIterator<StringValue> {
    protected LineNumberReader reader;
    protected NameChecker checker;
    StringValue current = null;
    int position = 0;
    protected SourceLocator location;
    protected URI uri;

    protected TextLinesIterator() {
    }

    public TextLinesIterator(LineNumberReader reader, SourceLocator location, URI uri, NameChecker checker) throws XPathException {
        this.reader = reader;
        this.location = location;
        this.uri = uri;
        this.checker = checker;
    }

    @Override
    public StringValue next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        try {
            String s = this.reader.readLine();
            if (s == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.position == 0 && s.startsWith("\ufeff")) {
                s = s.substring(1);
            }
            this.checkLine(this.checker, s);
            this.current = new StringValue(s);
            ++this.position;
            return this.current;
        }
        catch (IOException err) {
            XPathException e = UnparsedText.handleIOError(this.uri, err, null);
            if (this.location != null) {
                e.setLocator(this.location);
            }
            throw e;
        }
    }

    @Override
    public StringValue current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getProperties() {
        return 0;
    }

    private void checkLine(NameChecker checker, String buffer) throws XPathException {
        int c = 0;
        while (c < buffer.length()) {
            int ch32;
            if (UTF16CharacterSet.isHighSurrogate(ch32 = buffer.charAt(c++))) {
                char low = buffer.charAt(c++);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (checker.isValidChar(ch32)) continue;
            XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + this.position + " column=" + (c + 1) + " value=hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("XTDE1190");
            err.setLocator(this.location);
            throw err;
        }
    }
}

