/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.XPathFunctionCall;

public class XPathFunctionLibrary
implements FunctionLibrary {
    private XPathFunctionResolver resolver;

    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        this.resolver = resolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.resolver;
    }

    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        if (this.resolver == null) {
            return null;
        }
        QName name = new QName(functionName.getURI(), functionName.getLocalPart());
        XPathFunction function = this.resolver.resolveFunction(name, staticArgs.length);
        if (function == null) {
            return null;
        }
        XPathFunctionCall fc = new XPathFunctionCall(function);
        fc.setArguments(staticArgs);
        return fc;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        return this.resolver != null && this.resolver.resolveFunction(new QName(functionName.getURI(), functionName.getLocalPart()), arity) != null;
    }

    public FunctionLibrary copy() {
        XPathFunctionLibrary xfl = new XPathFunctionLibrary();
        xfl.resolver = this.resolver;
        return xfl;
    }
}

