/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.protocol.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;

public class DataConnection
extends URLConnection {
    private static final String DATA_PROTO_RE = "data:((.*?/.*?)?(?:;(.*?)=(.*?))?)(?:;(base64)?)?,(.*)";
    private static final String DEFAULT_MIME_TYPE = "text/plain;charset=US-ASCII";
    private final Matcher m;

    public DataConnection(URL u) throws MalformedURLException {
        super(u);
        Pattern re = Pattern.compile(DATA_PROTO_RE);
        this.m = re.matcher(this.url.toString());
        this.connected = this.m.matches();
        if (!this.connected) {
            throw new MalformedURLException("Wrong data protocol URL");
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IOException();
        }
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        String contentType = this.m.group(1);
        if (contentType == null || "".equals(contentType)) {
            return DEFAULT_MIME_TYPE;
        }
        return contentType;
    }

    private byte[] getData() {
        String type = this.m.group(2);
        String attribute = this.m.group(3);
        String charset = this.m.group(4);
        String b64 = this.m.group(5);
        String data = this.m.group(6);
        if ("base64".equals(b64)) {
            return Base64.decodeBase64((String)data);
        }
        try {
            if (!"charset".equals(attribute)) {
                return this.getText(data, "US-ASCII");
            }
            if (type.startsWith("text/")) {
                return this.getText(data, charset);
            }
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        return new byte[0];
    }

    private byte[] getText(String data, String charset) throws DecoderException {
        URLCodec codec = new URLCodec(charset);
        Charset cs = Charsets.toCharset((String)charset);
        return codec.decode(data).getBytes(cs);
    }
}

