/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class SimilarNameRule
extends Rule {
    private static final int minLength = 4;
    private static final int maxDiff = 1;
    private final Set<String> namesSoFar = new HashSet<String>();

    public SimilarNameRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Angela M\u00fcller ist CEO. <marker>Miller</marker> wurde in Hamburg geboren."), Example.fixed((String)"Angela M\u00fcller ist CEO. <marker>M\u00fcller</marker> wurde in Hamburg geboren."));
        this.setDefaultOff();
    }

    public String getId() {
        return "DE_SIMILAR_NAMES";
    }

    public String getDescription() {
        return "M\u00f6gliche Tippfehler in Namen finden";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
            boolean isName;
            String word = token.getToken();
            boolean bl = isName = word.length() >= 4 && token.hasPartialPosTag("EIG:") && !token.hasPartialPosTag(":COU");
            if (!isName || !StringTools.startsWithUppercase((String)word)) continue;
            String similarName = this.similarName(word);
            if (similarName != null) {
                String msg = "'" + word + "' \u00e4hnelt dem vorher benutzten '" + similarName + "', handelt es sich evtl. um einen Tippfehler?";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, token.getStartPos(), token.getEndPos(), msg);
                ruleMatch.setSuggestedReplacement(similarName);
                ruleMatches.add(ruleMatch);
            }
            this.namesSoFar.add(word);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private String similarName(String nameHere) {
        for (String name : this.namesSoFar) {
            boolean otherNameEndsWithS;
            if (name.equals(nameHere)) continue;
            int lenDiff = Math.abs(name.length() - nameHere.length());
            boolean nameEndsWithS = name.endsWith("s") && !nameHere.endsWith("s");
            boolean bl = otherNameEndsWithS = !name.endsWith("s") && nameHere.endsWith("s");
            if (nameEndsWithS || otherNameEndsWithS || lenDiff > 1 || StringUtils.getLevenshteinDistance((String)name, (String)nameHere) > 1) continue;
            return name;
        }
        return null;
    }

    public void reset() {
        this.namesSoFar.clear();
    }
}

