/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.desktopsupport;

import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Window;
import java.util.Objects;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.madlonkay.desktopsupport.AboutHandler;
import org.madlonkay.desktopsupport.FullScreenListener;
import org.madlonkay.desktopsupport.OpenFilesHandler;
import org.madlonkay.desktopsupport.OpenURIHandler;
import org.madlonkay.desktopsupport.PreferencesHandler;
import org.madlonkay.desktopsupport.PrintFilesHandler;
import org.madlonkay.desktopsupport.QuitHandler;
import org.madlonkay.desktopsupport.QuitStrategy;
import org.madlonkay.desktopsupport.SystemEventListener;

public interface IDesktopSupport {
    public void addAppEventListener(SystemEventListener var1);

    public void removeAppEventListener(SystemEventListener var1);

    public void setAboutHandler(AboutHandler var1);

    public void setPreferencesHandler(PreferencesHandler var1);

    public void setOpenFilesHandler(OpenFilesHandler var1);

    public void setPrintFilesHandler(PrintFilesHandler var1);

    public void setOpenURIHandler(OpenURIHandler var1);

    public void setQuitHandler(QuitHandler var1);

    public void setQuitStrategy(QuitStrategy var1);

    public void enableSuddenTermination();

    public void disableSuddenTermination();

    public void requestForeground(boolean var1);

    public void openHelpViewer();

    public void setDefaultMenuBar(JMenuBar var1);

    public Image getDockIconImage();

    public void setDockIconImage(Image var1);

    public void setDockIconBadge(String var1);

    public PopupMenu getDockMenu();

    public void setDockMenu(PopupMenu var1);

    public void requestUserAttention(boolean var1);

    public void requestToggleFullScreen(Window var1);

    public void setWindowCanFullScreen(Window var1, boolean var2);

    public void addFullScreenListenerTo(Window var1, FullScreenListener var2);

    public void removeFullScreenListenerFrom(Window var1, FullScreenListener var2);

    default public LookAndFeel createLookAndFeel(String name) throws UnsupportedLookAndFeelException {
        Objects.requireNonNull(name);
        if ("GTK look and feel".equals(name)) {
            name = "GTK+";
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!info.getName().equals(name)) continue;
                LookAndFeel laf = (LookAndFeel)Class.forName(info.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (laf.isSupportedLookAndFeel()) {
                    return laf;
                }
                break;
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        throw new UnsupportedLookAndFeelException(name);
    }
}

