/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TMXDateParser {
    private final DateFormat tmxDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public TMXDateParser() {
        this.tmxDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
    }

    public Date parse(String tmxDate) throws ParseException {
        if (tmxDate == null || tmxDate.length() != 16) {
            int offset = tmxDate == null ? 0 : Math.min(tmxDate.length(), 16);
            throw new ParseException("date '" + tmxDate + "' is null or not equal to YYYYMMDDThhmmssZ", offset);
        }
        return this.tmxDateFormat.parse(tmxDate);
    }

    public String getTMXDate(Date date) {
        return this.tmxDateFormat.format(date);
    }

    public String getTMXDate(long date) {
        return this.tmxDateFormat.format(new Date(date));
    }
}

