/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.gameInfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.igoweb.go.Go;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.sgf.TreeChanger;
import org.igoweb.go.swing.RulesWidget;
import org.igoweb.go.swing.sgf.gameInfo.DateListPanel;
import org.igoweb.go.swing.sgf.gameInfo.ResultEditor;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.LabelPair;

public class DisplayWindow
extends DFrame
implements TreeChanger {
    public final Tree tree;
    private ATextField[] playerRanks = new ATextField[2];
    private JTextArea gameComments;
    private DateListPanel dateListPanel = null;
    private NonSizingRules rulesWidget;
    private ResultEditor resultEditor;
    private ArrayList<JComponent> enableDisable = new ArrayList();
    private boolean editable = true;
    private final ArrayList<TextPropEntry> textPropEntries = new ArrayList();
    private TreeChanger changer;

    public DisplayWindow(Tree tree, Component parent, boolean rulesEditable) {
        this(Defs.getString(-478254166), tree, parent, null, rulesEditable);
        this.setVisible(true);
    }

    public DisplayWindow(Tree tree, Component parent, TreeChanger changer, boolean rulesEditable) {
        this(Defs.getString(-478254166), tree, parent, changer, rulesEditable);
        this.setVisible(true);
    }

    private DisplayWindow(String title, Tree tree, Component parent, TreeChanger changer, boolean rulesEditable) {
        super(title, parent);
        this.tree = tree;
        this.changer = changer == null ? this : changer;
        JTabbedPane tabPane = new JTabbedPane();
        this.setMainPanel(tabPane);
        JPanel panel = new JPanel(new GCLayout());
        tabPane.add(Defs.getString(-478254152), panel);
        LabelPair.Group lpGroup = new LabelPair.Group();
        TextPropEntry textProp = new TextPropEntry(-478254137, 2, 1, lpGroup);
        this.textPropEntries.add(textProp);
        panel.add("xGrow=t,yGrow=f", textProp);
        textProp = new TextPropEntry(-478254174, 2, 0, lpGroup);
        panel.add(textProp);
        this.textPropEntries.add(textProp);
        this.playerRanks[1] = new ATextField(this.paramRank(1), 15, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DisplayWindow.this.setPropRank(1, false)) {
                    DisplayWindow.this.playerRanks[1].transferFocus();
                }
            }
        });
        panel.add("x=0", new LabelPair(Defs.getString(-478254139), this.playerRanks[1], lpGroup));
        this.playerRanks[0] = new ATextField(this.paramRank(0), 15, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DisplayWindow.this.setPropRank(0, false)) {
                    DisplayWindow.this.playerRanks[0].transferFocus();
                }
            }
        });
        panel.add(new LabelPair(Defs.getString(-478254173), this.playerRanks[0], lpGroup));
        textProp = new TextPropEntry(-478254138, 10, 1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254172, 10, 0, lpGroup);
        panel.add(textProp);
        this.textPropEntries.add(textProp);
        lpGroup = new LabelPair.Group();
        this.resultEditor = new ResultEditor(tree.root);
        panel.add("x=0,xSpan=2", new LabelPair(Defs.getString(-478254147), this.resultEditor, lpGroup));
        textProp = new TextPropEntry(-478254155, 1, -1, lpGroup);
        panel.add("x=0,xSpan=2", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254157, 7, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254146, 8, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254151, 9, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254145, 11, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254165, 5, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254176, 12, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        textProp = new TextPropEntry(-478254143, 13, -1, lpGroup);
        panel.add("x=0", textProp);
        this.textPropEntries.add(textProp);
        this.dateListPanel = new DateListPanel(tree);
        tabPane.add(Defs.getString(-478254161), this.dateListPanel);
        panel = new JPanel(new GCLayout());
        tabPane.add(Defs.getString(-451068487), panel);
        this.rulesWidget = new NonSizingRules(new Rules(this.rules()), rulesEditable);
        panel.add("xGrow=t,yGrow=f", this.rulesWidget);
        panel.add("x=0,yGrow=t", new JLabel());
        this.gameComments = new JTextArea(this.paramString(6, -1), 3, 20);
        this.enableDisable.add(this.gameComments);
        this.gameComments.setBackground(UIManager.getColor("org.igoweb.inputBg"));
        JScrollPane scroller = new JScrollPane(this.gameComments, 22, 31);
        tabPane.add(Defs.getString(-478254156), scroller);
        this.addButton(Defs.getString(1436228518), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (DisplayWindow.this.sync()) {
                    DisplayWindow.this.okPressed();
                }
            }
        });
        this.addButton(Defs.getString(1436228510), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DisplayWindow.this.dispose();
            }
        });
        this.addButton(Defs.getString(1436228516), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GuiUtil.loadHelp(DisplayWindow.this.helpPageUrl());
            }
        });
        this.pack();
    }

    public String paramString(int paramType, int color) {
        Prop param = color == -1 ? this.tree.root.findProp(paramType) : this.tree.root.findProp(paramType, color);
        if (param == null) {
            return "";
        }
        return param.getText();
    }

    private void setPropString(int paramType, int color, String newValue) {
        boolean hasColor = Prop.hasColor(paramType);
        Node root = this.tree.root;
        if (newValue.length() == 0) {
            Prop victim;
            Prop prop = victim = hasColor ? root.findProp(paramType, color) : root.findProp(paramType);
            if (victim != null) {
                this.changer.removeProp(root, victim);
            }
        } else {
            this.changer.addProp(root, hasColor ? new Prop(paramType, color, newValue) : new Prop(paramType, newValue));
        }
    }

    private String paramRank(int color) {
        Prop param = this.tree.root.findProp(3, color);
        if (param == null) {
            return "";
        }
        return Go.formatRank(param.getInt());
    }

    private boolean setPropRank(int color, boolean modify) {
        Object[] ranks = null;
        int rankType = 0;
        if (this.playerRanks[color] == null) {
            return true;
        }
        String rankIn = this.playerRanks[color].getText();
        if (rankIn.equals("")) {
            Prop victim;
            if (modify && (victim = this.tree.root.findProp(3, color)) != null) {
                this.changer.removeProp(this.tree.root, victim);
            }
            return true;
        }
        StringTokenizer rankParsers = new StringTokenizer(Defs.getString(-478254150));
        while (rankParsers.hasMoreElements()) {
            try {
                ranks = new MessageFormat(rankParsers.nextToken()).parse(rankIn);
                break;
            }
            catch (ParseException exception) {
                ranks = null;
                ++rankType;
            }
        }
        int rank = -1;
        if (ranks != null) {
            int rankVal = ((Number)ranks[0]).intValue();
            if (rankType == 0) {
                if (rankVal >= 1 && rankVal <= 30) {
                    rank = 30 - rankVal + 1;
                }
            } else if (rankType == 1) {
                if (rankVal >= 1 && rankVal <= 9) {
                    rank = 30 + rankVal;
                }
            } else if (rankType == 2 && rankVal >= 1 && rankVal <= 9) {
                rank = 39 + rankVal;
            }
        }
        if (rank == -1) {
            new Errout(Defs.getString(-478254170, rankIn), this);
            return false;
        }
        if (modify) {
            this.changer.addProp(this.tree.root, new Prop(3, color, rank));
        }
        return true;
    }

    public boolean sync() {
        if (this.setPropRank(1, false) && this.setPropRank(0, false)) {
            Iterator<TextPropEntry> textPropEnum = this.textPropEntries.iterator();
            while (textPropEnum.hasNext()) {
                textPropEnum.next().sync();
            }
            if (this.dateListPanel != null) {
                this.dateListPanel.sync();
            }
            this.setPropRank(1, true);
            this.setPropRank(0, true);
            if (this.gameComments != null) {
                String comment = this.gameComments.getText();
                if (comment.equals("")) {
                    this.tree.root.removeType(6);
                } else {
                    this.tree.root.add(new Prop(6, comment));
                }
            }
            return true;
        }
        return false;
    }

    public void okPressed() {
        if (this.resultEditor.parse(false) && this.rulesWidget.verifyInput()) {
            this.resultEditor.parse(true);
            this.tree.root.add(new Prop(0, this.rulesWidget.getRules()));
            this.dispose();
        }
    }

    private Rules rules() {
        return this.tree.root.findProp(0).getRules();
    }

    protected String helpPageUrl() {
        return "app/gameInfoWin.html";
    }

    public void setEditable(boolean newVal) {
        if (newVal != this.editable) {
            this.editable = newVal;
            Iterator<JComponent> iter = this.enableDisable.iterator();
            while (iter.hasNext()) {
                iter.next().setEnabled(this.editable);
            }
        }
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension result = super.getDefaultPreferredSize();
        return result;
    }

    @Override
    public void addProp(Node n, Prop p) {
        n.add(p);
    }

    @Override
    public void removeProp(Node n, Prop p) {
        n.remove(p);
    }

    public class NonSizingRules
    extends RulesWidget {
        public NonSizingRules(Rules rules, boolean isEditable) {
            super(rules, true, true, isEditable);
        }

        @Override
        protected boolean isEditable(int field) {
            return field != 1 && super.isEditable(field);
        }
    }

    private class TextPropEntry
    extends LabelPair {
        private final int paramId;
        private final int color;
        private final ATextField textField;

        public TextPropEntry(int textId, int paramId, int color, LabelPair.Group group) {
            super(Defs.getString(textId), new ATextField(DisplayWindow.this.paramString(paramId, color), 15), group);
            this.textField = (ATextField)this.getComponent(1);
            DisplayWindow.this.enableDisable.add(this.textField);
            this.paramId = paramId;
            this.color = color;
        }

        public void sync() {
            DisplayWindow.this.setPropString(this.paramId, this.color, this.textField.getText());
        }
    }
}

