/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;

public class ShardFollowNodeTaskStatus
implements Task.Status {
    public static final String STATUS_PARSER_NAME = "shard-follow-node-task-status";
    private static final ParseField LEADER_CLUSTER = new ParseField("remote_cluster", new String[0]);
    private static final ParseField LEADER_INDEX = new ParseField("leader_index", new String[0]);
    private static final ParseField FOLLOWER_INDEX = new ParseField("follower_index", new String[0]);
    private static final ParseField SHARD_ID = new ParseField("shard_id", new String[0]);
    private static final ParseField LEADER_GLOBAL_CHECKPOINT_FIELD = new ParseField("leader_global_checkpoint", new String[0]);
    private static final ParseField LEADER_MAX_SEQ_NO_FIELD = new ParseField("leader_max_seq_no", new String[0]);
    private static final ParseField FOLLOWER_GLOBAL_CHECKPOINT_FIELD = new ParseField("follower_global_checkpoint", new String[0]);
    private static final ParseField FOLLOWER_MAX_SEQ_NO_FIELD = new ParseField("follower_max_seq_no", new String[0]);
    private static final ParseField LAST_REQUESTED_SEQ_NO_FIELD = new ParseField("last_requested_seq_no", new String[0]);
    private static final ParseField OUTSTANDING_READ_REQUESTS = new ParseField("outstanding_read_requests", new String[0]);
    private static final ParseField OUTSTANDING_WRITE_REQUESTS = new ParseField("outstanding_write_requests", new String[0]);
    private static final ParseField WRITE_BUFFER_OPERATION_COUNT_FIELD = new ParseField("write_buffer_operation_count", new String[0]);
    private static final ParseField WRITE_BUFFER_SIZE_IN_BYTES_FIELD = new ParseField("write_buffer_size_in_bytes", new String[0]);
    private static final ParseField FOLLOWER_MAPPING_VERSION_FIELD = new ParseField("follower_mapping_version", new String[0]);
    private static final ParseField FOLLOWER_SETTINGS_VERSION_FIELD = new ParseField("follower_settings_version", new String[0]);
    private static final ParseField TOTAL_READ_TIME_MILLIS_FIELD = new ParseField("total_read_time_millis", new String[0]);
    private static final ParseField TOTAL_READ_REMOTE_EXEC_TIME_MILLIS_FIELD = new ParseField("total_read_remote_exec_time_millis", new String[0]);
    private static final ParseField SUCCESSFUL_READ_REQUESTS_FIELD = new ParseField("successful_read_requests", new String[0]);
    private static final ParseField FAILED_READ_REQUESTS_FIELD = new ParseField("failed_read_requests", new String[0]);
    private static final ParseField OPERATIONS_READ_FIELD = new ParseField("operations_read", new String[0]);
    private static final ParseField BYTES_READ = new ParseField("bytes_read", new String[0]);
    private static final ParseField TOTAL_WRITE_TIME_MILLIS_FIELD = new ParseField("total_write_time_millis", new String[0]);
    private static final ParseField SUCCESSFUL_WRITE_REQUESTS_FIELD = new ParseField("successful_write_requests", new String[0]);
    private static final ParseField FAILED_WRITE_REQUEST_FIELD = new ParseField("failed_write_requests", new String[0]);
    private static final ParseField OPERATIONS_WRITTEN = new ParseField("operations_written", new String[0]);
    private static final ParseField READ_EXCEPTIONS = new ParseField("read_exceptions", new String[0]);
    private static final ParseField TIME_SINCE_LAST_READ_MILLIS_FIELD = new ParseField("time_since_last_read_millis", new String[0]);
    private static final ParseField FATAL_EXCEPTION = new ParseField("fatal_exception", new String[0]);
    static final ConstructingObjectParser<ShardFollowNodeTaskStatus, Void> STATUS_PARSER = new ConstructingObjectParser("shard-follow-node-task-status", args -> new ShardFollowNodeTaskStatus((String)args[0], (String)args[1], (String)args[2], (Integer)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Integer)args[9], (Integer)args[10], (Integer)args[11], (Long)args[12], (Long)args[13], (Long)args[14], (Long)args[15], (Long)args[16], (Long)args[17], (Long)args[18], (Long)args[19], (Long)args[20], (Long)args[21], (Long)args[22], (Long)args[23], (Long)args[24], new TreeMap<Long, Tuple<Integer, ElasticsearchException>>(((List)args[25]).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), (Long)args[26], (ElasticsearchException)args[27]));
    public static final String READ_EXCEPTIONS_ENTRY_PARSER_NAME = "shard-follow-node-task-status-read-exceptions-entry";
    static final ConstructingObjectParser<Map.Entry<Long, Tuple<Integer, ElasticsearchException>>, Void> READ_EXCEPTIONS_ENTRY_PARSER = new ConstructingObjectParser("shard-follow-node-task-status-read-exceptions-entry", args -> new AbstractMap.SimpleEntry<Long, Tuple>((Long)args[0], Tuple.tuple((Object)((Integer)args[1]), (Object)((ElasticsearchException)args[2]))));
    static final ParseField READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO;
    static final ParseField READ_EXCEPTIONS_RETRIES;
    static final ParseField READ_EXCEPTIONS_ENTRY_EXCEPTION;
    private final String remoteCluster;
    private final String leaderIndex;
    private final String followerIndex;
    private final int shardId;
    private final long leaderGlobalCheckpoint;
    private final long leaderMaxSeqNo;
    private final long followerGlobalCheckpoint;
    private final long followerMaxSeqNo;
    private final long lastRequestedSeqNo;
    private final int outstandingReadRequests;
    private final int outstandingWriteRequests;
    private final int writeBufferOperationCount;
    private final long writeBufferSizeInBytes;
    private final long followerMappingVersion;
    private final long followerSettingsVersion;
    private final long totalReadTimeMillis;
    private final long totalReadRemoteExecTimeMillis;
    private final long successfulReadRequests;
    private final long failedReadRequests;
    private final long operationsReads;
    private final long bytesRead;
    private final long totalWriteTimeMillis;
    private final long successfulWriteRequests;
    private final long failedWriteRequests;
    private final long operationWritten;
    private final NavigableMap<Long, Tuple<Integer, ElasticsearchException>> readExceptions;
    private final long timeSinceLastReadMillis;
    private final ElasticsearchException fatalException;

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public String leaderIndex() {
        return this.leaderIndex;
    }

    public String followerIndex() {
        return this.followerIndex;
    }

    public int getShardId() {
        return this.shardId;
    }

    public long leaderGlobalCheckpoint() {
        return this.leaderGlobalCheckpoint;
    }

    public long leaderMaxSeqNo() {
        return this.leaderMaxSeqNo;
    }

    public long followerGlobalCheckpoint() {
        return this.followerGlobalCheckpoint;
    }

    public long followerMaxSeqNo() {
        return this.followerMaxSeqNo;
    }

    public long lastRequestedSeqNo() {
        return this.lastRequestedSeqNo;
    }

    public int outstandingReadRequests() {
        return this.outstandingReadRequests;
    }

    public int outstandingWriteRequests() {
        return this.outstandingWriteRequests;
    }

    public int writeBufferOperationCount() {
        return this.writeBufferOperationCount;
    }

    public long writeBufferSizeInBytes() {
        return this.writeBufferSizeInBytes;
    }

    public long followerMappingVersion() {
        return this.followerMappingVersion;
    }

    public long followerSettingsVersion() {
        return this.followerSettingsVersion;
    }

    public long totalReadTimeMillis() {
        return this.totalReadTimeMillis;
    }

    public long totalReadRemoteExecTimeMillis() {
        return this.totalReadRemoteExecTimeMillis;
    }

    public long successfulReadRequests() {
        return this.successfulReadRequests;
    }

    public long failedReadRequests() {
        return this.failedReadRequests;
    }

    public long operationsReads() {
        return this.operationsReads;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long totalWriteTimeMillis() {
        return this.totalWriteTimeMillis;
    }

    public long successfulWriteRequests() {
        return this.successfulWriteRequests;
    }

    public long failedWriteRequests() {
        return this.failedWriteRequests;
    }

    public long operationWritten() {
        return this.operationWritten;
    }

    public NavigableMap<Long, Tuple<Integer, ElasticsearchException>> readExceptions() {
        return this.readExceptions;
    }

    public long timeSinceLastReadMillis() {
        return this.timeSinceLastReadMillis;
    }

    public ElasticsearchException getFatalException() {
        return this.fatalException;
    }

    public ShardFollowNodeTaskStatus(String remoteCluster, String leaderIndex, String followerIndex, int shardId, long leaderGlobalCheckpoint, long leaderMaxSeqNo, long followerGlobalCheckpoint, long followerMaxSeqNo, long lastRequestedSeqNo, int outstandingReadRequests, int outstandingWriteRequests, int writeBufferOperationCount, long writeBufferSizeInBytes, long followerMappingVersion, long followerSettingsVersion, long totalReadTimeMillis, long totalReadRemoteExecTimeMillis, long successfulReadRequests, long failedReadRequests, long operationsReads, long bytesRead, long totalWriteTimeMillis, long successfulWriteRequests, long failedWriteRequests, long operationWritten, NavigableMap<Long, Tuple<Integer, ElasticsearchException>> readExceptions, long timeSinceLastReadMillis, ElasticsearchException fatalException) {
        this.remoteCluster = remoteCluster;
        this.leaderIndex = leaderIndex;
        this.followerIndex = followerIndex;
        this.shardId = shardId;
        this.leaderGlobalCheckpoint = leaderGlobalCheckpoint;
        this.leaderMaxSeqNo = leaderMaxSeqNo;
        this.followerGlobalCheckpoint = followerGlobalCheckpoint;
        this.followerMaxSeqNo = followerMaxSeqNo;
        this.lastRequestedSeqNo = lastRequestedSeqNo;
        this.outstandingReadRequests = outstandingReadRequests;
        this.outstandingWriteRequests = outstandingWriteRequests;
        this.writeBufferOperationCount = writeBufferOperationCount;
        this.writeBufferSizeInBytes = writeBufferSizeInBytes;
        this.followerMappingVersion = followerMappingVersion;
        this.followerSettingsVersion = followerSettingsVersion;
        this.totalReadTimeMillis = totalReadTimeMillis;
        this.totalReadRemoteExecTimeMillis = totalReadRemoteExecTimeMillis;
        this.successfulReadRequests = successfulReadRequests;
        this.failedReadRequests = failedReadRequests;
        this.operationsReads = operationsReads;
        this.bytesRead = bytesRead;
        this.totalWriteTimeMillis = totalWriteTimeMillis;
        this.successfulWriteRequests = successfulWriteRequests;
        this.failedWriteRequests = failedWriteRequests;
        this.operationWritten = operationWritten;
        this.readExceptions = Objects.requireNonNull(readExceptions);
        this.timeSinceLastReadMillis = timeSinceLastReadMillis;
        this.fatalException = fatalException;
    }

    public ShardFollowNodeTaskStatus(StreamInput in) throws IOException {
        this.remoteCluster = in.readOptionalString();
        this.leaderIndex = in.readString();
        this.followerIndex = in.readString();
        this.shardId = in.readVInt();
        this.leaderGlobalCheckpoint = in.readZLong();
        this.leaderMaxSeqNo = in.readZLong();
        this.followerGlobalCheckpoint = in.readZLong();
        this.followerMaxSeqNo = in.readZLong();
        this.lastRequestedSeqNo = in.readZLong();
        this.outstandingReadRequests = in.readVInt();
        this.outstandingWriteRequests = in.readVInt();
        this.writeBufferOperationCount = in.readVInt();
        this.writeBufferSizeInBytes = in.readVLong();
        this.followerMappingVersion = in.readVLong();
        this.followerSettingsVersion = in.readVLong();
        this.totalReadTimeMillis = in.readVLong();
        this.totalReadRemoteExecTimeMillis = in.readVLong();
        this.successfulReadRequests = in.readVLong();
        this.failedReadRequests = in.readVLong();
        this.operationsReads = in.readVLong();
        this.bytesRead = in.readVLong();
        this.totalWriteTimeMillis = in.readVLong();
        this.successfulWriteRequests = in.readVLong();
        this.failedWriteRequests = in.readVLong();
        this.operationWritten = in.readVLong();
        this.readExceptions = new TreeMap<Long, Tuple<Integer, ElasticsearchException>>(in.readMap(StreamInput::readVLong, stream -> Tuple.tuple((Object)stream.readVInt(), (Object)((ElasticsearchException)stream.readException()))));
        this.timeSinceLastReadMillis = in.readZLong();
        this.fatalException = (ElasticsearchException)in.readException();
    }

    public String getWriteableName() {
        return STATUS_PARSER_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.remoteCluster);
        out.writeString(this.leaderIndex);
        out.writeString(this.followerIndex);
        out.writeVInt(this.shardId);
        out.writeZLong(this.leaderGlobalCheckpoint);
        out.writeZLong(this.leaderMaxSeqNo);
        out.writeZLong(this.followerGlobalCheckpoint);
        out.writeZLong(this.followerMaxSeqNo);
        out.writeZLong(this.lastRequestedSeqNo);
        out.writeVInt(this.outstandingReadRequests);
        out.writeVInt(this.outstandingWriteRequests);
        out.writeVInt(this.writeBufferOperationCount);
        out.writeVLong(this.writeBufferSizeInBytes);
        out.writeVLong(this.followerMappingVersion);
        out.writeVLong(this.followerSettingsVersion);
        out.writeVLong(this.totalReadTimeMillis);
        out.writeVLong(this.totalReadRemoteExecTimeMillis);
        out.writeVLong(this.successfulReadRequests);
        out.writeVLong(this.failedReadRequests);
        out.writeVLong(this.operationsReads);
        out.writeVLong(this.bytesRead);
        out.writeVLong(this.totalWriteTimeMillis);
        out.writeVLong(this.successfulWriteRequests);
        out.writeVLong(this.failedWriteRequests);
        out.writeVLong(this.operationWritten);
        out.writeMap(this.readExceptions, StreamOutput::writeVLong, (stream, value) -> {
            stream.writeVInt(((Integer)value.v1()).intValue());
            stream.writeException((Throwable)value.v2());
        });
        out.writeZLong(this.timeSinceLastReadMillis);
        out.writeException((Throwable)this.fatalException);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(LEADER_CLUSTER.getPreferredName(), this.remoteCluster);
        builder.field(LEADER_INDEX.getPreferredName(), this.leaderIndex);
        builder.field(FOLLOWER_INDEX.getPreferredName(), this.followerIndex);
        builder.field(SHARD_ID.getPreferredName(), this.shardId);
        builder.field(LEADER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.leaderGlobalCheckpoint);
        builder.field(LEADER_MAX_SEQ_NO_FIELD.getPreferredName(), this.leaderMaxSeqNo);
        builder.field(FOLLOWER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.followerGlobalCheckpoint);
        builder.field(FOLLOWER_MAX_SEQ_NO_FIELD.getPreferredName(), this.followerMaxSeqNo);
        builder.field(LAST_REQUESTED_SEQ_NO_FIELD.getPreferredName(), this.lastRequestedSeqNo);
        builder.field(OUTSTANDING_READ_REQUESTS.getPreferredName(), this.outstandingReadRequests);
        builder.field(OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.outstandingWriteRequests);
        builder.field(WRITE_BUFFER_OPERATION_COUNT_FIELD.getPreferredName(), this.writeBufferOperationCount);
        builder.humanReadableField(WRITE_BUFFER_SIZE_IN_BYTES_FIELD.getPreferredName(), "write_buffer_size", (Object)new ByteSizeValue(this.writeBufferSizeInBytes));
        builder.field(FOLLOWER_MAPPING_VERSION_FIELD.getPreferredName(), this.followerMappingVersion);
        builder.field(FOLLOWER_SETTINGS_VERSION_FIELD.getPreferredName(), this.followerSettingsVersion);
        builder.humanReadableField(TOTAL_READ_TIME_MILLIS_FIELD.getPreferredName(), "total_read_time", (Object)new TimeValue(this.totalReadTimeMillis, TimeUnit.MILLISECONDS));
        builder.humanReadableField(TOTAL_READ_REMOTE_EXEC_TIME_MILLIS_FIELD.getPreferredName(), "total_read_remote_exec_time", (Object)new TimeValue(this.totalReadRemoteExecTimeMillis, TimeUnit.MILLISECONDS));
        builder.field(SUCCESSFUL_READ_REQUESTS_FIELD.getPreferredName(), this.successfulReadRequests);
        builder.field(FAILED_READ_REQUESTS_FIELD.getPreferredName(), this.failedReadRequests);
        builder.field(OPERATIONS_READ_FIELD.getPreferredName(), this.operationsReads);
        builder.humanReadableField(BYTES_READ.getPreferredName(), "total_read", (Object)new ByteSizeValue(this.bytesRead, ByteSizeUnit.BYTES));
        builder.humanReadableField(TOTAL_WRITE_TIME_MILLIS_FIELD.getPreferredName(), "total_write_time", (Object)new TimeValue(this.totalWriteTimeMillis, TimeUnit.MILLISECONDS));
        builder.field(SUCCESSFUL_WRITE_REQUESTS_FIELD.getPreferredName(), this.successfulWriteRequests);
        builder.field(FAILED_WRITE_REQUEST_FIELD.getPreferredName(), this.failedWriteRequests);
        builder.field(OPERATIONS_WRITTEN.getPreferredName(), this.operationWritten);
        builder.startArray(READ_EXCEPTIONS.getPreferredName());
        for (Map.Entry entry : this.readExceptions.entrySet()) {
            builder.startObject();
            builder.field(READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO.getPreferredName(), (Long)entry.getKey());
            builder.field(READ_EXCEPTIONS_RETRIES.getPreferredName(), (Integer)((Tuple)entry.getValue()).v1());
            builder.field(READ_EXCEPTIONS_ENTRY_EXCEPTION.getPreferredName());
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)((Throwable)((Tuple)entry.getValue()).v2()));
            builder.endObject();
            builder.endObject();
        }
        builder.endArray();
        builder.humanReadableField(TIME_SINCE_LAST_READ_MILLIS_FIELD.getPreferredName(), "time_since_last_read", (Object)new TimeValue(this.timeSinceLastReadMillis, TimeUnit.MILLISECONDS));
        if (this.fatalException != null) {
            builder.field(FATAL_EXCEPTION.getPreferredName());
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.fatalException);
            builder.endObject();
        }
        return builder;
    }

    public static ShardFollowNodeTaskStatus fromXContent(XContentParser parser) {
        return (ShardFollowNodeTaskStatus)STATUS_PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardFollowNodeTaskStatus that = (ShardFollowNodeTaskStatus)o;
        String fatalExceptionMessage = this.fatalException != null ? this.fatalException.getMessage() : null;
        String otherFatalExceptionMessage = that.fatalException != null ? that.fatalException.getMessage() : null;
        return this.remoteCluster.equals(that.remoteCluster) && this.leaderIndex.equals(that.leaderIndex) && this.followerIndex.equals(that.followerIndex) && this.shardId == that.shardId && this.leaderGlobalCheckpoint == that.leaderGlobalCheckpoint && this.leaderMaxSeqNo == that.leaderMaxSeqNo && this.followerGlobalCheckpoint == that.followerGlobalCheckpoint && this.followerMaxSeqNo == that.followerMaxSeqNo && this.lastRequestedSeqNo == that.lastRequestedSeqNo && this.outstandingReadRequests == that.outstandingReadRequests && this.outstandingWriteRequests == that.outstandingWriteRequests && this.writeBufferOperationCount == that.writeBufferOperationCount && this.writeBufferSizeInBytes == that.writeBufferSizeInBytes && this.followerMappingVersion == that.followerMappingVersion && this.followerSettingsVersion == that.followerSettingsVersion && this.totalReadTimeMillis == that.totalReadTimeMillis && this.totalReadRemoteExecTimeMillis == that.totalReadRemoteExecTimeMillis && this.successfulReadRequests == that.successfulReadRequests && this.failedReadRequests == that.failedReadRequests && this.operationsReads == that.operationsReads && this.bytesRead == that.bytesRead && this.successfulWriteRequests == that.successfulWriteRequests && this.failedWriteRequests == that.failedWriteRequests && this.operationWritten == that.operationWritten && this.readExceptions.keySet().equals(that.readExceptions.keySet()) && ShardFollowNodeTaskStatus.getReadExceptionMessages(this).equals(ShardFollowNodeTaskStatus.getReadExceptionMessages(that)) && this.timeSinceLastReadMillis == that.timeSinceLastReadMillis && Objects.equals(fatalExceptionMessage, otherFatalExceptionMessage);
    }

    public int hashCode() {
        String fatalExceptionMessage = this.fatalException != null ? this.fatalException.getMessage() : null;
        return Objects.hash(this.remoteCluster, this.leaderIndex, this.followerIndex, this.shardId, this.leaderGlobalCheckpoint, this.leaderMaxSeqNo, this.followerGlobalCheckpoint, this.followerMaxSeqNo, this.lastRequestedSeqNo, this.outstandingReadRequests, this.outstandingWriteRequests, this.writeBufferOperationCount, this.writeBufferSizeInBytes, this.followerMappingVersion, this.followerSettingsVersion, this.totalReadTimeMillis, this.totalReadRemoteExecTimeMillis, this.successfulReadRequests, this.failedReadRequests, this.operationsReads, this.bytesRead, this.successfulWriteRequests, this.failedWriteRequests, this.operationWritten, this.readExceptions.keySet(), ShardFollowNodeTaskStatus.getReadExceptionMessages(this), this.timeSinceLastReadMillis, fatalExceptionMessage);
    }

    private static List<String> getReadExceptionMessages(ShardFollowNodeTaskStatus status) {
        return status.readExceptions().values().stream().map(t -> ((ElasticsearchException)t.v2()).getMessage()).collect(Collectors.toList());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        STATUS_PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_CLUSTER);
        STATUS_PARSER.declareString(ConstructingObjectParser.constructorArg(), LEADER_INDEX);
        STATUS_PARSER.declareString(ConstructingObjectParser.constructorArg(), FOLLOWER_INDEX);
        STATUS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), SHARD_ID);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), LEADER_GLOBAL_CHECKPOINT_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), LEADER_MAX_SEQ_NO_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_GLOBAL_CHECKPOINT_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_MAX_SEQ_NO_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), LAST_REQUESTED_SEQ_NO_FIELD);
        STATUS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), OUTSTANDING_READ_REQUESTS);
        STATUS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), OUTSTANDING_WRITE_REQUESTS);
        STATUS_PARSER.declareInt(ConstructingObjectParser.constructorArg(), WRITE_BUFFER_OPERATION_COUNT_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), WRITE_BUFFER_SIZE_IN_BYTES_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_MAPPING_VERSION_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FOLLOWER_SETTINGS_VERSION_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_READ_TIME_MILLIS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_READ_REMOTE_EXEC_TIME_MILLIS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SUCCESSFUL_READ_REQUESTS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILED_READ_REQUESTS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), OPERATIONS_READ_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), BYTES_READ);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_WRITE_TIME_MILLIS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), SUCCESSFUL_WRITE_REQUESTS_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILED_WRITE_REQUEST_FIELD);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), OPERATIONS_WRITTEN);
        STATUS_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_ENTRY_PARSER, READ_EXCEPTIONS);
        STATUS_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIME_SINCE_LAST_READ_MILLIS_FIELD);
        STATUS_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), FATAL_EXCEPTION);
        READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO = new ParseField("from_seq_no", new String[0]);
        READ_EXCEPTIONS_RETRIES = new ParseField("retries", new String[0]);
        READ_EXCEPTIONS_ENTRY_EXCEPTION = new ParseField("exception", new String[0]);
        READ_EXCEPTIONS_ENTRY_PARSER.declareLong(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_ENTRY_FROM_SEQ_NO);
        READ_EXCEPTIONS_ENTRY_PARSER.declareInt(ConstructingObjectParser.constructorArg(), READ_EXCEPTIONS_RETRIES);
        READ_EXCEPTIONS_ENTRY_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), READ_EXCEPTIONS_ENTRY_EXCEPTION);
    }
}

