/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.ScheduledEventsQueryBuilder;

public class TransportGetCalendarEventsAction
extends HandledTransportAction<GetCalendarEventsAction.Request, GetCalendarEventsAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportGetCalendarEventsAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super(settings, "cluster:monitor/xpack/ml/calendars/events/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetCalendarEventsAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(GetCalendarEventsAction.Request request, ActionListener<GetCalendarEventsAction.Response> listener) {
        ActionListener calendarExistsListener = ActionListener.wrap(r -> {
            ScheduledEventsQueryBuilder query = new ScheduledEventsQueryBuilder().start(request.getStart()).end(request.getEnd()).from(request.getPageParams().getFrom()).size(request.getPageParams().getSize());
            if (!"_all".equals(request.getCalendarId())) {
                query.calendarIds(Collections.singletonList(request.getCalendarId()));
            }
            ActionListener eventsListener = ActionListener.wrap(events -> listener.onResponse((Object)new GetCalendarEventsAction.Response(events)), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            if (request.getJobId() != null) {
                this.jobManager.getJob(request.getJobId(), (ActionListener<Job>)ActionListener.wrap(job -> this.jobResultsProvider.scheduledEventsForJob(request.getJobId(), job.getGroups(), query, (ActionListener<QueryPage<ScheduledEvent>>)eventsListener), jobNotFound -> this.jobManager.groupExists(request.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(groupExists -> {
                    if (groupExists.booleanValue()) {
                        this.jobResultsProvider.scheduledEventsForJob(null, Collections.singletonList(request.getJobId()), query, (ActionListener<QueryPage<ScheduledEvent>>)eventsListener);
                    } else {
                        listener.onFailure((Exception)ExceptionsHelper.missingJobException((String)request.getJobId()));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)))));
            } else {
                this.jobResultsProvider.scheduledEvents(query, (ActionListener<QueryPage<ScheduledEvent>>)eventsListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.checkCalendarExists(request.getCalendarId(), (ActionListener<Boolean>)calendarExistsListener);
    }

    private void checkCalendarExists(String calendarId, ActionListener<Boolean> listener) {
        if ("_all".equals(calendarId)) {
            listener.onResponse((Object)true);
            return;
        }
        this.jobResultsProvider.calendar(calendarId, (ActionListener<Calendar>)ActionListener.wrap(c -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }
}

