/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ClearInMemoryPasswordEncoder
extends InMemoryPasswordEncoder {
    public ClearInMemoryPasswordEncoder(String prefix, PasswordEncoderOutputFormatter outputFormatter) {
        super(prefix, outputFormatter);
    }

    @Override
    protected byte[] encodePassword(byte[] clearPassword, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
        return clearPassword;
    }

    @Override
    protected void ensurePreEncodedPasswordAppearsValid(byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry, List<Modification> modifications) throws LDAPException {
    }

    @Override
    protected boolean passwordMatches(byte[] clearPasswordBytes, byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry) throws LDAPException {
        return Arrays.equals(clearPasswordBytes, unPrefixedUnFormattedEncodedPasswordBytes);
    }

    @Override
    protected byte[] extractClearPassword(byte[] unPrefixedUnFormattedEncodedPasswordBytes, ReadOnlyEntry userEntry) throws LDAPException {
        return unPrefixedUnFormattedEncodedPasswordBytes;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ClearInMemoryPasswordEncoder(prefix='");
        buffer.append(this.getPrefix());
        buffer.append("', outputFormatter=");
        PasswordEncoderOutputFormatter outputFormatter = this.getOutputFormatter();
        if (outputFormatter == null) {
            buffer.append("null");
        } else {
            outputFormatter.toString(buffer);
        }
        buffer.append(')');
    }
}

