/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;

public class SyncTriggerEventConsumer
implements Consumer<Iterable<TriggerEvent>> {
    private static final Logger logger = LogManager.getLogger(SyncTriggerEventConsumer.class);
    private final ExecutionService executionService;

    public SyncTriggerEventConsumer(ExecutionService executionService) {
        this.executionService = executionService;
    }

    @Override
    public void accept(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsSync(events);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to process triggered events [{}]", StreamSupport.stream(events.spliterator(), false).toArray(TriggerEvent[]::new)), (Throwable)e);
        }
    }
}

