/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;

public class UntypedAtomizingIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private final SequenceIterator base;

    public UntypedAtomizingIterator(SequenceIterator base) {
        this.base = base;
    }

    @Override
    public AtomicValue next() {
        try {
            Item nextSource = this.base.next();
            if (nextSource == null) {
                return null;
            }
            return (AtomicValue)nextSource.atomize();
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public void discharge() {
        this.base.discharge();
    }

    @Override
    public boolean supportsGetLength() {
        return SequenceTool.supportsGetLength(this.base);
    }

    @Override
    public int getLength() {
        return SequenceTool.getLength(this.base);
    }

    @Override
    public boolean supportsHasNext() {
        return this.base instanceof LookaheadIterator && ((LookaheadIterator)this.base).supportsHasNext();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }
}

