/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.jmf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import org.flexdock.docking.DockingStub;
import org.flexdock.util.ResourceManager;

public class MediaPanel
extends Panel
implements DockingStub {
    private Player player;
    private Label titlebar;
    private String dockingId;
    private static HashMap jarUrlToTempFileCache = new HashMap();

    public MediaPanel(String id, String title, String mediaFileName) {
        this.dockingId = id;
        this.setLayout(new BorderLayout());
        this.titlebar = new Label(title);
        this.titlebar.setBackground(new Color(183, 201, 217));
        this.add((Component)this.titlebar, "North");
        this.player = MediaPanel.createPlayer(mediaFileName);
        if (this.player != null) {
            Component viewscreen = this.player.getVisualComponent();
            Component controls = this.player.getControlPanelComponent();
            if (viewscreen != null) {
                this.add(viewscreen, "Center");
            } else {
                TextArea ta = new TextArea("No JMF video playback support for '" + mediaFileName + "'");
                ta.setEditable(false);
                this.add((Component)ta, "Center");
            }
            if (controls != null) {
                this.add(controls, "South");
            }
        } else {
            TextArea ta = new TextArea("No JMF decoder support for '" + mediaFileName + "'");
            ta.setEditable(false);
            this.add((Component)ta, "Center");
        }
    }

    private static synchronized Player createPlayer(String mediaUri) {
        try {
            URL url = MediaPanel.replaceJarUrlWithFileUrl(ResourceManager.getResource(mediaUri), mediaUri);
            MediaLocator locator = new MediaLocator(url);
            final Player mediaPlayer = Manager.createRealizedPlayer(locator);
            mediaPlayer.addControllerListener(new ControllerListener(){

                public void controllerUpdate(ControllerEvent evt) {
                    if (evt instanceof EndOfMediaEvent) {
                        mediaPlayer.setMediaTime(new Time(0L));
                        mediaPlayer.start();
                    }
                }
            });
            return mediaPlayer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL replaceJarUrlWithFileUrl(URL url, String mediaUri) throws IOException {
        File f;
        if (!url.getProtocol().equals("jar")) {
            return url;
        }
        HashMap hashMap = jarUrlToTempFileCache;
        synchronized (hashMap) {
            int read;
            f = (File)jarUrlToTempFileCache.get(url);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return f.toURL();
            }
            f = File.createTempFile("flexdock-", mediaUri);
            f.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(f);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] b = new byte[4096];
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            while ((read = is.read(b, 0, b.length)) != -1) {
                bos.write(b, 0, read);
            }
            bos.close();
            jarUrlToTempFileCache.put(url, f);
        }
        return f.toURL();
    }

    protected void finalize() {
        if (this.player != null) {
            this.player.stop();
            this.player.close();
            this.player = null;
        }
    }

    public Component getDragSource() {
        return this.titlebar;
    }

    public Component getFrameDragSource() {
        return this.titlebar;
    }

    public String getPersistentId() {
        return this.dockingId;
    }

    public String getTabText() {
        return this.titlebar.getText();
    }
}

