# Welcome to the Lutok project!

Lutok is a **lightweight C++ API library** for Lua.

Lutok provides thin C++ wrappers around the Lua C API to ease the
interaction between C++ and Lua.  These wrappers make intensive use of
RAII to prevent resource leakage, expose C++-friendly data types, report
errors by means of exceptions and ensure that the Lua stack is always
left untouched in the face of errors.  The library also provides a small
subset of miscellaneous utility functions built on top of the wrappers.

Lutok focuses on providing a clean and safe C++ interface; the drawback
is that it is not suitable for performance-critical environments.  In
order to implement error-safe C++ wrappers on top of a Lua C binary
library, Lutok adds several layers or abstraction and error checking
that go against the original spirit of the Lua C API and thus degrade
performance.

For further information on the contents of this distribution file,
please refer to the following other documents:

* `AUTHORS`: List of authors and contributors to this project.
* `COPYING`: License information.
* `INSTALL.md:` Compilation and installation instructions.
* `NEWS.md`: List of major changes between formal releases.

For general project information, please visit [Lutok on GitHub](https://github.com/freebsd/lutok/)
