/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.Graph2DPrinter;

public class PrintUtil {
    public static final String POSTER_ROWS = GraphBundle.message("graph.framework.printing.poster.rows", new Object[0]);
    public static final String POSTER_COLUMNS = GraphBundle.message("graph.framework.printing.poster.cols", new Object[0]);
    public static final String POSTER_COORDS = GraphBundle.message("graph.framework.printing.poster.coords", new Object[0]);
    public static final String VIEW = GraphBundle.message("graph.framework.printing.view", new Object[0]);
    public static final String GRAPH = GraphBundle.message("graph.framework.printing.graph", new Object[0]);
    public static final String CLIP_AREA = GraphBundle.message("graph.framework.printing.clip.area", new Object[0]);
    public static final String GENERAL_SECTION = GraphBundle.message("graph.framework.printing.general", new Object[0]);
    public static final String TITLE_SECTION = GraphBundle.message("graph.framework.printing.title", new Object[0]);
    public static final String TEXT = GraphBundle.message("graph.framework.printing.title.text", new Object[0]);
    public static final String TITLEBAR_COLOR = GraphBundle.message("graph.framework.printing.title.color", new Object[0]);
    public static final String TEXT_COLOR = GraphBundle.message("graph.framework.printing.title.text.color", new Object[0]);
    public static final String OPTIONS_BUTTON = "Options...";

    private PrintUtil() {
    }

    public static void initGraph2DPrinter(Graph2DPrinter gp, OptionHandler options) {
        if (options.getInt(POSTER_ROWS) < 0) {
            options.set(POSTER_ROWS, Math.abs(options.getInt(POSTER_ROWS)));
        }
        if (options.getInt(POSTER_COLUMNS) < 0) {
            options.set(POSTER_COLUMNS, Math.abs(options.getInt(POSTER_COLUMNS)));
        }
        gp.setPosterRows(options.getInt(POSTER_ROWS));
        gp.setPosterColumns(options.getInt(POSTER_COLUMNS));
        gp.setPrintPosterCoords(options.getBool(POSTER_COORDS));
        if (options.get(CLIP_AREA).equals(GRAPH)) {
            gp.setClipType(Graph2DPrinter.CLIP_GRAPH);
        } else {
            gp.setClipType(Graph2DPrinter.CLIP_VIEW);
        }
    }

    public static OptionHandler createPrintOptions() {
        OptionHandler handler = GraphManager.getGraphManager().createOptionHandler(GraphBundle.message("graph.framework.printing.options", new Object[0]));
        handler.useSection(GENERAL_SECTION);
        handler.addInt(POSTER_ROWS, 1);
        handler.addInt(POSTER_COLUMNS, 1);
        handler.addBool(POSTER_COORDS, false);
        Object[] area = new String[]{VIEW, GRAPH};
        handler.addEnum(CLIP_AREA, area, 1);
        return handler;
    }
}

