/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.index.PrebuiltIndexProviderBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.PrebuiltStubsProviders;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubVersionMap;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubUpdatingIndex
extends CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree, FileContent>
implements PsiDependentIndex,
CustomInputsIndexFileBasedIndexExtension<Integer> {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    private static final int VERSION = 37 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 2, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(@NotNull DataOutput out, @NotNull SerializedStubTree v) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if (v == null) {
                1.$$$reportNull$$$0(1);
            }
            v.write(out);
        }

        @NotNull
        public SerializedStubTree read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(2);
            }
            SerializedStubTree serializedStubTree = new SerializedStubTree(in);
            if (serializedStubTree == null) {
                1.$$$reportNull$$$0(3);
            }
            return serializedStubTree;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    protected static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> StubUpdatingIndex.canHaveStub(file2);
    private static final KeyDescriptor<Integer> DATA_DESCRIPTOR = new IntInlineKeyDescriptor();

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        FileType fileType;
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if ((fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), ProjectUtil.guessProjectForFile((VirtualFile)file2))) instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType) {
                if (((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                    return true;
                }
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (file2 instanceof NewVirtualFile && fileBasedIndex instanceof FileBasedIndexImpl && ((FileBasedIndexImpl)fileBasedIndex).getIndex(INDEX_ID).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2)) {
                    return true;
                }
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    public int getCacheSize() {
        return 5;
    }

    public boolean keyIsUniqueForIndexedFile() {
        return true;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        DataExternalizer<Collection<Integer>> dataExternalizer = new DataExternalizer<Collection<Integer>>(){
            private volatile boolean myEnsuredStubElementTypesLoaded;

            public void save(@NotNull DataOutput out, Collection<Integer> value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.iterator().next());
                Map stubIndicesValueMap = ((StubUpdatingIndexKeys)value).myStubIndicesValueMap;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(stubIndicesValueMap != null ? stubIndicesValueMap.size() : 0));
                if (stubIndicesValueMap != null && !stubIndicesValueMap.isEmpty()) {
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (StubIndexKey stubIndexKey : stubIndicesValueMap.keySet()) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubIndexKey.getUniqueId());
                        Map map = (Map)stubIndicesValueMap.get(stubIndexKey);
                        stubIndex.serializeIndexValue(out, stubIndexKey, map);
                    }
                }
            }

            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.myEnsuredStubElementTypesLoaded) {
                    SerializationManager.getInstance().initSerializers();
                    StubIndexImpl.initExtensions();
                    this.myEnsuredStubElementTypesLoaded = true;
                }
                int fileId = DataInputOutputUtil.readINT((DataInput)in);
                StubUpdatingIndexKeys integers = new StubUpdatingIndexKeys(ContainerUtil.set((Object[])new Integer[]{fileId}));
                int stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in);
                if (stubIndicesValueMapSize > 0) {
                    THashMap stubIndicesValueMap = new THashMap(stubIndicesValueMapSize);
                    StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                    for (int i = 0; i < stubIndicesValueMapSize; ++i) {
                        int stubIndexId = DataInputOutputUtil.readINT((DataInput)in);
                        ID indexKey = ID.findById((int)stubIndexId);
                        if (!(indexKey instanceof StubIndexKey)) continue;
                        StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                        stubIndicesValueMap.put((Object)stubIndexKey, stubIndex.deserializeIndexValue(in, stubIndexKey));
                    }
                    integers.myStubIndicesValueMap = (Map)stubIndicesValueMap;
                }
                return integers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public DataIndexer<Integer, SerializedStubTree, FileContent> getIndexer() {
        DataIndexer<Integer, SerializedStubTree, FileContent> dataIndexer = new DataIndexer<Integer, SerializedStubTree, FileContent>(){

            @NotNull
            public Map<Integer, SerializedStubTree> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    3.$$$reportNull$$$0(0);
                }
                THashMap<Integer, SerializedStubTree> result2 = new THashMap<Integer, SerializedStubTree>(){
                    StubUpdatingIndexKeys myKeySet;

                    @NotNull
                    public Set<Integer> keySet() {
                        if (this.myKeySet == null) {
                            this.myKeySet = new StubUpdatingIndexKeys(super.keySet());
                        }
                        StubUpdatingIndexKeys stubUpdatingIndexKeys = this.myKeySet;
                        if (stubUpdatingIndexKeys == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return stubUpdatingIndexKeys;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$3$1", "keySet"));
                    }
                };
                ApplicationManager.getApplication().runReadAction(() -> 3.lambda$map$0(inputData, (Map)result2));
                THashMap<Integer, SerializedStubTree> tHashMap = result2;
                if (tHashMap == null) {
                    3.$$$reportNull$$$0(1);
                }
                return tHashMap;
            }

            private static /* synthetic */ void lambda$map$0(@NotNull FileContent inputData, Map result2) {
                PrebuiltStubsProvider prebuiltStubsProvider;
                if (inputData == null) {
                    3.$$$reportNull$$$0(2);
                }
                Stub rootStub = null;
                if (Registry.is((String)"use.prebuilt.indices") && (prebuiltStubsProvider = (PrebuiltStubsProvider)PrebuiltStubsProviders.INSTANCE.forFileType(inputData.getFileType())) != null) {
                    rootStub = prebuiltStubsProvider.findStub(inputData);
                    if (PrebuiltIndexProviderBase.DEBUG_PREBUILT_INDICES) {
                        Stub stub = StubTreeBuilder.buildStubTree(inputData);
                        if (rootStub != null && stub != null) {
                            StubUpdatingIndex.check(rootStub, stub);
                        }
                    }
                }
                if (rootStub == null) {
                    rootStub = StubTreeBuilder.buildStubTree(inputData);
                }
                if (rootStub == null) {
                    return;
                }
                VirtualFile file2 = inputData.getFile();
                int contentLength = file2.getFileType().isBinary() ? -1 : ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex().getTextLength();
                StubUpdatingIndex.rememberIndexingStamp(file2, contentLength);
                BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                SerializationManagerEx.getInstanceEx().serialize(rootStub, (OutputStream)bytes);
                if (DebugAssertions.DEBUG) {
                    try {
                        Stub deserialized = SerializationManagerEx.getInstanceEx().deserialize((InputStream)new ByteArrayInputStream(bytes.getInternalBuffer(), 0, bytes.size()));
                        StubUpdatingIndex.check(deserialized, rootStub);
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (Throwable t) {
                        LOG.error("Error indexing:" + file2, t);
                    }
                }
                int key = SingleEntryFileBasedIndexExtension.getFileKey(file2);
                SerializedStubTree serializedStubTree = new SerializedStubTree(bytes.getInternalBuffer(), bytes.size(), rootStub, file2.getLength(), contentLength);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Indexing " + file2 + "; lengths=" + serializedStubTree.dumpLengths());
                }
                result2.put(key, serializedStubTree);
                try {
                    ((StubUpdatingIndexKeys)result2.keySet()).myStubIndicesValueMap = StubUpdatingIndex.calcStubIndicesValueMap(serializedStubTree);
                }
                catch (StorageException ex) {
                    throw new RuntimeException(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$map$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        return dataIndexer;
    }

    private static void check(@NotNull Stub stub, @NotNull Stub stub2) {
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i = 0; i < len; ++i) {
            StubUpdatingIndex.check((Stub)stubs.get(i), (Stub)stubs2.get(i));
        }
    }

    private static void rememberIndexingStamp(@NotNull VirtualFile file2, long contentLength) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentLength);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long size = DataInputOutputUtil.readLONG((DataInput)stream);
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, size);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        KeyDescriptor<Integer> keyDescriptor = DATA_DESCRIPTOR;
        if (keyDescriptor == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        DataExternalizer<SerializedStubTree> dataExternalizer = KEY_EXTERNALIZER;
        if (dataExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
        if (extension == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        if (storage2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(12);
        }
        if (storage2 instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage2;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        MyIndex myIndex = new MyIndex(extension, storage2);
        if (myIndex == null) {
            StubUpdatingIndex.$$$reportNull$$$0(13);
        }
        return myIndex;
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (indexKeys == null) {
            StubUpdatingIndex.$$$reportNull$$$0(14);
        }
        if (oldStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(15);
        }
        if (newStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(16);
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key);
            Map<Object, StubIdList> newMap = newStubTree.get(key);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (oldStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(17);
        }
        if (newStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(18);
        }
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        HashSet<StubIndexKey> hashSet = allIndices;
        if (hashSet == null) {
            StubUpdatingIndex.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    @NotNull
    private static Map<StubIndexKey, Map<Object, StubIdList>> calcStubIndicesValueMap(@NotNull SerializedStubTree stub) throws StorageException {
        Map<StubIndexKey, Map<Object, StubIdList>> map;
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(20);
        }
        try {
            Map<StubIndexKey, Map<Object, StubIdList>> map2;
            ObjectStubBase root = (ObjectStubBase)stub.getStub(true);
            ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree(root, false);
            Map<StubIndexKey, Map<Object, StubIdList>> stubIndicesValueMap = map2 = objectStubTree.indexStubTree();
            for (StubIndexKey key : map2.keySet()) {
                Map<Object, StubIdList> value = map2.get(key);
                for (Object k : value.keySet()) {
                    int[] ints = (int[])value.get(k);
                    StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                    value.put(k, stubList);
                }
            }
            map = stubIndicesValueMap;
        }
        catch (SerializerNotFoundException e) {
            throw new StorageException((Throwable)e);
        }
        if (map == null) {
            StubUpdatingIndex.$$$reportNull$$$0(21);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKeys";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStubTree";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStubTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexImplementation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndices";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStubIndicesValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 21: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rememberIndexingStamp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateStubIndices";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndices";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcStubIndicesValueMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private StubIndexImpl myStubIndex;
        private final StubVersionMap myStubVersionMap;
        private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.versionStamp", 2, true);

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
            if (extension == null) {
                MyIndex.$$$reportNull$$$0(0);
            }
            if (storage2 == null) {
                MyIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage2);
            this.myStubVersionMap = new StubVersionMap();
            MyIndex.checkNameStorage();
        }

        @NotNull
        protected UpdateData<Integer, SerializedStubTree> createUpdateData(@NotNull Map<Integer, SerializedStubTree> data, @NotNull ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> oldKeys, @NotNull ThrowableRunnable<IOException> forwardIndexUpdate) {
            if (data == null) {
                MyIndex.$$$reportNull$$$0(2);
            }
            if (oldKeys == null) {
                MyIndex.$$$reportNull$$$0(3);
            }
            if (forwardIndexUpdate == null) {
                MyIndex.$$$reportNull$$$0(4);
            }
            StubUpdatingData stubUpdatingData = new StubUpdatingData(data, oldKeys, forwardIndexUpdate);
            if (stubUpdatingData == null) {
                MyIndex.$$$reportNull$$$0(5);
            }
            return stubUpdatingData;
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateWithMap(int inputId, @NotNull UpdateData<Integer, SerializedStubTree> updateData) throws StorageException {
            if (updateData == null) {
                MyIndex.$$$reportNull$$$0(6);
            }
            MyIndex.checkNameStorage();
            StubUpdatingData stubUpdatingData = (StubUpdatingData)updateData;
            Map<StubIndexKey, Map<Object, StubIdList>> newStubIndicesValueMap = stubUpdatingData.getNewStubIndicesValueMap();
            try {
                this.getWriteLock().lock();
                super.updateWithMap(inputId, updateData);
                Map<StubIndexKey, Map<Object, StubIdList>> previousStubIndicesValueMap = stubUpdatingData.getOldStubIndicesValueMap();
                StubUpdatingIndex.updateStubIndices(StubUpdatingIndex.getAffectedIndices(previousStubIndicesValueMap, newStubIndicesValueMap), inputId, previousStubIndicesValueMap, newStubIndicesValueMap);
            }
            finally {
                this.getWriteLock().unlock();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            StubIndexImpl stubIndexImpl = index;
            if (stubIndexImpl == null) {
                MyIndex.$$$reportNull$$$0(7);
            }
            return stubIndexImpl;
        }

        private static void checkNameStorage() throws StorageException {
            SerializationManagerEx serializationManager = SerializationManagerEx.getInstanceEx();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys) {
            if (keys == null) {
                MyIndex.$$$reportNull$$$0(8);
            }
            super.removeTransientDataForKeys(inputId, keys);
            if (keys instanceof StubUpdatingIndexKeys) {
                Map stubIndicesValueMap = ((StubUpdatingIndexKeys)keys).myStubIndicesValueMap;
                StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
                for (StubIndexKey key : stubIndicesValueMap.keySet()) {
                    stubIndex.removeTransientDataForFile(key, inputId, ((Map)stubIndicesValueMap.get(key)).keySet());
                }
            }
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            this.myStubVersionMap.clear();
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(9);
            }
            super.setIndexedStateForFile(fileId, file2);
            try (com.intellij.util.io.DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStubVersionMap.getIndexingTimestampDiffForFileType(file2.getFileType()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            boolean indexedStateForFile;
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(10);
            }
            if (!(indexedStateForFile = super.isIndexedStateForFile(fileId, file2))) {
                return false;
            }
            try {
                int diff;
                DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);
                int n = diff = stream != null ? DataInputOutputUtil.readINT((DataInput)stream) : 0;
                if (diff == 0) {
                    return false;
                }
                FileType fileType = this.myStubVersionMap.getFileTypeByIndexingTimestampDiff(diff);
                return fileType != null && this.myStubVersionMap.getStamp(file2.getFileType()) == this.myStubVersionMap.getStamp(fileType);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldKeys";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forwardIndexUpdate";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateData";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpdateData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpdateData";
                    break;
                }
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWithMap";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForKeys";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setIndexedStateForFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isIndexedStateForFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class StubUpdatingData
        extends UpdateData<Integer, SerializedStubTree> {
            private Collection<Integer> oldStubIndexKeys;

            StubUpdatingData(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> iterator, @Nullable ThrowableRunnable<IOException> forwardIndexUpdate) {
                if (newData == null) {
                    StubUpdatingData.$$$reportNull$$$0(0);
                }
                if (iterator == null) {
                    StubUpdatingData.$$$reportNull$$$0(1);
                }
                super(newData, iterator, INDEX_ID, forwardIndexUpdate);
            }

            @NotNull
            protected ThrowableComputable<InputDataDiffBuilder<Integer, SerializedStubTree>, IOException> getCurrentDataEvaluator() {
                ThrowableComputable throwableComputable = () -> {
                    InputDataDiffBuilder diffBuilder = (InputDataDiffBuilder)super.getCurrentDataEvaluator().compute();
                    if (diffBuilder instanceof CollectionInputDataDiffBuilder) {
                        this.oldStubIndexKeys = ((CollectionInputDataDiffBuilder)diffBuilder).getSeq();
                    } else if (diffBuilder instanceof MapInputDataDiffBuilder) {
                        this.oldStubIndexKeys = ((MapInputDataDiffBuilder)diffBuilder).getMap().keySet();
                    }
                    return diffBuilder;
                };
                if (throwableComputable == null) {
                    StubUpdatingData.$$$reportNull$$$0(2);
                }
                return throwableComputable;
            }

            @NotNull
            Map<StubIndexKey, Map<Object, StubIdList>> getOldStubIndicesValueMap() {
                Map<StubIndexKey, Map<Object, StubIdList>> map = StubUpdatingData.getStubIndicesValuesMap(this.oldStubIndexKeys);
                if (map == null) {
                    StubUpdatingData.$$$reportNull$$$0(3);
                }
                return map;
            }

            @NotNull
            Map<StubIndexKey, Map<Object, StubIdList>> getNewStubIndicesValueMap() {
                Map<StubIndexKey, Map<Object, StubIdList>> map = StubUpdatingData.getStubIndicesValuesMap(this.getNewData().keySet());
                if (map == null) {
                    StubUpdatingData.$$$reportNull$$$0(4);
                }
                return map;
            }

            @NotNull
            private static Map<StubIndexKey, Map<Object, StubIdList>> getStubIndicesValuesMap(@NotNull Collection<Integer> keys) {
                if (keys == null) {
                    StubUpdatingData.$$$reportNull$$$0(5);
                }
                if (keys instanceof StubUpdatingIndexKeys) {
                    Map map = ((StubUpdatingIndexKeys)keys).myStubIndicesValueMap;
                    if (map == null) {
                        StubUpdatingData.$$$reportNull$$$0(6);
                    }
                    return map;
                }
                Map<StubIndexKey, Map<Object, StubIdList>> map = Collections.emptyMap();
                if (map == null) {
                    StubUpdatingData.$$$reportNull$$$0(7);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "iterator";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex$StubUpdatingData";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keys";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex$StubUpdatingData";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentDataEvaluator";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOldStubIndicesValueMap";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNewStubIndicesValueMap";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getStubIndicesValuesMap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getStubIndicesValuesMap";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    static class StubUpdatingIndexKeys
    extends AbstractSet<Integer> {
        @NotNull
        private final Set<Integer> myBackingMap;
        @NotNull
        private Map<StubIndexKey, Map<Object, StubIdList>> myStubIndicesValueMap;

        StubUpdatingIndexKeys(@NotNull Set<Integer> backingMap) {
            if (backingMap == null) {
                StubUpdatingIndexKeys.$$$reportNull$$$0(0);
            }
            this.myStubIndicesValueMap = Collections.emptyMap();
            this.myBackingMap = backingMap;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            Iterator<Integer> iterator = this.myBackingMap.iterator();
            if (iterator == null) {
                StubUpdatingIndexKeys.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @Override
        public int size() {
            return this.myBackingMap.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backingMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$StubUpdatingIndexKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$StubUpdatingIndexKeys";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

