/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerStability;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerUtils {
    @NonNls
    public static final String COMPOSER_PHAR_NAME = "composer.phar";
    @NonNls
    public static final String COMPOSER_LINUX_NAME = "composer";
    @NonNls
    public static final String DOWNLOAD_URL = "http://getcomposer.org/composer.phar";
    @NonNls
    public static final String CONFIG_DEFAULT_FILENAME = "composer.json";
    @NonNls
    public static final String LOCK_FILE_NAME = "composer.lock";
    @NonNls
    public static final String COMPOSER_GROUP_DISPLAY_ID = PhpBundle.message("framework.composer", new Object[0]);
    @NonNls
    public static final String VENDOR_DIR_DEFAULT_NAME = "vendor";
    @NonNls
    private static final String[] STABILITY_VERSIONS = new String[]{"dev", "alpha", "beta", "RC", "stable"};
    private static final Logger LOG = Logger.getInstance(ComposerUtils.class);
    private static final Comparator<VirtualFile> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int size1 = StringUtil.split((String)o1.getPath(), (String)"/").size();
        int size2 = StringUtil.split((String)o2.getPath(), (String)"/").size();
        return size1 - size2;
    };

    private ComposerUtils() {
    }

    public static ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createPharBrowserListener(final TextFieldWithBrowseButton field, final @Nullable Component component) {
        FileChooserDescriptor singleFileDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        return new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PhpBundle.message("framework.composer.path.dialog.path.to.composer", new Object[0]), PhpBundle.message("framework.composer.path.dialog.specify.composer.phar", new Object[0]), (ComponentWithBrowseButton)field, null, singleFileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = field.getText();
                if (StringUtil.isEmpty((String)text) && (file = ComposerUtils.findFileInProject(component, ComposerUtils.COMPOSER_PHAR_NAME)) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        };
    }

    @Nullable
    public static VirtualFile findFileInProject(@Nullable Component component, String fileName) {
        Project project;
        if (component == null) {
            project = null;
        } else {
            DataContext context = DataManager.getInstance().getDataContext(component);
            project = (Project)CommonDataKeys.PROJECT.getData(context);
        }
        return ComposerUtils.findFileInProject(project, fileName);
    }

    public static VirtualFile findFileInProject(@Nullable Project project, String fileName) {
        if (project != null) {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
            Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
            if (files.isEmpty()) {
                return null;
            }
            return Collections.min(files, PATH_LENGTH_COMPARATOR);
        }
        return null;
    }

    @Nullable
    public static VirtualFile downloadPhar(@Nullable Project project, JComponent component, @Nullable String toDir) {
        return PhpConfigurationUtil.downloadFile(project, component, toDir, DOWNLOAD_URL, COMPOSER_PHAR_NAME);
    }

    static void initConfig(VirtualFile parentDirForConfig, Project project, Object requestor) {
        VirtualFile config;
        try {
            config = parentDirForConfig.createChildData(requestor, CONFIG_DEFAULT_FILENAME);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(config);
        if (psiFile == null) {
            LOG.warn("Failed to find psi file for " + config.getUrl());
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)psiFile)) {
            return;
        }
        Template template = ComposerUtils.createConfigTemplate(project);
        VirtualFile vFile = psiFile.getVirtualFile();
        LOG.assertTrue(vFile != null);
        PsiNavigationSupport.getInstance().createNavigatable(project, vFile, 0).navigate(true);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(vFile);
        LOG.assertTrue(fileEditor != null);
        LOG.assertTrue(fileEditor instanceof TextEditor);
        Editor editor = ((TextEditor)fileEditor).getEditor();
        ComposerDataService.getInstance(project).setConfigPathAndLibraryUpdateStatus(vFile.getPath(), true);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action = () -> {
                editor.getCaretModel().moveToOffset(0);
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, false, null, null);
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, PhpBundle.message("framework.composer.comment.old.config.command.title", new Object[0]), null);
    }

    private static Template createConfigTemplate(Project project) {
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addTextSegment("{\n   \"name\": \"");
        template.addVariable("vendor_name", (Expression)new ConstantNode("vendor_name"), true);
        template.addTextSegment("/");
        template.addVariable("package_name", (Expression)new ConstantNode("package_name"), true);
        template.addTextSegment("\",\n");
        template.addTextSegment("    \"description\": \"");
        template.addVariable("description_text", (Expression)new ConstantNode("description_text"), true);
        template.addTextSegment("\",\n");
        template.addTextSegment("    \"minimum-stability\": \"");
        template.addVariable("minimum-stability", (Expression)new PredefinedValuesExpression(STABILITY_VERSIONS), (Expression)new ConstantNode(STABILITY_VERSIONS[STABILITY_VERSIONS.length - 1]), true);
        template.addTextSegment("\",\n");
        template.addTextSegment("    \"license\": \"");
        template.addVariable("license_text", (Expression)new ConstantNode("proprietary"), true);
        template.addTextSegment("\",\n");
        template.addTextSegment("    \"authors\": [\n        {");
        template.addTextSegment("            \"name\": \"");
        template.addVariable("author's name", (Expression)new ConstantNode("author's name"), true);
        template.addTextSegment("\",\n");
        template.addTextSegment("            \"email\": \"");
        template.addVariable("email@example.com", (Expression)new ConstantNode("email@example.com"), true);
        template.addTextSegment("\"\n        }\n    ]\n}");
        template.addEndVariable();
        template.setToReformat(true);
        return template;
    }

    @NonNls
    public static List<String> getInstallationCommand(ComposerRunningData data, @NotNull String packageName, String version) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(0);
        }
        String installationTarget = StringUtil.isEmpty((String)version) ? packageName : packageName + ":" + version;
        return ComposerUtils.getSimpleBasicCommand(data, "require", installationTarget);
    }

    @NonNls
    public static List<String> getSimpleBasicCommand(ComposerRunningData data, String ... command) {
        if (command == null) {
            ComposerUtils.$$$reportNull$$$0(1);
        }
        List<String> commandBeginning = data.getComposerCommandBeginning();
        ArrayList<String> basicPart = new ArrayList<String>(commandBeginning.size() + command.length);
        basicPart.addAll(commandBeginning);
        Collections.addAll(basicPart, command);
        return basicPart;
    }

    @NonNls
    public static List<String> getCreateProjectCommand(@NotNull ComposerPackage aPackage, String version, @NotNull ComposerRunningData runningData, String newProjectPath) {
        ComposerStability stability;
        if (aPackage == null) {
            ComposerUtils.$$$reportNull$$$0(2);
        }
        if (runningData == null) {
            ComposerUtils.$$$reportNull$$$0(3);
        }
        ArrayList<String> commands = new ArrayList<String>(runningData.getComposerCommandBeginning());
        commands.add("create-project");
        commands.add(aPackage.getName());
        commands.add(newProjectPath);
        if (version != null) {
            commands.add(version);
        }
        if (version != null) {
            stability = ComposerStability.getStability(version);
        } else {
            ComposerStability maxStability = null;
            for (String currentVersion : aPackage.getVersions()) {
                ComposerStability currentStability = ComposerStability.getStability(currentVersion);
                if (maxStability == null || currentStability.isMoreStableThan(maxStability)) {
                    maxStability = currentStability;
                }
                if (ComposerStability.getMostStable() != maxStability) continue;
                break;
            }
            stability = maxStability;
        }
        if (stability != null && stability.needsToBeSpecified()) {
            commands.add("-s" + stability.getId());
        }
        return commands;
    }

    @NonNls
    public static List<String> getUpdatePackageCommand(ComposerRunningData data, @NotNull String packageName) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(4);
        }
        return ComposerUtils.getSimpleBasicCommand(data, "update", packageName, "--no-progress");
    }

    @NonNls
    public static List<String> getRemovePackageCommand(ComposerRunningData data, @NotNull String packageName) {
        if (packageName == null) {
            ComposerUtils.$$$reportNull$$$0(5);
        }
        return ComposerUtils.getSimpleBasicCommand(data, "remove", packageName, "--no-progress");
    }

    @NotNull
    public static JBPopup createOutputPopup(String output, @NotNull String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Project project) {
        if (message == null) {
            ComposerUtils.$$$reportNull$$$0(6);
        }
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(message);
        mainPanel.add((Component)label, "North");
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBackground((Color)JBColor.WHITE);
        textArea.setText(output);
        JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
        mainPanel.add((Component)scrollPane, "Center");
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPanel, (JComponent)mainPanel).setTitle(title).setMovable(true).setResizable(true).setDimensionServiceKey(project, "ComposerAddDependencyOutputPopupDimensionServiceKey", true).setMinSize(new Dimension(JBUI.scale((int)600), JBUI.scale((int)300))).setCancelButton((IconButton)new MinimizeButton(PhpBundle.message("framework.composer.add.dependency.hide.tooltip", new Object[0]))).createPopup();
        if (jBPopup == null) {
            ComposerUtils.$$$reportNull$$$0(7);
        }
        return jBPopup;
    }

    @Nullable
    public static VirtualFile findVendorDir(@Nullable VirtualFile composerJson, @Nullable String relativePath) {
        if (composerJson == null || relativePath == null) {
            return null;
        }
        VirtualFile parent = composerJson.getParent();
        if (parent == null) {
            return null;
        }
        File file = new File(parent.getPath());
        File target = new File(file, relativePath);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target);
    }

    public static void refreshVendorDirectory(@Nullable VirtualFile vendorDirectory, boolean asynchronous, @Nullable Runnable postRefresh) {
        if (vendorDirectory == null) {
            return;
        }
        vendorDirectory.refresh(asynchronous, true, postRefresh);
    }

    public static void refreshVendorDir(@NotNull VirtualFile configFile) {
        Pair<String, String> dirs;
        if (configFile == null) {
            ComposerUtils.$$$reportNull$$$0(8);
        }
        if ((dirs = ComposerConfigUtils.getVendorAndBinDirs(configFile)) == null) {
            return;
        }
        VirtualFile vendorDir = ComposerUtils.findVendorDir(configFile, (String)dirs.getFirst());
        ComposerUtils.refreshVendorDirectory(vendorDir, true, null);
    }

    @Contract(value="!null,_->!null")
    public static String getPresentablePath(VirtualFile composerJson, @NotNull Project project) {
        if (project == null) {
            ComposerUtils.$$$reportNull$$$0(9);
        }
        if (composerJson == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        if (!DumbService.isDumb((Project)project)) {
            try {
                ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
                VirtualFile contentRoot = fileIndex.getContentRootForFile(composerJson);
                if (contentRoot != null) {
                    return ComposerUtils.getPresentablePath(composerJson, contentRoot, roots);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        for (VirtualFile root : roots) {
            if (!composerJson.getUrl().startsWith(root.getUrl())) continue;
            return ComposerUtils.getPresentablePath(composerJson, root, roots);
        }
        return composerJson.getCanonicalPath();
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile composerJson, @NotNull VirtualFile contentRoot, @NotNull VirtualFile[] roots) {
        if (composerJson == null) {
            ComposerUtils.$$$reportNull$$$0(10);
        }
        if (contentRoot == null) {
            ComposerUtils.$$$reportNull$$$0(11);
        }
        if (roots == null) {
            ComposerUtils.$$$reportNull$$$0(12);
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)composerJson, (VirtualFile)contentRoot, (char)'/');
        StringBuilder pathPresentationBuilder = new StringBuilder();
        pathPresentationBuilder.append(".").append("/");
        if (roots.length > 1) {
            pathPresentationBuilder.append(contentRoot.getName()).append("/");
        }
        pathPresentationBuilder.append(relativePath);
        String string = pathPresentationBuilder.toString();
        if (string == null) {
            ComposerUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputPopup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstallationCommand";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleBasicCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCreateProjectCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatePackageCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRemovePackageCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createOutputPopup";
                break;
            }
            case 7: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshVendorDir";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PredefinedValuesExpression
    extends Expression {
        private final String[] myValues;

        private PredefinedValuesExpression(String[] values) {
            this.myValues = values;
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            return this.calculateQuickResult(context);
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return this.myValues.length == 1 ? new TextResult(this.myValues[0]) : null;
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            LookupElement[] result = new LookupElement[this.myValues.length];
            for (int i = 0; i < this.myValues.length; ++i) {
                result[i] = LookupElementBuilder.create((String)this.myValues[i]);
            }
            return result;
        }
    }
}

