/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayPostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(1);
        }
        if (source.isValid() && source.getContainingFile().getFileType() == PhpFileType.INSTANCE) {
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            if (phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT) {
                new ArrayVisitor(source, source.getTextRange(), settings).processTree();
            }
        }
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(2);
        }
        if (rangeToReformat == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (source.isValid() && source.getFileType() == PhpFileType.INSTANCE) {
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            if (phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT) {
                TextRange textRange = new ArrayVisitor((PsiElement)source, rangeToReformat, settings).processTree();
                if (textRange == null) {
                    PhpArrayPostFormatProcessor.$$$reportNull$$$0(5);
                }
                return textRange;
            }
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PhpArrayPostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpArrayPostFormatProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpArrayPostFormatProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArrayVisitor
    extends PsiRecursiveElementVisitor {
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final PsiElement myElement;
        @Nullable
        private Document myDocument;
        private int myDelta;
        private Project myProject;
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

        ArrayVisitor(@NotNull PsiElement element, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
            if (element == null) {
                ArrayVisitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ArrayVisitor.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                ArrayVisitor.$$$reportNull$$$0(2);
            }
            this.myRange = range;
            this.myElement = element;
            if (this.myElement.isValid()) {
                this.myProject = this.myElement.getProject();
                PsiFile file = this.myElement.getContainingFile();
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
            }
            this.myIndentOptions = settings.getCommonSettings((Language)PhpLanguage.INSTANCE).getIndentOptions();
        }

        public TextRange processTree() {
            if (this.myDocument != null) {
                this.myElement.accept((PsiElementVisitor)this);
                if (this.myDelta > 0) {
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                    documentManager.commitDocument(this.myDocument);
                }
            }
            return this.myRange.grown(this.myDelta);
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (this.myRange.contains(element.getTextRange()) && PhpPsiUtil.isOfType(element, PhpElementTypes.HASH_ARRAY_ELEMENT, PhpElementTypes.ARRAY_VALUE)) {
                PsiElement parent = element.getParent();
                if (this.myDocument != null && parent != null && PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
                    IElementType nextType;
                    PsiElement next = element.getNextSibling();
                    PsiWhiteSpace whiteSpaceAfter = next instanceof PsiWhiteSpace ? (PsiWhiteSpace)next : null;
                    PsiElement psiElement = next = whiteSpaceAfter != null ? next.getNextSibling() : null;
                    if (next != null && ((nextType = next.getNode().getElementType()) == PhpTokenTypes.chRPAREN || nextType == PhpTokenTypes.chRBRACKET) && whiteSpaceAfter.textContains('\n')) {
                        String toInsert = ",";
                        if (ArrayVisitor.endsWithHeredoc(element)) {
                            toInsert = "\n" + this.getIndentString() + ",";
                        }
                        this.myDocument.insertString(element.getTextRange().getEndOffset() + this.myDelta, (CharSequence)toInsert);
                        this.myDelta += toInsert.length();
                    }
                }
            }
        }

        private static boolean endsWithHeredoc(@NotNull PsiElement element) {
            PsiElement lastChild;
            if (element == null) {
                ArrayVisitor.$$$reportNull$$$0(3);
            }
            return (lastChild = element.getLastChild()) != null && lastChild.getNode().getElementType() == PhpElementTypes.HEREDOC;
        }

        private String getIndentString() {
            return new IndentInfo(0, this.myIndentOptions.INDENT_SIZE, 0).generateNewWhiteSpace(this.myIndentOptions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpArrayPostFormatProcessor$ArrayVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endsWithHeredoc";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

