/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsrComposerConfig
implements ComposerSettingSyncConfigClient<PhpPsrStructure> {
    private static final List<String> TAGS = ContainerUtil.newArrayList((Object[])new String[]{"autoload", "autoload-dev"});
    private static final String PSR0 = "psr-0";
    private static final String PSR4 = "psr-4";

    @Override
    public PhpPsrStructure parse(@NotNull Map<String, JsonElement> elements) {
        if (elements == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(0);
        }
        if (elements.isEmpty()) {
            return null;
        }
        PhpPsrStructure structure = new PhpPsrStructure();
        for (Map.Entry<String, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (element == null || !element.isJsonObject()) continue;
            JsonObject object = element.getAsJsonObject();
            String name = entry.getKey();
            boolean isTest = StringUtil.isNotEmpty((String)name) && StringUtil.endsWith((CharSequence)name, (CharSequence)"-dev");
            PhpPsrComposerConfig.parsePsrRoot(structure, isTest, object.get(PSR4), true);
            PhpPsrComposerConfig.parsePsrRoot(structure, isTest, object.get(PSR0), false);
        }
        return structure;
    }

    private static void parsePsrRoot(@NotNull PhpPsrStructure structure, boolean isTest, JsonElement psr, boolean withPrefix) {
        if (structure == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(1);
        }
        if (psr == null || !psr.isJsonObject()) {
            return;
        }
        for (Map.Entry entry : psr.getAsJsonObject().entrySet()) {
            String packagePrefix;
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) continue;
            String string = packagePrefix = withPrefix ? (String)entry.getKey() : "";
            if (value.isJsonPrimitive()) {
                structure.addPsrRoot(value.getAsJsonPrimitive().getAsString(), packagePrefix, isTest);
                continue;
            }
            if (!value.isJsonArray()) continue;
            for (JsonElement element : value.getAsJsonArray()) {
                if (!element.isJsonPrimitive()) continue;
                structure.addPsrRoot(element.getAsJsonPrimitive().getAsString(), packagePrefix, isTest);
            }
        }
    }

    @Override
    public boolean updateSetting(@NotNull Project project, @Nullable PhpPsrStructure psrStructure) {
        ComposerDataService service;
        Module module;
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(2);
        }
        if ((module = PhpPsrComposerConfig.getModule(project, (service = ComposerDataService.getInstance(project)).getConfigPath())) == null) {
            return false;
        }
        if (psrStructure == null) {
            return false;
        }
        Map<String, PhpSourceRootTemplate> roots = psrStructure.getPsrRoots(service.getConfigPath());
        if (roots.isEmpty() || this.equals(module, roots)) {
            return false;
        }
        PhpPsrNamespaceRootDetector.addSourceRoots(module, roots.values());
        return true;
    }

    @Override
    @NotNull
    public String getSettingTitle() {
        String string = PhpBundle.message(PlatformUtils.isPhpStorm() ? "actions.detect.namespace.roots.from.composer.title" : "actions.detect.namespace.roots.from.composer.idea.title", new Object[0]);
        if (string == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings showSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.DIRECTORIES;
        if (settings == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(4);
        }
        return settings;
    }

    @Override
    public boolean isDefaultSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        Module composerModule;
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(5);
        }
        if ((composerModule = PhpPsrComposerConfig.getModule(project, composerJsonPath)) != null) {
            if (ModuleRootManager.getInstance((Module)composerModule).getSourceRoots(true).length != 0) {
                return false;
            }
        } else {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (ModuleRootManager.getInstance((Module)module).getSourceRoots(true).length == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static Module getModule(@NotNull Project project, @Nullable String composerJsonPath) {
        VirtualFile configFile;
        if (project == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)composerJsonPath) && (configFile = LocalFileSystem.getInstance().findFileByPath(composerJsonPath)) != null) {
            return ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(configFile);
        }
        return null;
    }

    public boolean equals(@NotNull Module module, @NotNull Map<String, PhpSourceRootTemplate> detectedRoots) {
        ContentEntry[] contentEntries;
        if (module == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(7);
        }
        if (detectedRoots == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(8);
        }
        int count = 0;
        for (ContentEntry entry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SourceFolder[] folders;
            for (SourceFolder folder : folders = entry.getSourceFolders()) {
                if (!detectedRoots.containsKey(folder.getUrl())) {
                    return false;
                }
                ++count;
                PhpSourceRootTemplate root = detectedRoots.get(folder.getUrl());
                if (PhpLangUtil.equalsNamespaceNames(folder.getPackagePrefix(), root.getPrefix())) continue;
                return false;
            }
        }
        return count >= detectedRoots.size();
    }

    @Override
    @NotNull
    public List<String> getPath() {
        List<String> list = TAGS;
        if (list == null) {
            PhpPsrComposerConfig.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpPsrComposerConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpPsrComposerConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parsePsrRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateSetting";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpPsrStructure {
        private final List<PhpSourceRootTemplate> myPsrRoots = ContainerUtil.newSmartList();

        @NotNull
        public Map<String, PhpSourceRootTemplate> getPsrRoots(@NotNull String configPath) {
            if (configPath == null) {
                PhpPsrStructure.$$$reportNull$$$0(0);
            }
            if (this.myPsrRoots.isEmpty()) {
                Map<String, PhpSourceRootTemplate> map = Collections.emptyMap();
                if (map == null) {
                    PhpPsrStructure.$$$reportNull$$$0(1);
                }
                return map;
            }
            HashMap roots = ContainerUtil.newHashMap();
            String rootDir = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)configPath));
            for (PhpSourceRootTemplate psrRoot : this.myPsrRoots) {
                String sourcePath = psrRoot.getSourcePath();
                String absolute = FileUtil.isAbsolutePlatformIndependent((String)sourcePath) ? sourcePath : rootDir + "/" + sourcePath;
                String url = VfsUtilCore.pathToUrl((String)absolute);
                if (roots.containsKey(url) && (psrRoot.isTest() || !((PhpSourceRootTemplate)roots.get(url)).isTest())) continue;
                roots.put(url, PhpSourceRootTemplate.psr4(absolute, psrRoot.getPrefix(), psrRoot.isTest()));
            }
            HashMap hashMap = roots;
            if (hashMap == null) {
                PhpPsrStructure.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        public void addPsrRoot(@NotNull String root, @NotNull String prefix, boolean isTest) {
            if (root == null) {
                PhpPsrStructure.$$$reportNull$$$0(3);
            }
            if (prefix == null) {
                PhpPsrStructure.$$$reportNull$$$0(4);
            }
            String path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (String)"/");
            this.myPsrRoots.add(PhpSourceRootTemplate.psr4(path, prefix, isTest));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/roots/PhpPsrComposerConfig$PhpPsrStructure";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/roots/PhpPsrComposerConfig$PhpPsrStructure";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsrRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsrRoots";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addPsrRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

