/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.webApp;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugConfigInstructionsPanel;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.webApp.PhpWebAppRunConfiguration;
import com.jetbrains.php.ui.PhpServerComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class PhpWebAppRunConfigurationEditor
extends SettingsEditor<PhpWebAppRunConfiguration> {
    private JPanel myMainPanel;
    private JPanel myBrowserSelectorPanel;
    private JTextField myStartUrlTextField;
    private PhpServerComboBox myServerComboBox;
    private HoverHyperlinkLabel myResultUrl;
    private HideableTitledPanel myPreConfigHideablePanel;
    private final BrowserSelector myBrowserSelector;
    final HyperlinkListener myHyperlinkListener;
    private final Project myProject;

    public PhpWebAppRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this, (Disposable)this.myServerComboBox);
        PhpDebugConfigInstructionsPanel instructions = PhpDebugConfigInstructionsPanel.createWebPageDebugInstructions((Producer<PhpServer>)((Producer)() -> this.myServerComboBox.getSelectedServer()));
        instructions.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insetsLeft((int)10)));
        this.myPreConfigHideablePanel.setContentComponent((JComponent)instructions);
        this.myPreConfigHideablePanel.setOn(PhpProjectDebugConfiguration.getInstance(project).getState().isShowPreConfigInWebPage());
        this.myBrowserSelector = new BrowserSelector();
        this.myBrowserSelectorPanel.add("Center", this.myBrowserSelector.getMainComponent());
        this.myServerComboBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpWebAppRunConfigurationEditor.this.updateResultUrl();
            }
        });
        this.myStartUrlTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpWebAppRunConfigurationEditor.this.updateResultUrl();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor$2", "textChanged"));
            }
        });
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserLauncher.getInstance().browse(PhpWebAppRunConfigurationEditor.this.myResultUrl.getOriginalText(), PhpWebAppRunConfigurationEditor.this.myBrowserSelector.getSelected(), PhpWebAppRunConfigurationEditor.this.myProject);
                }
            }
        };
        this.myResultUrl.addHyperlinkListener(this.myHyperlinkListener);
    }

    protected void resetEditorFrom(@NotNull PhpWebAppRunConfiguration configuration) {
        if (configuration == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)configuration.getSettings();
        this.myServerComboBox.reset(this.myProject, settings.getServerName());
        this.myBrowserSelector.setSelected(settings.getBrowser());
        this.myStartUrlTextField.setText(settings.getStartUrl());
    }

    protected void applyEditorTo(@NotNull PhpWebAppRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        PhpWebAppRunConfiguration.Settings settings = (PhpWebAppRunConfiguration.Settings)configuration.getSettings();
        settings.setServerName(this.myServerComboBox.getSelectedServerName());
        settings.setStartUrl(this.myStartUrlTextField.getText().trim());
        settings.setBrowser(this.myBrowserSelector.getSelected());
        PhpProjectDebugConfiguration.getInstance(this.myProject).getState().setShowPreConfigInWebPage(this.myPreConfigHideablePanel.isExpanded());
    }

    private void updateResultUrl() {
        String startUrl = this.myStartUrlTextField.getText();
        PhpServer selectedServer = this.myServerComboBox.getSelectedServer();
        if (selectedServer != null) {
            try {
                selectedServer.checkConfiguration(this.myProject);
                String host = selectedServer.getHost();
                this.myResultUrl.setVisible(true);
                this.myResultUrl.setText(PhpDebugUtil.createUrl(host, selectedServer.getPort(), "http", startUrl));
                return;
            }
            catch (RuntimeConfigurationException runtimeConfigurationException) {
                // empty catch block
            }
        }
        this.myResultUrl.setVisible(false);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpWebAppRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    protected void disposeEditor() {
        this.myResultUrl.removeHyperlinkListener(this.myHyperlinkListener);
    }

    private void createUIComponents() {
        this.myResultUrl = new HoverHyperlinkLabel("");
        this.myPreConfigHideablePanel = new HideableTitledPanel(PhpBundle.message("PhpDebugConfigurable.web.page.pre.config.title", new Object[0]), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/webApp/PhpWebAppRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        PhpServerComboBox phpServerComboBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.TRUE);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("RunConfigurationEditor.configuration"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/PhpBundle").getString("RunConfigurationEditor.server"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myServerComboBox = phpServerComboBox = new PhpServerComboBox();
        jPanel5.add((Component)((Object)phpServerComboBox), new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpWebAppRunConfigurationEditor.startUrl"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myResultUrl;
        jPanel6.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBrowserSelectorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("PhpWebAppRunConfigurationEditor.browser"));
        jPanel4.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStartUrlTextField = jTextField = new JTextField();
        jPanel8.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        HideableTitledPanel hideableTitledPanel = this.myPreConfigHideablePanel;
        jPanel2.add((Component)hideableTitledPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

