/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.refactoring;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.html.HtmlTagImpl;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueComponentsIndex;
import org.jetbrains.vuejs.refactoring.VueRefactoringUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016J7\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/refactoring/VueJSComponentRenameProcessor;", "Lcom/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchInCommentsAndStrings", "renameElement", "", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.vuejs"})
public final class VueJSComponentRenameProcessor
extends JSDefaultRenameProcessor {
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull((Object)usages, (String)"usages");
        for (UsageInfo usage : usages) {
            if (usage.getElement() instanceof HtmlTagImpl) {
                PsiElement psiElement = usage.getElement();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.html.HtmlTagImpl");
                }
                String string = ((HtmlTagImpl)psiElement).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(usage.element as HtmlTagImpl).name");
                PsiElement psiElement2 = usage.getElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.html.HtmlTagImpl");
                }
                if (Intrinsics.areEqual((Object)VueUtilKt.toAsset(string), (Object)((HtmlTagImpl)psiElement2).getName()) ^ true) {
                    RenameUtil.rename((UsageInfo)usage, (String)VueUtilKt.fromAsset(newName));
                    continue;
                }
            }
            RenameUtil.rename((UsageInfo)usage, (String)newName);
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Collection collection = ReferencesSearch.search((PsiElement)element).findAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ReferencesSearch.search(element).findAll()");
        return collection;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return VueRefactoringUtils.INSTANCE.isComponentName(element);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (!(psiElement instanceof JSImplicitElement)) {
            psiElement = null;
        }
        JSImplicitElement jSImplicitElement = (JSImplicitElement)psiElement;
        return jSImplicitElement != null ? (PsiElement)jSImplicitElement : (PsiElement)new JSImplicitElementImpl.Builder(element.getText(), element).setUserString(VueComponentsIndex.Companion.getJS_KEY()).toImplicitElement();
    }
}

